/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingDefaults;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.meta.strats.UntypedPCValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.Options;

public class MappingDefaultsImpl
implements MappingDefaults,
Configurable {
    protected transient DBDictionary dict = null;
    private String _baseClassStrategy = null;
    private String _subclassStrategy = null;
    private String _versionStrategy = null;
    private String _discStrategy = null;
    private final Map _fieldMap = new HashMap();
    private boolean _defMissing = false;
    private boolean _classCriteria = false;
    private int _joinFKAction = 1;
    private int _fkAction = 1;
    private boolean _defer = false;
    private boolean _indexFK = true;
    private boolean _indexDisc = true;
    private boolean _indexVers = false;
    private boolean _orderLists = true;
    private boolean _addNullInd = false;
    private boolean _ordinalEnum = false;
    private boolean _stringifyUnmapped = false;
    private DBIdentifier _dsIdName = DBIdentifier.NULL;
    private DBIdentifier _versName = DBIdentifier.NULL;
    private DBIdentifier _discName = DBIdentifier.NULL;
    private DBIdentifier _orderName = DBIdentifier.NULL;
    private DBIdentifier _nullIndName = DBIdentifier.NULL;
    private boolean _removeHungarianNotation = false;

    public boolean isRemoveHungarianNotation() {
        return this._removeHungarianNotation;
    }

    public void setRemoveHungarianNotation(boolean removeHungarianNotation) {
        this._removeHungarianNotation = removeHungarianNotation;
    }

    public String getBaseClassStrategy() {
        return this._baseClassStrategy;
    }

    public void setBaseClassStrategy(String baseClassStrategy) {
        this._baseClassStrategy = baseClassStrategy;
    }

    public String getSubclassStrategy() {
        return this._subclassStrategy;
    }

    public void setSubclassStrategy(String subclassStrategy) {
        this._subclassStrategy = subclassStrategy;
    }

    public String getVersionStrategy() {
        return this._versionStrategy;
    }

    public void setVersionStrategy(String versionStrategy) {
        this._versionStrategy = versionStrategy;
    }

    public String getDiscriminatorStrategy() {
        return this._discStrategy;
    }

    public void setDiscriminatorStrategy(String discStrategy) {
        this._discStrategy = discStrategy;
    }

    public void setFieldStrategies(String fieldMapString) {
        Options props = Configurations.parseProperties(fieldMapString);
        if (props != null) {
            this._fieldMap.putAll(props);
        }
    }

    public void setFieldStrategy(String valueType, String handlerType) {
        if (handlerType == null) {
            this._fieldMap.remove(valueType);
        } else {
            this._fieldMap.put(valueType, handlerType);
        }
    }

    public String getFieldStrategy(String valueType) {
        return (String)this._fieldMap.get(valueType);
    }

    public boolean getStoreEnumOrdinal() {
        return this._ordinalEnum;
    }

    public void setStoreEnumOrdinal(boolean ordinal) {
        this._ordinalEnum = ordinal;
    }

    public boolean getStoreUnmappedObjectIdString() {
        return this._stringifyUnmapped;
    }

    public void setStoreUnmappedObjectIdString(boolean stringify) {
        this._stringifyUnmapped = stringify;
    }

    public int getJoinForeignKeyDeleteAction() {
        return this._joinFKAction;
    }

    public void setJoinForeignKeyDeleteAction(int joinFKAction) {
        this._joinFKAction = joinFKAction;
    }

    public void setJoinForeignKeyDeleteAction(String joinFKAction) {
        this._joinFKAction = ForeignKey.getAction(joinFKAction);
    }

    public int getForeignKeyDeleteAction() {
        return this._fkAction;
    }

    public void setForeignKeyDeleteAction(int fkAction) {
        this._fkAction = fkAction;
    }

    public void setForeignKeyDeleteAction(String fkAction) {
        this._fkAction = ForeignKey.getAction(fkAction);
    }

    public boolean getIndexLogicalForeignKeys() {
        return this._indexFK;
    }

    public void setIndexLogicalForeignKeys(boolean indexFK) {
        this._indexFK = indexFK;
    }

    public boolean getIndexDiscriminator() {
        return this._indexDisc;
    }

    public void setIndexDiscriminator(boolean indexDisc) {
        this._indexDisc = indexDisc;
    }

    public boolean getIndexVersion() {
        return this._indexVers;
    }

    public void setIndexVersion(boolean indexVers) {
        this._indexVers = indexVers;
    }

    public boolean getOrderLists() {
        return this._orderLists;
    }

    public void setOrderLists(boolean orderLists) {
        this._orderLists = orderLists;
    }

    public boolean getAddNullIndicator() {
        return this._addNullInd;
    }

    public void setAddNullIndicator(boolean addNullInd) {
        this._addNullInd = addNullInd;
    }

    public boolean getDeferConstraints() {
        return this._defer;
    }

    public void setDeferConstraints(boolean defer) {
        this._defer = defer;
    }

    @Deprecated
    public String getDataStoreIdColumnName() {
        return this.getDataStoreIdColumnIdentifier().getName();
    }

    public DBIdentifier getDataStoreIdColumnIdentifier() {
        return this._dsIdName == null ? DBIdentifier.NULL : this._dsIdName;
    }

    @Deprecated
    public void setDataStoreIdColumnName(String dsIdName) {
        this.setDataStoreIdColumnIdentifier(DBIdentifier.newColumn(dsIdName));
    }

    public void setDataStoreIdColumnIdentifier(DBIdentifier dsIdName) {
        this._dsIdName = dsIdName;
    }

    @Deprecated
    public String getVersionColumnName() {
        return this.getVersionColumnIdentifier().getName();
    }

    public DBIdentifier getVersionColumnIdentifier() {
        return this._versName == null ? DBIdentifier.NULL : this._versName;
    }

    @Deprecated
    public void setVersionColumnName(String versName) {
        this.setVersionColumnIdentifier(DBIdentifier.newColumn(versName));
    }

    public void setVersionColumnIdentifier(DBIdentifier versName) {
        this._versName = versName;
    }

    @Deprecated
    public String getDiscriminatorColumnName() {
        return this.getDiscriminatorColumnIdentifier().getName();
    }

    public DBIdentifier getDiscriminatorColumnIdentifier() {
        return this._discName == null ? DBIdentifier.NULL : this._discName;
    }

    @Deprecated
    public void setDiscriminatorColumnName(String discName) {
        this.setDiscriminatorColumnIdentifier(DBIdentifier.newColumn(discName));
    }

    public void setDiscriminatorColumnIdentifier(DBIdentifier discName) {
        this._discName = discName;
    }

    @Deprecated
    public String getOrderColumnName() {
        return this.getOrderColumnIdentifier().getName();
    }

    public DBIdentifier getOrderColumnIdentifier() {
        return this._orderName == null ? DBIdentifier.NULL : this._orderName;
    }

    @Deprecated
    public void setOrderColumnName(String orderName) {
        this.setOrderColumnIdentifier(DBIdentifier.newColumn(orderName));
    }

    public void setOrderColumnIdentifier(DBIdentifier orderName) {
        this._orderName = orderName;
    }

    @Deprecated
    public String getNullIndicatorColumnName() {
        return this.getNullIndicatorColumnIdentifier().getName();
    }

    public DBIdentifier getNullIndicatorColumnIdentifier() {
        return this._nullIndName == null ? DBIdentifier.NULL : this._nullIndName;
    }

    @Deprecated
    public void setNullIndicatorColumnName(String nullIndName) {
        this.setNullIndicatorColumnIdentifier(DBIdentifier.newColumn(nullIndName));
    }

    public void setNullIndicatorColumnIdentifier(DBIdentifier nullIndName) {
        this._nullIndName = nullIndName;
    }

    @Override
    public boolean defaultMissingInfo() {
        return this._defMissing;
    }

    public void setDefaultMissingInfo(boolean defMissing) {
        this._defMissing = defMissing;
    }

    @Override
    public boolean useClassCriteria() {
        return this._classCriteria;
    }

    public void setUseClassCriteria(boolean classCriteria) {
        this._classCriteria = classCriteria;
    }

    @Override
    public Object getStrategy(ClassMapping cls, boolean adapt) {
        if (adapt || this.defaultMissingInfo()) {
            return cls.getMappedPCSuperclassMapping() == null ? this._baseClassStrategy : this._subclassStrategy;
        }
        return null;
    }

    @Override
    public Object getStrategy(Version vers, boolean adapt) {
        ClassMapping cls = vers.getClassMapping();
        if ((adapt || this.defaultMissingInfo()) && cls.getJoinablePCSuperclassMapping() == null && cls.getVersionField() == null) {
            return this._versionStrategy;
        }
        return null;
    }

    @Override
    public Object getStrategy(Discriminator disc, boolean adapt) {
        ClassMapping cls = disc.getClassMapping();
        if ((adapt || this.defaultMissingInfo()) && cls.getJoinablePCSuperclassMapping() == null && disc.getMappingInfo().getValue() == null) {
            return this._discStrategy;
        }
        return null;
    }

    @Override
    public Object getStrategy(ValueMapping vm, Class<?> type, boolean adapt) {
        Object ret = this._fieldMap.get(type.getName());
        if (ret != null) {
            return ret;
        }
        if (this._stringifyUnmapped && vm.getTypeMapping() != null && !vm.getTypeMapping().isMapped()) {
            return UntypedPCValueHandler.getInstance();
        }
        if (type.isEnum() && !vm.isSerialized()) {
            EnumValueHandler enumHandler = new EnumValueHandler();
            enumHandler.setStoreOrdinal(this._ordinalEnum);
            return enumHandler;
        }
        return null;
    }

    @Override
    public Object getDiscriminatorValue(Discriminator disc, boolean adapt) {
        if (!adapt && !this.defaultMissingInfo()) {
            return null;
        }
        String alias = ClassUtil.getClassName(disc.getClassMapping().getTypeAlias());
        switch (disc.getJavaType()) {
            case 5: {
                return alias.hashCode();
            }
            case 2: {
                return Character.valueOf(alias.charAt(0));
            }
        }
        return alias;
    }

    @Override
    public String getTableName(ClassMapping cls, Schema schema) {
        String name = ClassUtil.getClassName(cls.getDescribedType()).replace('$', '_');
        if (!this._defMissing) {
            name = this.dict.getValidTableName(name, schema);
        }
        return name;
    }

    @Override
    public DBIdentifier getTableIdentifier(ClassMapping cls, Schema schema) {
        return DBIdentifier.newTable(this.getTableName(cls, schema));
    }

    @Override
    public String getTableName(FieldMapping fm, Schema schema) {
        return this.getTableIdentifier(fm, schema).getName();
    }

    @Override
    public DBIdentifier getTableIdentifier(FieldMapping fm, Schema schema) {
        DBIdentifier sName = DBIdentifier.newTable(fm.getName());
        Table table = fm.getDefiningMapping().getTable();
        if (table != null) {
            DBIdentifier tableName = DBIdentifier.truncate(table.getIdentifier(), 5);
            sName = DBIdentifier.append(tableName, fm.getName());
        }
        if (!this._defMissing) {
            sName = this.dict.getValidTableName(sName, schema);
        }
        return sName;
    }

    @Override
    public void populateDataStoreIdColumns(ClassMapping cls, Table table, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!DBIdentifier.isNull(this._dsIdName) && cols.length == 1) {
                cols[i].setIdentifier(this._dsIdName);
            } else if (!DBIdentifier.isNull(this._dsIdName)) {
                cols[i].setIdentifier(DBIdentifier.append(this._dsIdName, Integer.toString(i)));
            }
            this.correctName(table, cols[i]);
        }
    }

    protected void correctName(Table table, Column col) {
        if (!this._defMissing || this._removeHungarianNotation) {
            DBIdentifier name = col.getIdentifier();
            if (this._removeHungarianNotation) {
                name = DBIdentifier.removeHungarianNotation(name);
            }
            DBIdentifier correctedName = this.dict.getValidColumnName(name, table);
            col.setIdentifier(correctedName);
            table.addCorrectedColumnName(correctedName, true);
        }
    }

    protected String removeHungarianNotation(String columnName) {
        return Normalizer.removeHungarianNotation(columnName);
    }

    @Override
    public void populateColumns(Version vers, Table table, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!DBIdentifier.isNull(this._versName) && cols.length == 1) {
                cols[i].setIdentifier(this._versName);
            } else if (!DBIdentifier.isNull(this._versName)) {
                if (i == 0) {
                    cols[i].setIdentifier(this._versName);
                } else {
                    cols[i].setIdentifier(DBIdentifier.append(this._versName, Integer.toString(i)));
                }
            } else if (!DBIdentifier.isNull(this._versName)) {
                cols[i].setIdentifier(DBIdentifier.append(this._versName, Integer.toString(i)));
            }
            this.correctName(table, cols[i]);
        }
    }

    @Override
    public void populateColumns(Discriminator disc, Table table, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!DBIdentifier.isNull(this._discName) && cols.length == 1) {
                cols[i].setIdentifier(this._discName);
            } else if (!DBIdentifier.isNull(this._discName)) {
                cols[i].setIdentifier(DBIdentifier.append(this._discName, Integer.toString(i)));
            }
            this.correctName(table, cols[i]);
        }
    }

    @Override
    public void populateJoinColumn(ClassMapping cm, Table local, Table foreign, Column col, Object target, int pos, int cols) {
        this.correctName(local, col);
    }

    @Override
    public void populateJoinColumn(FieldMapping fm, Table local, Table foreign, Column col, Object target, int pos, int cols) {
        this.correctName(local, col);
    }

    @Override
    @Deprecated
    public void populateForeignKeyColumn(ValueMapping vm, String name, Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
        this.populateForeignKeyColumn(vm, DBIdentifier.newColumn(name), local, foreign, col, target, inverse, pos, cols);
    }

    @Override
    public void populateForeignKeyColumn(ValueMapping vm, DBIdentifier name, Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
        if (cols == 1) {
            col.setIdentifier(name);
        } else if (target instanceof Column) {
            col.setIdentifier(DBIdentifier.combine(name, ((Column)target).getIdentifier().getName()));
        }
        this.correctName(local, col);
    }

    @Override
    public void populateColumns(ValueMapping vm, String name, Table table, Column[] cols) {
        this.populateColumns(vm, DBIdentifier.newColumn(name), table, cols);
    }

    @Override
    public void populateColumns(ValueMapping vm, DBIdentifier name, Table table, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            this.correctName(table, cols[i]);
        }
    }

    @Override
    public boolean populateOrderColumns(FieldMapping fm, Table table, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!DBIdentifier.isNull(this._orderName) && cols.length == 1) {
                cols[i].setIdentifier(this._orderName);
            } else if (!DBIdentifier.isNull(this._orderName)) {
                cols[i].setIdentifier(DBIdentifier.append(this._orderName, Integer.toString(i)));
            }
            this.correctName(table, cols[i]);
        }
        return this._orderLists && (11 == fm.getTypeCode() || List.class.isAssignableFrom(fm.getType()));
    }

    @Override
    @Deprecated
    public boolean populateNullIndicatorColumns(ValueMapping vm, String name, Table table, Column[] cols) {
        return this.populateNullIndicatorColumns(vm, DBIdentifier.newColumn(name), table, cols);
    }

    @Override
    public boolean populateNullIndicatorColumns(ValueMapping vm, DBIdentifier name, Table table, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!DBIdentifier.isNull(this._nullIndName) && cols.length == 1) {
                cols[i].setIdentifier(this._nullIndName);
            } else if (!DBIdentifier.isNull(this._nullIndName)) {
                cols[i].setIdentifier(DBIdentifier.append(this._nullIndName, Integer.toString(i)));
            }
            this.correctName(table, cols[i]);
        }
        return this._addNullInd;
    }

    @Override
    public ForeignKey getJoinForeignKey(ClassMapping cls, Table local, Table foreign) {
        if (this._joinFKAction == 1) {
            return null;
        }
        ForeignKey fk = new ForeignKey();
        fk.setDeleteAction(this._joinFKAction);
        fk.setDeferred(this._defer);
        return fk;
    }

    @Override
    public ForeignKey getJoinForeignKey(FieldMapping fm, Table local, Table foreign) {
        if (this._joinFKAction == 1) {
            return null;
        }
        ForeignKey fk = new ForeignKey();
        fk.setDeleteAction(this._joinFKAction);
        fk.setDeferred(this._defer);
        return fk;
    }

    @Override
    @Deprecated
    public ForeignKey getForeignKey(ValueMapping vm, String name, Table local, Table foreign, boolean inverse) {
        return this.getForeignKey(vm, DBIdentifier.newForeignKey(name), local, foreign, inverse);
    }

    @Override
    public ForeignKey getForeignKey(ValueMapping vm, DBIdentifier name, Table local, Table foreign, boolean inverse) {
        if (this._fkAction == 1) {
            return null;
        }
        ForeignKey fk = new ForeignKey();
        fk.setDeleteAction(this._fkAction);
        fk.setDeferred(this._defer);
        return fk;
    }

    @Override
    public Index getJoinIndex(FieldMapping fm, Table table, Column[] cols) {
        if (!this._indexFK || fm.getJoinForeignKey() == null || !fm.getJoinForeignKey().isLogical()) {
            return null;
        }
        if (this.areAllPrimaryKeyColumns(cols)) {
            return null;
        }
        Index idx = new Index();
        idx.setIdentifier(this.getIndexName(DBIdentifier.NULL, table, cols));
        return idx;
    }

    protected boolean areAllPrimaryKeyColumns(Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    protected String getIndexName(String name, Table table, Column[] cols) {
        return this.getIndexName(DBIdentifier.newIndex(name), table, cols).getName();
    }

    protected DBIdentifier getIndexName(DBIdentifier name, Table table, Column[] cols) {
        DBIdentifier sName = name;
        if (DBIdentifier.isNull(sName)) {
            sName = cols[0].getIdentifier();
        }
        if (this._removeHungarianNotation) {
            sName = DBIdentifier.removeHungarianNotation(sName);
        }
        return this.dict.getValidIndexName(sName, table);
    }

    @Override
    @Deprecated
    public Index getIndex(ValueMapping vm, String name, Table table, Column[] cols) {
        return this.getIndex(vm, DBIdentifier.newIndex(name), table, cols);
    }

    @Override
    public Index getIndex(ValueMapping vm, DBIdentifier name, Table table, Column[] cols) {
        if (!this._indexFK || vm.getForeignKey() == null || !vm.getForeignKey().isLogical()) {
            return null;
        }
        if (this.areAllPrimaryKeyColumns(cols)) {
            return null;
        }
        Index idx = new Index();
        idx.setIdentifier(this.getIndexName(name, table, cols));
        return idx;
    }

    @Override
    public Index getIndex(Version vers, Table table, Column[] cols) {
        if (!this._indexVers) {
            return null;
        }
        Index idx = new Index();
        idx.setIdentifier(this.getIndexName(this._versName, table, cols));
        return idx;
    }

    @Override
    public Index getIndex(Discriminator disc, Table table, Column[] cols) {
        if (!this._indexDisc) {
            return null;
        }
        Index idx = new Index();
        idx.setIdentifier(this.getIndexName(this._discName, table, cols));
        return idx;
    }

    @Override
    public Unique getJoinUnique(FieldMapping fm, Table table, Column[] cols) {
        return null;
    }

    @Override
    @Deprecated
    public Unique getUnique(ValueMapping vm, String name, Table table, Column[] cols) {
        return null;
    }

    @Override
    public Unique getUnique(ValueMapping vm, DBIdentifier name, Table table, Column[] cols) {
        return null;
    }

    @Override
    @Deprecated
    public String getPrimaryKeyName(ClassMapping cm, Table table) {
        return null;
    }

    @Override
    public DBIdentifier getPrimaryKeyIdentifier(ClassMapping cm, Table table) {
        return DBIdentifier.NULL;
    }

    @Override
    public void installPrimaryKey(FieldMapping fm, Table table) {
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.dict = ((JDBCConfiguration)conf).getDBDictionaryInstance();
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }
}

