/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.AbstractResult;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;

public class ResultSetResult
extends AbstractResult {
    private final Connection _conn;
    private final Statement _stmnt;
    private final ResultSet _rs;
    private final DBDictionary _dict;
    private boolean _closeStatement = true;
    private boolean _closeConn = true;
    private int _row = -1;
    private int _size = -1;
    private JDBCStore _store = null;

    public ResultSetResult(Connection conn, Statement stmnt, ResultSet rs, DBDictionary dict) {
        if (stmnt == null) {
            try {
                stmnt = rs.getStatement();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._conn = conn;
        this._stmnt = stmnt;
        this._rs = rs;
        this._dict = dict;
    }

    public ResultSetResult(Connection conn, Statement stmnt, ResultSet rs, JDBCStore store) {
        this(conn, stmnt, rs, store.getDBDictionary());
        this.setStore(store);
    }

    public ResultSetResult(Connection conn, ResultSet rs, DBDictionary dict) {
        this._conn = conn;
        this._stmnt = null;
        this._rs = rs;
        this._dict = dict;
    }

    public ResultSetResult(ResultSet rs, DBDictionary dict) throws SQLException {
        this._stmnt = rs.getStatement();
        this._conn = this._stmnt.getConnection();
        this._rs = rs;
        this._dict = dict;
    }

    public ResultSetResult(ResultSet rs, JDBCStore store) throws SQLException {
        this(rs, store.getDBDictionary());
        this.setStore(store);
    }

    public Statement getStatement() {
        return this._stmnt;
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public DBDictionary getDBDictionary() {
        return this._dict;
    }

    public JDBCStore getStore() {
        return this._store;
    }

    public void setStore(JDBCStore store) {
        this._store = store;
    }

    public boolean getCloseConnection() {
        return this._closeConn;
    }

    public void setCloseConnection(boolean closeConn) {
        this._closeConn = closeConn;
    }

    public void setCloseStatement(boolean closeStatement) {
        this._closeStatement = closeStatement;
    }

    @Override
    public void close() {
        super.close();
        try {
            this._rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this._stmnt != null && this._closeStatement) {
            try {
                this._stmnt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this._closeConn) {
            try {
                this._conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean supportsRandomAccess() throws SQLException {
        return this._rs.getType() != 1003;
    }

    @Override
    protected boolean absoluteInternal(int row) throws SQLException {
        if (row == ++this._row) {
            return this._rs.next();
        }
        this._rs.absolute(row + 1);
        if (this._rs.getRow() == 0) {
            this._row = -1;
            return false;
        }
        this._row = row;
        return true;
    }

    @Override
    protected boolean nextInternal() throws SQLException {
        ++this._row;
        return this._rs.next();
    }

    @Override
    public int size() throws SQLException {
        if (this._size == -1) {
            this._rs.last();
            this._size = this._rs.getRow();
            if (this._row == -1) {
                this._rs.beforeFirst();
            } else {
                this._rs.absolute(this._row + 1);
            }
        }
        return this._size;
    }

    @Override
    protected boolean containsInternal(Object obj, Joins joins) throws SQLException {
        return ((Number)this.translate(obj, joins)).intValue() > 0;
    }

    @Override
    protected Array getArrayInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getArray(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected InputStream getAsciiStreamInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getAsciiStream(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected BigDecimal getBigDecimalInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getBigDecimal(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Number getNumberInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getNumber(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected BigInteger getBigIntegerInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getBigInteger(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected InputStream getBinaryStreamInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getBinaryStream(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Blob getBlobInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getBlob(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected boolean getBooleanInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getBoolean(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected byte getByteInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getByte(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected byte[] getBytesInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getBytes(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Calendar getCalendarInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getCalendar(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected LocalDate getLocalDateInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getLocalDate(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected LocalTime getLocalTimeInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getLocalTime(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected LocalDateTime getLocalDateTimeInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getLocalDateTime(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected OffsetTime getOffsetTimeInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getOffsetTime(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected OffsetDateTime getOffsetDateTimeInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getOffsetDateTime(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected char getCharInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getChar(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Reader getCharacterStreamInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getCharacterStream(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Clob getClobInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getClob(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected java.util.Date getDateInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getDate(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Date getDateInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return this._dict.getDate(this._rs, ((Number)obj).intValue(), cal);
    }

    @Override
    protected double getDoubleInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getDouble(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected float getFloatInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getFloat(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected int getIntInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getInt(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Locale getLocaleInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getLocale(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected long getLongInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getLong(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Object getStreamInternal(JDBCStore store, Object obj, int metaTypeCode, Object arg, Joins joins) throws SQLException {
        return this.getLOBStreamInternal(store, obj, joins);
    }

    @Override
    protected Object getObjectInternal(Object obj, int metaTypeCode, Object arg, Joins joins) throws SQLException {
        if (metaTypeCode == -1 && obj instanceof Column) {
            metaTypeCode = ((Column)obj).getJavaType();
        }
        boolean isClob = obj instanceof Column ? ((Column)obj).getType() == 2005 && !((Column)obj).isXML() : false;
        obj = this.translate(obj, joins);
        Constable val = null;
        switch (metaTypeCode) {
            case 0: 
            case 16: {
                val = this.getBooleanInternal(obj, joins) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: 
            case 17: {
                val = new Byte(this.getByteInternal(obj, joins));
                break;
            }
            case 2: 
            case 18: {
                val = new Character(this.getCharInternal(obj, joins));
                break;
            }
            case 3: 
            case 19: {
                val = new Double(this.getDoubleInternal(obj, joins));
                break;
            }
            case 4: 
            case 20: {
                val = new Float(this.getFloatInternal(obj, joins));
                break;
            }
            case 5: 
            case 21: {
                val = Integer.valueOf(this.getIntInternal(obj, joins));
                break;
            }
            case 6: 
            case 22: {
                val = Long.valueOf(this.getLongInternal(obj, joins));
                break;
            }
            case 7: 
            case 23: {
                val = new Short(this.getShortInternal(obj, joins));
                break;
            }
            case 9: {
                return this.getStringInternal(obj, joins, isClob);
            }
            case 8: {
                return this._dict.getBlobObject(this._rs, ((Number)obj).intValue(), this._store);
            }
            case 14: {
                return this.getDateInternal(obj, joins);
            }
            case 28: {
                return this.getCalendarInternal(obj, joins);
            }
            case 33: {
                return this.getLocalDateInternal(obj, joins);
            }
            case 34: {
                return this.getLocalTimeInternal(obj, joins);
            }
            case 35: {
                return this.getLocalDateTimeInternal(obj, joins);
            }
            case 36: {
                return this.getOffsetTimeInternal(obj, joins);
            }
            case 37: {
                return this.getOffsetDateTimeInternal(obj, joins);
            }
            case 24: {
                return this.getBigDecimalInternal(obj, joins);
            }
            case 10: {
                return this.getNumberInternal(obj, joins);
            }
            case 25: {
                return this.getBigIntegerInternal(obj, joins);
            }
            case 26: {
                return this.getLocaleInternal(obj, joins);
            }
            case 1000: {
                return this.getArrayInternal(obj, joins);
            }
            case 1001: {
                return this.getAsciiStreamInternal(obj, joins);
            }
            case 1002: {
                return this.getBinaryStreamInternal(obj, joins);
            }
            case 1003: {
                return this.getBlobInternal(obj, joins);
            }
            case 1004: {
                return this.getBytesInternal(obj, joins);
            }
            case 1005: {
                return this.getCharacterStreamInternal(obj, joins);
            }
            case 1006: {
                return this.getClobInternal(obj, joins);
            }
            case 1007: {
                return this.getDateInternal(obj, (Calendar)arg, joins);
            }
            case 1008: {
                return this.getSQLObjectInternal(obj, (Map)arg, joins);
            }
            case 1009: {
                return this.getRefInternal(obj, (Map)arg, joins);
            }
            case 1010: {
                return this.getTimeInternal(obj, (Calendar)arg, joins);
            }
            case 1011: {
                return this.getTimestampInternal(obj, (Calendar)arg, joins);
            }
            default: {
                Column col;
                if (obj instanceof Column && ((col = (Column)obj).getType() == 2004 || col.getType() == -3)) {
                    return this._dict.getBlobObject(this._rs, col.getIndex(), this._store);
                }
                return this._dict.getObject(this._rs, ((Number)obj).intValue(), null);
            }
        }
        return this._rs.wasNull() ? null : val;
    }

    @Override
    protected Object getSQLObjectInternal(Object obj, Map map, Joins joins) throws SQLException {
        return this._dict.getObject(this._rs, ((Number)obj).intValue(), map);
    }

    @Override
    protected Ref getRefInternal(Object obj, Map map, Joins joins) throws SQLException {
        return this._dict.getRef(this._rs, ((Number)obj).intValue(), map);
    }

    @Override
    protected short getShortInternal(Object obj, Joins joins) throws SQLException {
        return this._dict.getShort(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected String getStringInternal(Object obj, Joins joins, boolean isClobString) throws SQLException {
        if (isClobString) {
            return this._dict.getClobString(this._rs, ((Number)obj).intValue());
        }
        return this._dict.getString(this._rs, ((Number)obj).intValue());
    }

    @Override
    protected Time getTimeInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return this._dict.getTime(this._rs, ((Number)obj).intValue(), cal);
    }

    @Override
    protected Timestamp getTimestampInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return this._dict.getTimestamp(this._rs, ((Number)obj).intValue(), cal);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._rs.wasNull();
    }

    @Override
    protected Object translate(Object obj, Joins joins) throws SQLException {
        if (obj instanceof Number) {
            return obj;
        }
        return this.findObject(obj, joins);
    }

    protected int findObject(Object obj, Joins joins) throws SQLException {
        try {
            String s1 = obj.toString();
            DBIdentifier sName = DBIdentifier.newColumn(obj.toString());
            return this.getResultSet().findColumn(this._dict.convertSchemaCase(sName));
        }
        catch (SQLException se) {
            this._dict.log.trace(se.getMessage());
            return 0;
        }
    }

    @Override
    protected InputStream getLOBStreamInternal(JDBCStore store, Object obj, Joins joins) throws SQLException {
        return this._dict.getLOBStream(store, this._rs, ((Number)obj).intValue());
    }
}

