/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Max;
import java.math.BigDecimal;

public class MaxValidatorForString
implements ConstraintValidator<Max, String> {
    private long max;

    @Override
    public void initialize(Max annotation) {
        this.max = annotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(BigDecimal.valueOf(this.max)) < 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

