/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.TableJDBCSeq;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;

public class ValueTableJDBCSeq
extends TableJDBCSeq {
    public static final String PK_VALUE = "PrimaryKeyValue";
    private static final Localizer _loc = Localizer.forPackage((Class)ValueTableJDBCSeq.class);
    private String _value = "DEFAULT";

    public ValueTableJDBCSeq() {
        this.setTable("OPENJPA_SEQUENCES_TABLE");
    }

    public String getPrimaryKeyValue() {
        return this._value;
    }

    public void setPrimaryKeyValue(String value) {
        this._value = value;
    }

    protected Column addPrimaryKeyColumn(Table table) {
        DBDictionary dict = this.getConfiguration().getDBDictionaryInstance();
        Column pkColumn = table.addColumn(dict.getValidColumnName(this.getPrimaryKeyColumn(), table));
        pkColumn.setType(dict.getPreferredType(12));
        pkColumn.setJavaType(9);
        pkColumn.setSize(dict.characterColumnSize);
        return pkColumn;
    }

    protected Object getPrimaryKey(ClassMapping mapping) {
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options opts = new Options();
        args = opts.setFromCmdLine(args);
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        try {
            if (!ValueTableJDBCSeq.run((JDBCConfiguration)conf, args, opts)) {
                System.out.println(_loc.get("clstable-seq-usage"));
            }
        }
        finally {
            conf.close();
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws Exception {
        if (opts.containsKey((Object)"help") || opts.containsKey((Object)"-help")) {
            return false;
        }
        String action = opts.removeProperty("action", "a", null);
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        return ValueTableJDBCSeq.run(conf, args, action, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(JDBCConfiguration conf, String[] args, String action, MappingRepository repos, ClassLoader loader) throws Exception {
        ValueTableJDBCSeq seq = new ValueTableJDBCSeq();
        String props = Configurations.getProperties((String)conf.getSequence());
        Configurations.configureInstance((Object)seq, (Configuration)conf, (String)props);
        if ("drop".equals(action)) {
            if (args.length != 0) {
                return false;
            }
            seq.dropTable();
        } else if ("add".equals(action)) {
            if (args.length != 0) {
                return false;
            }
            seq.refreshTable();
        } else if ("get".equals(action) || "set".equals(action)) {
            if (args.length > 0) {
                seq.setPrimaryKeyValue(args[0]);
            }
            Connection conn = conf.getDataSource2(null).getConnection();
            try {
                long cur = seq.getSequence(null, conn);
                if ("get".equals(action)) {
                    System.out.println(seq.getPrimaryKeyValue() + ": " + cur);
                }
                long set = args.length > 1 ? Long.parseLong(args[1]) : cur + (long)seq.getAllocate();
                if (set < cur) {
                    set = cur;
                } else {
                    TableJDBCSeq.Status stat = seq.getStatus(null);
                    seq.setSequence(null, stat, (int)(set - cur), true, conn);
                    set = stat.seq;
                }
                System.err.println(seq.getPrimaryKeyValue() + ": " + set);
            }
            catch (NumberFormatException nfe) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        } else {
            return false;
        }
        return true;
    }
}

