/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.ClassStrategy;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.NoneClassStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.OpenJPAId;

public class ClassMapping
extends ClassMetaData
implements ClassStrategy {
    public static final ClassMapping[] EMPTY_MAPPINGS = new ClassMapping[0];
    private static final Localizer _loc = Localizer.forPackage((Class)ClassMapping.class);
    private final ClassMappingInfo _info;
    private final Discriminator _discrim;
    private final Version _version;
    private ClassStrategy _strategy = null;
    private Table _table = null;
    private ColumnIO _io = null;
    private Column[] _cols = Schemas.EMPTY_COLUMNS;
    private ForeignKey _fk = null;
    private int _subclassMode = Integer.MAX_VALUE;
    private ClassMapping[] _joinSubMaps = null;
    private ClassMapping[] _assignMaps = null;
    private final Map _joinables = Collections.synchronizedMap(new HashMap());

    protected ClassMapping(Class type, MappingRepository repos) {
        super(type, (MetaDataRepository)repos);
        this._discrim = repos.newDiscriminator(this);
        this._version = repos.newVersion(this);
        this._info = repos.newMappingInfo(this);
    }

    protected ClassMapping(ValueMetaData vmd) {
        super(vmd);
        this._discrim = this.getMappingRepository().newDiscriminator(this);
        this._version = this.getMappingRepository().newVersion(this);
        this._info = this.getMappingRepository().newMappingInfo(this);
    }

    public Discriminator getDiscriminator() {
        return this._discrim;
    }

    public Version getVersion() {
        return this._version;
    }

    public Object getObjectId(JDBCStore store, Result res, ForeignKey fk, boolean subs, Joins joins) throws SQLException {
        ValueMapping embed = this.getEmbeddingMapping();
        if (embed != null) {
            return embed.getFieldMapping().getDefiningMapping().getObjectId(store, res, fk, subs, joins);
        }
        return this.getObjectId(this, store, res, fk, subs, joins);
    }

    private Object getObjectId(ClassMapping cls, JDBCStore store, Result res, ForeignKey fk, boolean subs, Joins joins) throws SQLException {
        if (!this.isPrimaryKeyObjectId(true)) {
            return this.getPCSuperclassMapping().getObjectId(cls, store, res, fk, subs, joins);
        }
        if (this.getIdentityType() == 0) {
            throw new InternalException();
        }
        Column[] pks = this.getPrimaryKeyColumns();
        if (this.getIdentityType() == 1) {
            Column col = fk == null ? pks[0] : fk.getColumn(pks[0]);
            long id = res.getLong(col, joins);
            return id == 0L && res.wasNull() ? null : store.newDataStoreId(id, cls, subs);
        }
        Object[] vals = new Object[this.getPrimaryKeyFields().length];
        for (int i = 0; i < pks.length; ++i) {
            Joinable join = this.assertJoinable(pks[i]);
            FieldMapping fm = this.getFieldMapping(join.getFieldIndex());
            int pkIdx = fm.getPrimaryKeyIndex();
            if (vals[pkIdx] != null) continue;
            res.startDataRequest(fm);
            vals[pkIdx] = join.getPrimaryKeyValue(res, join.getColumns(), fk, store, joins);
            res.endDataRequest();
            if (vals[pkIdx] != null) continue;
            return null;
        }
        Object oid = ApplicationIds.fromPKValues((Object[])vals, (ClassMetaData)cls);
        if (oid instanceof OpenJPAId) {
            Class type = cls.getDescribedType();
            if (!subs) {
                ((OpenJPAId)oid).setManagedInstanceType(type);
            } else if (cls.getDiscriminator() != null && !StringUtils.equals((String)"none", (String)cls.getDiscriminator().getStrategy().getAlias())) {
                res.startDataRequest(cls.getDiscriminator());
                try {
                    type = cls.getDiscriminator().getClass(store, cls, res);
                    ((OpenJPAId)oid).setManagedInstanceType(type, true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                res.endDataRequest();
            }
        }
        return oid;
    }

    public Object toDataStoreValue(Object obj, Column[] cols, JDBCStore store) {
        Object ret = cols.length == 1 ? null : new Object[cols.length];
        OpenJPAStateManager sm = ImplHelper.isManageable((Object)obj) ? (OpenJPAStateManager)ImplHelper.toPersistenceCapable((Object)obj, (Object)this.getRepository().getConfiguration()).pcGetStateManager() : store.getContext().getStateManager(obj);
        if (sm == null) {
            return ret;
        }
        for (int i = 0; i < cols.length; ++i) {
            Object val = this.assertJoinable(cols[i]).getJoinValue(sm, cols[i], store);
            if (cols.length == 1) {
                ret = val;
                continue;
            }
            ret[i] = val;
        }
        return ret;
    }

    public Joinable assertJoinable(Column col) {
        Joinable join = this.getJoinable(col);
        if (join == null) {
            throw new MetaDataException(_loc.get("no-joinable", (Object)col.getFullName()));
        }
        return join;
    }

    public Joinable getJoinable(Column col) {
        Joinable join;
        if (this.getEmbeddingMetaData() != null && (join = this.getEmbeddingMapping().getFieldMapping().getDefiningMapping().getJoinable(col)) != null) {
            return join;
        }
        ClassMapping sup = this.getJoinablePCSuperclassMapping();
        if (sup != null && (join = sup.getJoinable(col)) != null) {
            return join;
        }
        return (Joinable)this._joinables.get(col);
    }

    public void setJoinable(Column col, Joinable joinable) {
        Joinable join = (Joinable)this._joinables.get(col);
        if (join == null || join.getFieldIndex() != -1 && this.getField(join.getFieldIndex()).getPrimaryKeyIndex() == -1) {
            this._joinables.put(col, joinable);
        }
    }

    public Boolean isForeignKeyObjectId(ForeignKey fk) {
        if (this.getIdentityType() == 0 || !this.isPrimaryKeyObjectId(false)) {
            return Boolean.FALSE;
        }
        Column[] cols = fk.getPrimaryKeyColumns();
        if (this.getIdentityType() == 1) {
            if (cols.length != 1 || cols[0] != this.getPrimaryKeyColumns()[0]) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        for (int i = 0; i < cols.length; ++i) {
            Joinable join = this.assertJoinable(cols[i]);
            if (join.getFieldIndex() == -1 || this.getField(join.getFieldIndex()).getPrimaryKeyIndex() != -1) continue;
            return Boolean.FALSE;
        }
        if (this.isPrimaryKeyObjectId(true) && cols.length == this.getPrimaryKeyColumns().length) {
            return Boolean.TRUE;
        }
        return null;
    }

    public ClassMappingInfo getMappingInfo() {
        return this._info;
    }

    public ClassStrategy getStrategy() {
        return this._strategy;
    }

    public void setStrategy(ClassStrategy strategy, Boolean adapt) {
        ClassStrategy orig = this._strategy;
        this._strategy = strategy;
        if (strategy != null) {
            try {
                strategy.setClassMapping(this);
                if (adapt != null) {
                    strategy.map(adapt);
                }
            }
            catch (RuntimeException re) {
                this._strategy = orig;
                throw re;
            }
        }
    }

    public Table getTable() {
        return this._table;
    }

    public void setTable(Table table) {
        this._table = table;
    }

    public Column[] getPrimaryKeyColumns() {
        if (this._cols.length == 0 && this.getIdentityType() == 2 && this.isMapped()) {
            FieldMapping[] pks = this.getPrimaryKeyFieldMappings();
            ArrayList<Column> cols = new ArrayList<Column>(pks.length);
            for (int i = 0; i < pks.length; ++i) {
                Column[] fieldCols = pks[i].getColumns();
                for (int j = 0; j < fieldCols.length; ++j) {
                    cols.add(fieldCols[j]);
                }
            }
            this._cols = cols.toArray(new Column[cols.size()]);
        }
        return this._cols;
    }

    public void setPrimaryKeyColumns(Column[] cols) {
        if (cols == null) {
            cols = Schemas.EMPTY_COLUMNS;
        }
        this._cols = cols;
    }

    public ColumnIO getColumnIO() {
        return this._io == null ? ColumnIO.UNRESTRICTED : this._io;
    }

    public void setColumnIO(ColumnIO io) {
        this._io = io;
    }

    public ForeignKey getJoinForeignKey() {
        return this._fk;
    }

    public void setJoinForeignKey(ForeignKey fk) {
        this._fk = fk;
    }

    public void refSchemaComponents() {
        if (this.getEmbeddingMetaData() == null) {
            if (this._table != null && this._table.getPrimaryKey() != null) {
                this._table.getPrimaryKey().ref();
            }
            if (this._fk != null) {
                this._fk.ref();
            }
            Column[] pks = this.getPrimaryKeyColumns();
            for (int i = 0; i < pks.length; ++i) {
                pks[i].ref();
            }
        } else {
            FieldMapping[] fields = this.getFieldMappings();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].refSchemaComponents();
            }
        }
    }

    public void clearMapping() {
        this._strategy = null;
        this._cols = Schemas.EMPTY_COLUMNS;
        this._fk = null;
        this._table = null;
        this._info.clear();
        this.setResolve(10, false);
    }

    public void syncMappingInfo() {
        if (this.getEmbeddingMetaData() == null) {
            this._info.syncWith(this);
        } else {
            this._info.clear();
            FieldMapping[] fields = this.getFieldMappings();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].syncMappingInfo();
            }
        }
    }

    protected void setDescribedType(Class type) {
        super.setDescribedType(type);
        if (this._info != null) {
            this._info.setClassName(type.getName());
        }
    }

    public int getSubclassFetchMode() {
        if (this._subclassMode == Integer.MAX_VALUE) {
            this._subclassMode = this.getPCSuperclass() != null ? this.getPCSuperclassMapping().getSubclassFetchMode() : -99;
        }
        return this._subclassMode;
    }

    public void setSubclassFetchMode(int mode) {
        this._subclassMode = mode;
    }

    public MappingRepository getMappingRepository() {
        return (MappingRepository)this.getRepository();
    }

    public ValueMapping getEmbeddingMapping() {
        return (ValueMapping)this.getEmbeddingMetaData();
    }

    public boolean isMapped() {
        if (!super.isMapped()) {
            return false;
        }
        if (this._strategy != null) {
            return this._strategy != NoneClassStrategy.getInstance();
        }
        return !"none".equals(this._info.getStrategy());
    }

    public ClassMapping getPCSuperclassMapping() {
        return (ClassMapping)this.getPCSuperclassMetaData();
    }

    public ClassMapping getMappedPCSuperclassMapping() {
        return (ClassMapping)this.getMappedPCSuperclassMetaData();
    }

    public ClassMapping getJoinablePCSuperclassMapping() {
        ClassMapping sup = this.getMappedPCSuperclassMapping();
        if (sup == null) {
            return null;
        }
        if (this._fk != null || this._table == null || this._table.equals(sup.getTable())) {
            return sup;
        }
        return null;
    }

    public ClassMapping[] getPCSubclassMappings() {
        return (ClassMapping[])this.getPCSubclassMetaDatas();
    }

    public ClassMapping[] getMappedPCSubclassMappings() {
        return (ClassMapping[])this.getMappedPCSubclassMetaDatas();
    }

    public ClassMapping[] getJoinablePCSubclassMappings() {
        ClassMapping[] subs = this.getMappedPCSubclassMappings();
        if (this._joinSubMaps == null) {
            if (subs.length == 0) {
                this._joinSubMaps = subs;
            } else {
                ArrayList<ClassMapping> joinable = new ArrayList<ClassMapping>(subs.length);
                for (int i = 0; i < subs.length; ++i) {
                    if (!this.isSubJoinable(subs[i])) continue;
                    joinable.add(subs[i]);
                }
                this._joinSubMaps = joinable.toArray(new ClassMapping[joinable.size()]);
            }
        }
        return this._joinSubMaps;
    }

    private boolean isSubJoinable(ClassMapping sub) {
        if (sub == null) {
            return false;
        }
        if (sub == this) {
            return true;
        }
        return this.isSubJoinable(sub.getJoinablePCSuperclassMapping());
    }

    public ClassMapping[] getIndependentAssignableMappings() {
        ClassMapping[] subs = this.getMappedPCSubclassMappings();
        if (this._assignMaps == null) {
            if (subs.length == 0) {
                this._assignMaps = this.isMapped() ? new ClassMapping[]{this} : subs;
            } else {
                int size = (int)((double)subs.length * 1.33 + 2.0);
                LinkedHashSet<ClassMapping> independent = new LinkedHashSet<ClassMapping>(size);
                if (this.isMapped()) {
                    independent.add(this);
                }
                independent.addAll(Arrays.asList(subs));
                ArrayList<ClassMapping> clear = null;
                Iterator itr = independent.iterator();
                while (itr.hasNext()) {
                    ClassMapping map = (ClassMapping)itr.next();
                    ClassMapping sup = map.getJoinablePCSuperclassMapping();
                    if (sup == null || !independent.contains(sup)) continue;
                    if (clear == null) {
                        clear = new ArrayList<ClassMapping>(independent.size() - 1);
                    }
                    clear.add(map);
                }
                if (clear != null) {
                    independent.removeAll(clear);
                }
                this._assignMaps = independent.toArray(new ClassMapping[independent.size()]);
            }
        }
        return this._assignMaps;
    }

    public FieldMapping[] getFieldMappings() {
        return (FieldMapping[])this.getFields();
    }

    public FieldMapping[] getDeclaredFieldMappings() {
        return (FieldMapping[])this.getDeclaredFields();
    }

    public FieldMapping[] getPrimaryKeyFieldMappings() {
        return (FieldMapping[])this.getPrimaryKeyFields();
    }

    public FieldMapping getVersionFieldMapping() {
        return (FieldMapping)this.getVersionField();
    }

    public FieldMapping[] getDefaultFetchGroupFieldMappings() {
        return (FieldMapping[])this.getDefaultFetchGroupFields();
    }

    public FieldMapping[] getDefinedFieldMappings() {
        return (FieldMapping[])this.getDefinedFields();
    }

    public FieldMapping[] getFieldMappingsInListingOrder() {
        return (FieldMapping[])this.getFieldsInListingOrder();
    }

    public FieldMapping[] getDefinedFieldMappingsInListingOrder() {
        return (FieldMapping[])this.getDefinedFieldsInListingOrder();
    }

    public FieldMapping getFieldMapping(int index) {
        return (FieldMapping)this.getField(index);
    }

    public FieldMapping getDeclaredFieldMapping(int index) {
        return (FieldMapping)this.getDeclaredField(index);
    }

    public FieldMapping getFieldMapping(String name) {
        return (FieldMapping)this.getField(name);
    }

    public FieldMapping getDeclaredFieldMapping(String name) {
        return (FieldMapping)this.getDeclaredField(name);
    }

    public FieldMapping[] getDeclaredUnmanagedFieldMappings() {
        return (FieldMapping[])this.getDeclaredUnmanagedFields();
    }

    public FieldMapping addDeclaredFieldMapping(String name, Class type) {
        return (FieldMapping)this.addDeclaredField(name, type);
    }

    protected void resolveMapping(boolean runtime) {
        int i;
        Log log;
        super.resolveMapping(runtime);
        MappingRepository repos = this.getMappingRepository();
        if (this._strategy == null) {
            repos.getStrategyInstaller().installStrategy(this);
        }
        if ((log = this.getRepository().getLog()).isTraceEnabled()) {
            log.trace((Object)_loc.get("strategy", (Object)this, (Object)this._strategy.getAlias()));
        }
        this.defineSuperclassFields(this.getJoinablePCSuperclassMapping() == null);
        this.resolveNonRelationMappings();
        FieldMapping[] fms = this.getFieldMappings();
        for (i = 0; i < fms.length; ++i) {
            if (fms[i].getDefiningMetaData() != this) continue;
            fms[i].resolve(2);
        }
        fms = this.getDeclaredUnmanagedFieldMappings();
        for (i = 0; i < fms.length; ++i) {
            fms[i].resolve(2);
        }
        if (this._cols != null) {
            ColumnIO io = this.getColumnIO();
            for (int i2 = 0; i2 < this._cols.length; ++i2) {
                if (io.isInsertable(i2, false)) {
                    this._cols[i2].setFlag(8, true);
                }
                if (!io.isUpdatable(i2, false)) continue;
                this._cols[i2].setFlag(16, true);
            }
        }
        this._info.getUniques(this, true);
    }

    void resolveNonRelationMappings() {
        int i;
        FieldMapping[] fms = this.getPrimaryKeyFieldMappings();
        for (i = 0; i < fms.length; ++i) {
            fms[i].resolve(2);
        }
        fms = this.getFieldMappings();
        for (i = 0; i < fms.length; ++i) {
            if (fms[i].getDefiningMetaData() != this || fms[i].isTypePC() || fms[i].getKey().isTypePC() || fms[i].getElement().isTypePC()) continue;
            fms[i].resolve(2);
        }
        this._discrim.resolve(2);
        this._version.resolve(2);
    }

    protected void initializeMapping() {
        super.initializeMapping();
        FieldMapping[] fields = this.getDefinedFieldMappings();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].resolve(8);
        }
        this._discrim.resolve(8);
        this._version.resolve(8);
        this._strategy.initialize();
    }

    protected void clearDefinedFieldCache() {
        super.clearDefinedFieldCache();
    }

    protected void clearSubclassCache() {
        super.clearSubclassCache();
        this._joinSubMaps = null;
        this._assignMaps = null;
    }

    public void copy(ClassMetaData cls) {
        super.copy(cls);
        if (this._subclassMode == Integer.MAX_VALUE) {
            this._subclassMode = ((ClassMapping)cls).getSubclassFetchMode();
        }
    }

    protected boolean validateDataStoreExtensionPrefix(String prefix) {
        return "jdbc-".equals(prefix);
    }

    public String getAlias() {
        return this.assertStrategy().getAlias();
    }

    public void map(boolean adapt) {
        this.assertStrategy().map(adapt);
    }

    public void initialize() {
        this.assertStrategy().initialize();
    }

    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().insert(sm, store, rm);
    }

    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().update(sm, store, rm);
    }

    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().delete(sm, store, rm);
    }

    public Boolean isCustomInsert(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomInsert(sm, store);
    }

    public Boolean isCustomUpdate(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomUpdate(sm, store);
    }

    public Boolean isCustomDelete(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomDelete(sm, store);
    }

    public void customInsert(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customInsert(sm, store);
    }

    public void customUpdate(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customUpdate(sm, store);
    }

    public void customDelete(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customDelete(sm, store);
    }

    public void setClassMapping(ClassMapping owner) {
        this.assertStrategy().setClassMapping(owner);
    }

    public boolean isPrimaryKeyObjectId(boolean hasAll) {
        return this.assertStrategy().isPrimaryKeyObjectId(hasAll);
    }

    public Joins joinSuperclass(Joins joins, boolean toThis) {
        return this.assertStrategy().joinSuperclass(joins, toThis);
    }

    public boolean supportsEagerSelect(Select sel, OpenJPAStateManager sm, JDBCStore store, ClassMapping base, JDBCFetchConfiguration fetch) {
        return this.assertStrategy().supportsEagerSelect(sel, sm, store, base, fetch);
    }

    public ResultObjectProvider customLoad(JDBCStore store, boolean subclasses, JDBCFetchConfiguration fetch, long startIdx, long endIdx) throws SQLException {
        return this.assertStrategy().customLoad(store, subclasses, fetch, startIdx, endIdx);
    }

    public boolean customLoad(OpenJPAStateManager sm, JDBCStore store, PCState state, JDBCFetchConfiguration fetch) throws SQLException, ClassNotFoundException {
        return this.assertStrategy().customLoad(sm, store, state, fetch);
    }

    public boolean customLoad(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result result) throws SQLException {
        return this.assertStrategy().customLoad(sm, store, fetch, result);
    }

    private ClassStrategy assertStrategy() {
        if (this._strategy == null) {
            throw new InternalException();
        }
        return this._strategy;
    }
}

