/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.LocalConstraint;
import org.apache.openjpa.jdbc.schema.Table;

public class Unique
extends LocalConstraint {
    private boolean _autoNaming = false;

    public Unique() {
        this._autoNaming = true;
    }

    public Unique(String name, Table table) {
        super(name, table);
        this._autoNaming = false;
    }

    public boolean isLogical() {
        return false;
    }

    public void setName(String name) {
        super.setName(name);
        this._autoNaming = false;
    }

    public String getName() {
        if (this.getTable() == null && this._autoNaming) {
            this.setName(this.createAutoName());
            this._autoNaming = true;
        }
        return super.getName();
    }

    public boolean equalsUnique(Unique unq) {
        return this.equalsLocalConstraint(unq);
    }

    public boolean isAutoNaming() {
        return this._autoNaming;
    }

    private String createAutoName() {
        Column[] columns = this.getColumns();
        int l = 32 / Math.max(columns.length, 1);
        StringBuffer autoName = new StringBuffer("UNQ_");
        for (Column column : columns) {
            autoName.append(this.chop(column.getName(), l));
        }
        return autoName.toString();
    }

    private String chop(String name, int head) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        return name.substring(0, Math.min(Math.max(1, head), name.length()));
    }
}

