/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.util.UnsupportedException;
import serp.util.Strings;

public abstract class AbstractResult
implements Result {
    private static final Joins JOINS = new NoOpJoins();
    private Map _eager = null;
    private ClassMapping _base = null;
    private int _index = 0;
    private boolean _gotEager = false;
    private boolean _wasNull = false;
    private boolean _locking = false;
    private boolean _ignoreNext = false;
    private boolean _last = false;
    private FieldMapping _mappedByFieldMapping = null;
    private Object _mappedByValue = null;

    public Object getEager(FieldMapping key) {
        Map map = this.getEagerMap(true);
        return map == null ? null : map.get(key);
    }

    public void putEager(FieldMapping key, Object res) {
        HashMap<FieldMapping, Object> map = this.getEagerMap(false);
        if (map == null) {
            map = new HashMap<FieldMapping, Object>();
            this.setEagerMap(map);
        }
        map.put(key, res);
    }

    protected Map getEagerMap(boolean client) {
        if (client) {
            this._gotEager = true;
        }
        return this._eager;
    }

    protected void setEagerMap(Map eager) {
        this._eager = eager;
    }

    public void close() {
        this.closeEagerMap(this._eager);
        this._mappedByFieldMapping = null;
        this._mappedByValue = null;
    }

    protected void closeEagerMap(Map eager) {
        if (eager != null) {
            for (Object res : eager.values()) {
                if (res == this || !(res instanceof Closeable)) continue;
                try {
                    ((Closeable)res).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean supportsRandomAccess() throws SQLException {
        return false;
    }

    public boolean absolute(int row) throws SQLException {
        this._gotEager = false;
        return this.absoluteInternal(row);
    }

    protected boolean absoluteInternal(int row) throws SQLException {
        throw new UnsupportedException();
    }

    public boolean next() throws SQLException {
        this._gotEager = false;
        if (this._ignoreNext) {
            this._ignoreNext = false;
            return this._last;
        }
        this._last = this.nextInternal();
        return this._last;
    }

    protected abstract boolean nextInternal() throws SQLException;

    public void pushBack() throws SQLException {
        this._ignoreNext = true;
    }

    public Joins newJoins() {
        return JOINS;
    }

    public boolean contains(Object obj) throws SQLException {
        return this.containsInternal(obj, null);
    }

    public boolean containsAll(Object[] objs) throws SQLException {
        return this.containsAllInternal(objs, null);
    }

    public boolean contains(Column col, Joins joins) throws SQLException {
        return this.containsInternal(col, joins);
    }

    public boolean containsAll(Column[] cols, Joins joins) throws SQLException {
        return this.containsAllInternal(cols, joins);
    }

    protected abstract boolean containsInternal(Object var1, Joins var2) throws SQLException;

    protected boolean containsAllInternal(Object[] objs, Joins joins) throws SQLException {
        for (int i = 0; i < objs.length; ++i) {
            if (this.containsInternal(objs[i], joins)) continue;
            return false;
        }
        return true;
    }

    public ClassMapping getBaseMapping() {
        return this._gotEager ? null : this._base;
    }

    public void setBaseMapping(ClassMapping base) {
        this._base = base;
    }

    public FieldMapping getMappedByFieldMapping() {
        return this._mappedByFieldMapping;
    }

    public void setMappedByFieldMapping(FieldMapping fieldMapping) {
        this._mappedByFieldMapping = fieldMapping;
    }

    public Object getMappedByValue() {
        return this._mappedByValue;
    }

    public void setMappedByValue(Object mappedByValue) {
        this._mappedByValue = mappedByValue;
    }

    public int indexOf() {
        return this._index;
    }

    public void setIndexOf(int idx) {
        this._index = idx;
    }

    public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
        return this.load(mapping, store, fetch, null);
    }

    public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) throws SQLException {
        return ((JDBCStoreManager)store).load(mapping, fetch, null, (Result)this);
    }

    public Array getArray(Object obj) throws SQLException {
        return this.getArrayInternal(this.translate(obj, null), null);
    }

    public Array getArray(Column col, Joins joins) throws SQLException {
        return this.getArrayInternal(this.translate(col, joins), joins);
    }

    protected Array getArrayInternal(Object obj, Joins joins) throws SQLException {
        return (Array)this.checkNull(this.getObjectInternal(obj, 1000, null, joins));
    }

    public InputStream getAsciiStream(Object obj) throws SQLException {
        return this.getAsciiStreamInternal(this.translate(obj, null), null);
    }

    public InputStream getAsciiStream(Column col, Joins joins) throws SQLException {
        return this.getAsciiStreamInternal(this.translate(col, joins), joins);
    }

    protected InputStream getAsciiStreamInternal(Object obj, Joins joins) throws SQLException {
        return (InputStream)this.checkNull(this.getObjectInternal(obj, 1001, null, joins));
    }

    public BigDecimal getBigDecimal(Object obj) throws SQLException {
        return this.getBigDecimalInternal(this.translate(obj, null), null);
    }

    public BigDecimal getBigDecimal(Column col, Joins joins) throws SQLException {
        return this.getBigDecimalInternal(this.translate(col, joins), joins);
    }

    protected BigDecimal getBigDecimalInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 24, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        return new BigDecimal(val.toString());
    }

    public BigInteger getBigInteger(Object obj) throws SQLException {
        return this.getBigIntegerInternal(this.translate(obj, null), null);
    }

    public BigInteger getBigInteger(Column col, Joins joins) throws SQLException {
        return this.getBigIntegerInternal(this.translate(col, joins), joins);
    }

    protected BigInteger getBigIntegerInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 25, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        return new BigInteger(val.toString());
    }

    public InputStream getBinaryStream(Object obj) throws SQLException {
        return this.getBinaryStreamInternal(this.translate(obj, null), null);
    }

    public InputStream getBinaryStream(Column col, Joins joins) throws SQLException {
        return this.getBinaryStreamInternal(this.translate(col, joins), joins);
    }

    public InputStream getLOBStream(JDBCStore store, Object obj) throws SQLException {
        return this.getLOBStreamInternal(store, this.translate(obj, null), null);
    }

    protected InputStream getBinaryStreamInternal(Object obj, Joins joins) throws SQLException {
        return (InputStream)this.checkNull(this.getObjectInternal(obj, 1002, null, joins));
    }

    protected InputStream getLOBStreamInternal(JDBCStore store, Object obj, Joins joins) throws SQLException {
        return (InputStream)this.checkNull(this.getStreamInternal(store, obj, 1002, null, joins));
    }

    public Blob getBlob(Object obj) throws SQLException {
        return this.getBlobInternal(this.translate(obj, null), null);
    }

    public Blob getBlob(Column col, Joins joins) throws SQLException {
        return this.getBlobInternal(this.translate(col, joins), joins);
    }

    protected Blob getBlobInternal(Object obj, Joins joins) throws SQLException {
        return (Blob)this.checkNull(this.getObjectInternal(obj, 1003, null, joins));
    }

    public boolean getBoolean(Object obj) throws SQLException {
        return this.getBooleanInternal(this.translate(obj, null), null);
    }

    public boolean getBoolean(Column col, Joins joins) throws SQLException {
        return this.getBooleanInternal(this.translate(col, joins), joins);
    }

    protected boolean getBooleanInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 0, null, joins));
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val.toString());
    }

    public byte getByte(Object obj) throws SQLException {
        return this.getByteInternal(this.translate(obj, null), null);
    }

    public byte getByte(Column col, Joins joins) throws SQLException {
        return this.getByteInternal(this.translate(col, joins), joins);
    }

    protected byte getByteInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 1, null, joins));
        return val == null ? (byte)0 : val.byteValue();
    }

    public byte[] getBytes(Object obj) throws SQLException {
        return this.getBytesInternal(this.translate(obj, null), null);
    }

    public byte[] getBytes(Column col, Joins joins) throws SQLException {
        return this.getBytesInternal(this.translate(col, joins), joins);
    }

    protected byte[] getBytesInternal(Object obj, Joins joins) throws SQLException {
        return (byte[])this.checkNull(this.getObjectInternal(obj, 1004, null, joins));
    }

    public Calendar getCalendar(Object obj) throws SQLException {
        return this.getCalendarInternal(this.translate(obj, null), null);
    }

    public Calendar getCalendar(Column col, Joins joins) throws SQLException {
        return this.getCalendarInternal(this.translate(col, joins), joins);
    }

    protected Calendar getCalendarInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 28, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Calendar) {
            return (Calendar)val;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new java.util.Date(val.toString()));
        return cal;
    }

    public char getChar(Object obj) throws SQLException {
        return this.getCharInternal(this.translate(obj, null), null);
    }

    public char getChar(Column col, Joins joins) throws SQLException {
        return this.getCharInternal(this.translate(col, joins), joins);
    }

    protected char getCharInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 2, null, joins));
        if (val == null) {
            return '\u0000';
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        String str = val.toString();
        return str.length() == 0 ? (char)'\u0000' : str.charAt(0);
    }

    public Reader getCharacterStream(Object obj) throws SQLException {
        return this.getCharacterStreamInternal(this.translate(obj, null), null);
    }

    public Reader getCharacterStream(Column col, Joins joins) throws SQLException {
        return this.getCharacterStreamInternal(this.translate(col, joins), joins);
    }

    protected Reader getCharacterStreamInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 1005, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Reader) {
            return (Reader)val;
        }
        return new StringReader(val.toString());
    }

    public Clob getClob(Object obj) throws SQLException {
        return this.getClobInternal(this.translate(obj, null), null);
    }

    public Clob getClob(Column col, Joins joins) throws SQLException {
        return this.getClobInternal(this.translate(col, joins), joins);
    }

    protected Clob getClobInternal(Object obj, Joins joins) throws SQLException {
        return (Clob)this.checkNull(this.getObjectInternal(obj, 1006, null, joins));
    }

    public java.util.Date getDate(Object obj) throws SQLException {
        return this.getDateInternal(this.translate(obj, null), null);
    }

    public java.util.Date getDate(Column col, Joins joins) throws SQLException {
        return this.getDateInternal(this.translate(col, joins), joins);
    }

    protected java.util.Date getDateInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 14, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof java.util.Date) {
            return (java.util.Date)val;
        }
        return new java.util.Date(val.toString());
    }

    public Date getDate(Object obj, Calendar cal) throws SQLException {
        return this.getDateInternal(this.translate(obj, null), cal, null);
    }

    public Date getDate(Column col, Calendar cal, Joins joins) throws SQLException {
        return this.getDateInternal(this.translate(col, joins), cal, joins);
    }

    protected Date getDateInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return (Date)this.checkNull(this.getObjectInternal(obj, 1007, cal, joins));
    }

    public double getDouble(Object obj) throws SQLException {
        return this.getDoubleInternal(this.translate(obj, null), null);
    }

    public double getDouble(Column col, Joins joins) throws SQLException {
        return this.getDoubleInternal(this.translate(col, joins), joins);
    }

    protected double getDoubleInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 3, null, joins));
        return val == null ? 0.0 : val.doubleValue();
    }

    public float getFloat(Object obj) throws SQLException {
        return this.getFloatInternal(this.translate(obj, null), null);
    }

    public float getFloat(Column col, Joins joins) throws SQLException {
        return this.getFloatInternal(this.translate(col, joins), joins);
    }

    protected float getFloatInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 4, null, joins));
        return val == null ? 0.0f : val.floatValue();
    }

    public int getInt(Object obj) throws SQLException {
        return this.getIntInternal(this.translate(obj, null), null);
    }

    public int getInt(Column col, Joins joins) throws SQLException {
        return this.getIntInternal(this.translate(col, joins), joins);
    }

    protected int getIntInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 5, null, joins));
        return val == null ? 0 : val.intValue();
    }

    public Locale getLocale(Object obj) throws SQLException {
        return this.getLocaleInternal(this.translate(obj, null), null);
    }

    public Locale getLocale(Column col, Joins joins) throws SQLException {
        return this.getLocaleInternal(this.translate(col, joins), joins);
    }

    protected Locale getLocaleInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 26, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Locale) {
            return (Locale)val;
        }
        String[] vals = Strings.split((String)val.toString(), (String)"_", (int)0);
        if (vals.length < 2) {
            throw new SQLException(val.toString());
        }
        if (vals.length == 2) {
            return new Locale(vals[0], vals[1]);
        }
        return new Locale(vals[0], vals[1], vals[2]);
    }

    public long getLong(Object obj) throws SQLException {
        return this.getLongInternal(this.translate(obj, null), null);
    }

    public long getLong(Column col, Joins joins) throws SQLException {
        return this.getLongInternal(this.translate(col, joins), joins);
    }

    protected long getLongInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 5, null, joins));
        return val == null ? 0L : (long)val.intValue();
    }

    public Number getNumber(Object obj) throws SQLException {
        return this.getNumberInternal(this.translate(obj, null), null);
    }

    public Number getNumber(Column col, Joins joins) throws SQLException {
        return this.getNumberInternal(this.translate(col, joins), joins);
    }

    protected Number getNumberInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 10, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        return new BigDecimal(val.toString());
    }

    public Object getObject(Object obj, int metaType, Object arg) throws SQLException {
        return this.getObjectInternal(this.translate(obj, null), metaType, arg, null);
    }

    public Object getObject(Column col, Object arg, Joins joins) throws SQLException {
        return this.getObjectInternal(this.translate(col, joins), col.getJavaType(), arg, joins);
    }

    protected abstract Object getObjectInternal(Object var1, int var2, Object var3, Joins var4) throws SQLException;

    protected abstract Object getStreamInternal(JDBCStore var1, Object var2, int var3, Object var4, Joins var5) throws SQLException;

    public Object getSQLObject(Object obj, Map map) throws SQLException {
        return this.getSQLObjectInternal(this.translate(obj, null), map, null);
    }

    public Object getSQLObject(Column col, Map map, Joins joins) throws SQLException {
        return this.getSQLObjectInternal(this.translate(col, joins), map, joins);
    }

    protected Object getSQLObjectInternal(Object obj, Map map, Joins joins) throws SQLException {
        return this.checkNull(this.getObjectInternal(obj, 1008, map, joins));
    }

    public Ref getRef(Object obj, Map map) throws SQLException {
        return this.getRefInternal(this.translate(obj, null), map, null);
    }

    public Ref getRef(Column col, Map map, Joins joins) throws SQLException {
        return this.getRefInternal(this.translate(col, joins), map, joins);
    }

    protected Ref getRefInternal(Object obj, Map map, Joins joins) throws SQLException {
        return (Ref)this.checkNull(this.getObjectInternal(obj, 1009, map, joins));
    }

    public short getShort(Object obj) throws SQLException {
        return this.getShortInternal(this.translate(obj, null), null);
    }

    public short getShort(Column col, Joins joins) throws SQLException {
        return this.getShortInternal(this.translate(col, joins), joins);
    }

    protected short getShortInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 7, null, joins));
        return val == null ? (short)0 : val.shortValue();
    }

    public String getString(Object obj) throws SQLException {
        return this.getStringInternal(this.translate(obj, null), null);
    }

    public String getString(Column col, Joins joins) throws SQLException {
        return this.getStringInternal(this.translate(col, joins), joins);
    }

    protected String getStringInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 9, null, joins));
        return val == null ? null : val.toString();
    }

    public Time getTime(Object obj, Calendar cal) throws SQLException {
        return this.getTimeInternal(this.translate(obj, null), cal, null);
    }

    public Time getTime(Column col, Calendar cal, Joins joins) throws SQLException {
        return this.getTimeInternal(this.translate(col, joins), cal, joins);
    }

    protected Time getTimeInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return (Time)this.checkNull(this.getObjectInternal(obj, 1010, cal, joins));
    }

    public Timestamp getTimestamp(Object obj, Calendar cal) throws SQLException {
        return this.getTimestampInternal(this.translate(obj, null), cal, null);
    }

    public Timestamp getTimestamp(Column col, Calendar cal, Joins joins) throws SQLException {
        return this.getTimestampInternal(this.translate(col, joins), cal, joins);
    }

    protected Timestamp getTimestampInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return (Timestamp)this.checkNull(this.getObjectInternal(obj, 1011, cal, joins));
    }

    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    protected Object checkNull(Object val) {
        this._wasNull = val == null;
        return val;
    }

    public void setLocking(boolean locking) {
        this._locking = locking;
    }

    public boolean isLocking() {
        return this._locking;
    }

    public void startDataRequest(Object mapping) {
    }

    public void endDataRequest() {
    }

    protected Object translate(Object obj, Joins joins) throws SQLException {
        return obj;
    }

    private static class NoOpJoins
    implements Joins {
        private NoOpJoins() {
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean isOuter() {
            return false;
        }

        public Joins crossJoin(Table localTable, Table foreignTable) {
            return this;
        }

        public Joins join(ForeignKey fk, boolean inverse, boolean toMany) {
            return this;
        }

        public Joins outerJoin(ForeignKey fk, boolean inverse, boolean toMany) {
            return this;
        }

        public Joins joinRelation(String name, ForeignKey fk, ClassMapping target, int subs, boolean inverse, boolean toMany) {
            return this;
        }

        public Joins outerJoinRelation(String name, ForeignKey fk, ClassMapping target, int subs, boolean inverse, boolean toMany) {
            return this;
        }

        public Joins setVariable(String var) {
            return this;
        }

        public Joins setSubselect(String alias) {
            return this;
        }

        public void appendTo(SQLBuffer buf) {
        }
    }
}

