/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.BitSet;
import java.util.Collection;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ArrayStateImage;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;

public class StateComparisonVersionStrategy
extends AbstractVersionStrategy {
    private static final long serialVersionUID = 1L;
    public static final String ALIAS = "state-comparison";
    private static final Localizer _loc = Localizer.forPackage(StateComparisonVersionStrategy.class);

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    public void map(boolean adapt) {
        ClassMapping cls = this.vers.getClassMapping();
        if (cls.getJoinablePCSuperclassMapping() != null || cls.getEmbeddingMetaData() != null) {
            throw new MetaDataException(_loc.get("not-base-vers", (Object)cls));
        }
        this.vers.getMappingInfo().assertNoSchemaComponents(this.vers, true);
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        FieldMapping[] fields = (FieldMapping[])sm.getMetaData().getFields();
        Object[] state = ArrayStateImage.newImage((int)fields.length);
        BitSet loaded = ArrayStateImage.getLoaded((Object[])state);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].isPrimaryKey() || !fields[i].isVersionable()) continue;
            loaded.set(i);
            state[i] = sm.fetch(fields[i].getIndex());
        }
        sm.setNextVersion((Object)state);
    }

    @Override
    public void customInsert(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.insert(sm, store, null);
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Object[] state = (Object[])sm.getVersion();
        if (state == null) {
            return;
        }
        BitSet loaded = ArrayStateImage.getLoaded((Object[])state);
        Object[] nextState = ArrayStateImage.clone((Object[])state);
        FieldMapping[] fields = (FieldMapping[])sm.getMetaData().getFields();
        if (sm.isVersionCheckRequired()) {
            int max = loaded.length();
            for (int i = 0; i < max; ++i) {
                Row row;
                if (!loaded.get(i)) continue;
                if (sm.getDirty().get(i) && !sm.getFlushed().get(i)) {
                    nextState[i] = sm.fetch(fields[i].getIndex());
                }
                if ((row = rm.getRow(fields[i].getTable(), 0, sm, false)) == null) continue;
                fields[i].where(sm, store, rm, state[i]);
                row.setFailedObject(sm.getManagedInstance());
            }
        }
        sm.setNextVersion((Object)nextState);
    }

    public CustomUpdate customUpdate(OpenJPAStateManager sm, JDBCStore store, Table table, boolean record) throws SQLException {
        CustomUpdate custom = new CustomUpdate(table);
        Object[] state = (Object[])sm.getVersion();
        if (state == null) {
            return custom;
        }
        BitSet loaded = ArrayStateImage.getLoaded((Object[])state);
        Object[] nextState = null;
        if (record) {
            nextState = ArrayStateImage.clone((Object[])state);
        }
        FieldMapping[] fields = (FieldMapping[])sm.getMetaData().getFields();
        int max = loaded.length();
        for (int i = 0; i < max; ++i) {
            if (!loaded.get(i)) continue;
            if (record && sm.getDirty().get(i) && !sm.getFlushed().get(i)) {
                nextState[i] = sm.fetch(fields[i].getIndex());
            }
            if (fields[i].getTable() != table) continue;
            fields[i].where(sm, store, custom, state[i]);
        }
        if (record) {
            sm.setNextVersion((Object)nextState);
        }
        return custom;
    }

    @Override
    public void afterLoad(OpenJPAStateManager sm, JDBCStore store) {
        FieldMapping[] fields = (FieldMapping[])sm.getMetaData().getFields();
        Object[] state = (Object[])sm.getVersion();
        if (state == null) {
            state = ArrayStateImage.newImage((int)fields.length);
        }
        BitSet loaded = ArrayStateImage.getLoaded((Object[])state);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].isPrimaryKey() || !fields[i].isVersionable() || !sm.getLoaded().get(fields[i].getIndex()) || loaded.get(i) || sm.getDirty().get(fields[i].getIndex())) continue;
            loaded.set(i);
            state[i] = sm.fetch(fields[i].getIndex());
        }
        sm.setVersion((Object)state);
    }

    @Override
    public boolean checkVersion(OpenJPAStateManager sm, JDBCStore store, boolean updateVersion) throws SQLException {
        if (updateVersion) {
            sm.setVersion(null);
        }
        return !updateVersion;
    }

    @Override
    public int compareVersion(Object v1, Object v2) {
        return ArrayStateImage.sameVersion((Object[])((Object[])v1), (Object[])((Object[])v2)) ? 3 : 4;
    }

    public static class CustomUpdate
    extends RowImpl
    implements RowManager {
        private CustomUpdate(Table table) {
            this(table.getColumns());
        }

        private CustomUpdate(Column[] cols) {
            super(cols, 0);
        }

        @Override
        public String getSQL(DBDictionary dict) {
            Column[] cols = this.getTable().getColumns();
            StringBuilder buf = new StringBuilder();
            boolean hasWhere = false;
            for (int i = 0; i < cols.length; ++i) {
                Object val = this.getWhere(cols[i]);
                if (val == null) continue;
                if (hasWhere) {
                    buf.append(" AND ");
                }
                if (val == NULL) {
                    buf.append(dict.getColumnDBName(cols[i]) + " IS NULL");
                } else {
                    buf.append(dict.getColumnDBName(cols[i]) + " = ?");
                }
                hasWhere = true;
            }
            return buf.toString();
        }

        @Override
        protected RowImpl newInstance(Column[] cols, int action) {
            return new CustomUpdate(cols);
        }

        public boolean hasAutoAssignConstraints() {
            return false;
        }

        public Collection getInserts() {
            throw new InternalException();
        }

        public Collection getUpdates() {
            throw new InternalException();
        }

        public Collection getDeletes() {
            throw new InternalException();
        }

        public Collection getSecondaryUpdates() {
            throw new InternalException();
        }

        public Collection getSecondaryDeletes() {
            throw new InternalException();
        }

        public Collection getAllRowUpdates() {
            throw new InternalException();
        }

        public Collection getAllRowDeletes() {
            throw new InternalException();
        }

        @Override
        public Row getRow(Table table, int action, OpenJPAStateManager sm, boolean create) {
            if (table != this.getTable()) {
                return null;
            }
            return this;
        }

        @Override
        public Row getSecondaryRow(Table table, int action) {
            throw new InternalException();
        }

        @Override
        public void flushSecondaryRow(Row row) {
        }

        @Override
        public Row getAllRows(Table table, int action) {
            throw new InternalException();
        }

        @Override
        public void flushAllRows(Row row) {
        }

        @Override
        public void setObject(Column col, Object val) throws SQLException {
            throw new InternalException();
        }
    }
}

