/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.UnsupportedException;

public abstract class AbstractResult
implements Result {
    private static final Joins JOINS = new NoOpJoins();
    private Map _eager = null;
    private ClassMapping _base = null;
    private int _index = 0;
    private boolean _gotEager = false;
    private boolean _wasNull = false;
    private boolean _locking = false;
    private boolean _ignoreNext = false;
    private boolean _last = false;
    private FieldMapping _mappedByFieldMapping = null;
    private Object _mappedByValue = null;

    @Override
    public Object getEager(FieldMapping key) {
        Map map = this.getEagerMap(true);
        return map == null ? null : map.get(key);
    }

    @Override
    public void putEager(FieldMapping key, Object res) {
        HashMap<FieldMapping, Object> map = this.getEagerMap(false);
        if (map == null) {
            map = new HashMap<FieldMapping, Object>();
            this.setEagerMap(map);
        }
        map.put(key, res);
    }

    protected Map getEagerMap(boolean client) {
        if (client) {
            this._gotEager = true;
        }
        return this._eager;
    }

    protected void setEagerMap(Map eager) {
        this._eager = eager;
    }

    @Override
    public void close() {
        this.closeEagerMap(this._eager);
        this._mappedByFieldMapping = null;
        this._mappedByValue = null;
    }

    protected void closeEagerMap(Map eager) {
        if (eager != null) {
            for (Object res : eager.values()) {
                if (res == this || !(res instanceof Closeable)) continue;
                try {
                    ((Closeable)res).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean supportsRandomAccess() throws SQLException {
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this._gotEager = false;
        return this.absoluteInternal(row);
    }

    protected boolean absoluteInternal(int row) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public boolean next() throws SQLException {
        this._gotEager = false;
        if (this._ignoreNext) {
            this._ignoreNext = false;
            return this._last;
        }
        this._last = this.nextInternal();
        return this._last;
    }

    protected abstract boolean nextInternal() throws SQLException;

    @Override
    public void pushBack() throws SQLException {
        this._ignoreNext = true;
    }

    @Override
    public Joins newJoins() {
        return JOINS;
    }

    @Override
    public boolean contains(Object obj) throws SQLException {
        return this.containsInternal(obj, null);
    }

    @Override
    public boolean containsAll(Object[] objs) throws SQLException {
        return this.containsAllInternal(objs, null);
    }

    @Override
    public boolean contains(Column col, Joins joins) throws SQLException {
        return this.containsInternal(col, joins);
    }

    @Override
    public boolean containsAll(Column[] cols, Joins joins) throws SQLException {
        return this.containsAllInternal(cols, joins);
    }

    protected abstract boolean containsInternal(Object var1, Joins var2) throws SQLException;

    protected boolean containsAllInternal(Object[] objs, Joins joins) throws SQLException {
        for (int i = 0; i < objs.length; ++i) {
            if (this.containsInternal(objs[i], joins)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClassMapping getBaseMapping() {
        return this._gotEager ? null : this._base;
    }

    @Override
    public void setBaseMapping(ClassMapping base) {
        this._base = base;
    }

    @Override
    public FieldMapping getMappedByFieldMapping() {
        return this._mappedByFieldMapping;
    }

    @Override
    public void setMappedByFieldMapping(FieldMapping fieldMapping) {
        this._mappedByFieldMapping = fieldMapping;
    }

    @Override
    public Object getMappedByValue() {
        return this._mappedByValue;
    }

    @Override
    public void setMappedByValue(Object mappedByValue) {
        this._mappedByValue = mappedByValue;
    }

    @Override
    public int indexOf() {
        return this._index;
    }

    public void setIndexOf(int idx) {
        this._index = idx;
    }

    @Override
    public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
        return this.load(mapping, store, fetch, null);
    }

    @Override
    public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) throws SQLException {
        return ((JDBCStoreManager)store).load(mapping, fetch, null, (Result)this);
    }

    @Override
    public Array getArray(Object obj) throws SQLException {
        return this.getArrayInternal(this.translate(obj, null), null);
    }

    @Override
    public Array getArray(Column col, Joins joins) throws SQLException {
        return this.getArrayInternal(this.translate(col, joins), joins);
    }

    protected Array getArrayInternal(Object obj, Joins joins) throws SQLException {
        return (Array)this.checkNull(this.getObjectInternal(obj, 1000, null, joins));
    }

    @Override
    public InputStream getAsciiStream(Object obj) throws SQLException {
        return this.getAsciiStreamInternal(this.translate(obj, null), null);
    }

    @Override
    public InputStream getAsciiStream(Column col, Joins joins) throws SQLException {
        return this.getAsciiStreamInternal(this.translate(col, joins), joins);
    }

    protected InputStream getAsciiStreamInternal(Object obj, Joins joins) throws SQLException {
        return (InputStream)this.checkNull(this.getObjectInternal(obj, 1001, null, joins));
    }

    @Override
    public BigDecimal getBigDecimal(Object obj) throws SQLException {
        return this.getBigDecimalInternal(this.translate(obj, null), null);
    }

    @Override
    public BigDecimal getBigDecimal(Column col, Joins joins) throws SQLException {
        return this.getBigDecimalInternal(this.translate(col, joins), joins);
    }

    protected BigDecimal getBigDecimalInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 24, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        return new BigDecimal(val.toString());
    }

    @Override
    public BigInteger getBigInteger(Object obj) throws SQLException {
        return this.getBigIntegerInternal(this.translate(obj, null), null);
    }

    @Override
    public BigInteger getBigInteger(Column col, Joins joins) throws SQLException {
        return this.getBigIntegerInternal(this.translate(col, joins), joins);
    }

    protected BigInteger getBigIntegerInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 25, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        return new BigInteger(val.toString());
    }

    @Override
    public InputStream getBinaryStream(Object obj) throws SQLException {
        return this.getBinaryStreamInternal(this.translate(obj, null), null);
    }

    @Override
    public InputStream getBinaryStream(Column col, Joins joins) throws SQLException {
        return this.getBinaryStreamInternal(this.translate(col, joins), joins);
    }

    @Override
    public InputStream getLOBStream(JDBCStore store, Object obj) throws SQLException {
        return this.getLOBStreamInternal(store, this.translate(obj, null), null);
    }

    protected InputStream getBinaryStreamInternal(Object obj, Joins joins) throws SQLException {
        return (InputStream)this.checkNull(this.getObjectInternal(obj, 1002, null, joins));
    }

    protected InputStream getLOBStreamInternal(JDBCStore store, Object obj, Joins joins) throws SQLException {
        return (InputStream)this.checkNull(this.getStreamInternal(store, obj, 1002, null, joins));
    }

    @Override
    public Blob getBlob(Object obj) throws SQLException {
        return this.getBlobInternal(this.translate(obj, null), null);
    }

    @Override
    public Blob getBlob(Column col, Joins joins) throws SQLException {
        return this.getBlobInternal(this.translate(col, joins), joins);
    }

    protected Blob getBlobInternal(Object obj, Joins joins) throws SQLException {
        return (Blob)this.checkNull(this.getObjectInternal(obj, 1003, null, joins));
    }

    @Override
    public boolean getBoolean(Object obj) throws SQLException {
        return this.getBooleanInternal(this.translate(obj, null), null);
    }

    @Override
    public boolean getBoolean(Column col, Joins joins) throws SQLException {
        return this.getBooleanInternal(this.translate(col, joins), joins);
    }

    protected boolean getBooleanInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 0, null, joins));
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val.toString());
    }

    @Override
    public byte getByte(Object obj) throws SQLException {
        return this.getByteInternal(this.translate(obj, null), null);
    }

    @Override
    public byte getByte(Column col, Joins joins) throws SQLException {
        return this.getByteInternal(this.translate(col, joins), joins);
    }

    protected byte getByteInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 1, null, joins));
        return val == null ? (byte)0 : val.byteValue();
    }

    @Override
    public byte[] getBytes(Object obj) throws SQLException {
        return this.getBytesInternal(this.translate(obj, null), null);
    }

    @Override
    public byte[] getBytes(Column col, Joins joins) throws SQLException {
        return this.getBytesInternal(this.translate(col, joins), joins);
    }

    protected byte[] getBytesInternal(Object obj, Joins joins) throws SQLException {
        return (byte[])this.checkNull(this.getObjectInternal(obj, 1004, null, joins));
    }

    @Override
    public Calendar getCalendar(Object obj) throws SQLException {
        return this.getCalendarInternal(this.translate(obj, null), null);
    }

    @Override
    public Calendar getCalendar(Column col, Joins joins) throws SQLException {
        return this.getCalendarInternal(this.translate(col, joins), joins);
    }

    protected Calendar getCalendarInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 28, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Calendar) {
            return (Calendar)val;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new java.util.Date(val.toString()));
        return cal;
    }

    @Override
    public LocalDate getLocalDate(Object obj) throws SQLException {
        return this.getLocalDateInternal(this.translate(obj, null), null);
    }

    protected LocalDate getLocalDateInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 33, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDate) {
            return (LocalDate)val;
        }
        return LocalDate.parse(val.toString());
    }

    @Override
    public LocalTime getLocalTime(Object obj) throws SQLException {
        return this.getLocalTimeInternal(this.translate(obj, null), null);
    }

    protected LocalTime getLocalTimeInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 34, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof LocalTime) {
            return (LocalTime)val;
        }
        return LocalTime.parse(val.toString());
    }

    @Override
    public LocalDateTime getLocalDateTime(Object obj) throws SQLException {
        return this.getLocalDateTimeInternal(this.translate(obj, null), null);
    }

    protected LocalDateTime getLocalDateTimeInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 35, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDateTime) {
            return (LocalDateTime)val;
        }
        return LocalDateTime.parse(val.toString());
    }

    @Override
    public OffsetTime getOffsetTime(Object obj) throws SQLException {
        return this.getOffsetTimeInternal(this.translate(obj, null), null);
    }

    protected OffsetTime getOffsetTimeInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 36, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof OffsetTime) {
            return (OffsetTime)val;
        }
        return OffsetTime.parse(val.toString());
    }

    @Override
    public OffsetDateTime getOffsetDateTime(Object obj) throws SQLException {
        return this.getOffsetDateTimeInternal(this.translate(obj, null), null);
    }

    protected OffsetDateTime getOffsetDateTimeInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 37, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof OffsetDateTime) {
            return (OffsetDateTime)val;
        }
        return OffsetDateTime.parse(val.toString());
    }

    @Override
    public char getChar(Object obj) throws SQLException {
        return this.getCharInternal(this.translate(obj, null), null);
    }

    @Override
    public char getChar(Column col, Joins joins) throws SQLException {
        return this.getCharInternal(this.translate(col, joins), joins);
    }

    protected char getCharInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 2, null, joins));
        if (val == null) {
            return '\u0000';
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        String str = val.toString();
        return str.length() == 0 ? (char)'\u0000' : str.charAt(0);
    }

    @Override
    public Reader getCharacterStream(Object obj) throws SQLException {
        return this.getCharacterStreamInternal(this.translate(obj, null), null);
    }

    @Override
    public Reader getCharacterStream(Column col, Joins joins) throws SQLException {
        return this.getCharacterStreamInternal(this.translate(col, joins), joins);
    }

    protected Reader getCharacterStreamInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 1005, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Reader) {
            return (Reader)val;
        }
        return new StringReader(val.toString());
    }

    @Override
    public Clob getClob(Object obj) throws SQLException {
        return this.getClobInternal(this.translate(obj, null), null);
    }

    @Override
    public Clob getClob(Column col, Joins joins) throws SQLException {
        return this.getClobInternal(this.translate(col, joins), joins);
    }

    protected Clob getClobInternal(Object obj, Joins joins) throws SQLException {
        return (Clob)this.checkNull(this.getObjectInternal(obj, 1006, null, joins));
    }

    @Override
    public java.util.Date getDate(Object obj) throws SQLException {
        return this.getDateInternal(this.translate(obj, null), null);
    }

    @Override
    public java.util.Date getDate(Column col, Joins joins) throws SQLException {
        return this.getDateInternal(this.translate(col, joins), joins);
    }

    protected java.util.Date getDateInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 14, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof java.util.Date) {
            return (java.util.Date)val;
        }
        return new java.util.Date(val.toString());
    }

    @Override
    public Date getDate(Object obj, Calendar cal) throws SQLException {
        return this.getDateInternal(this.translate(obj, null), cal, null);
    }

    @Override
    public Date getDate(Column col, Calendar cal, Joins joins) throws SQLException {
        return this.getDateInternal(this.translate(col, joins), cal, joins);
    }

    protected Date getDateInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return (Date)this.checkNull(this.getObjectInternal(obj, 1007, cal, joins));
    }

    @Override
    public double getDouble(Object obj) throws SQLException {
        return this.getDoubleInternal(this.translate(obj, null), null);
    }

    @Override
    public double getDouble(Column col, Joins joins) throws SQLException {
        return this.getDoubleInternal(this.translate(col, joins), joins);
    }

    protected double getDoubleInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 3, null, joins));
        return val == null ? 0.0 : val.doubleValue();
    }

    @Override
    public float getFloat(Object obj) throws SQLException {
        return this.getFloatInternal(this.translate(obj, null), null);
    }

    @Override
    public float getFloat(Column col, Joins joins) throws SQLException {
        return this.getFloatInternal(this.translate(col, joins), joins);
    }

    protected float getFloatInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 4, null, joins));
        return val == null ? 0.0f : val.floatValue();
    }

    @Override
    public int getInt(Object obj) throws SQLException {
        return this.getIntInternal(this.translate(obj, null), null);
    }

    @Override
    public int getInt(Column col, Joins joins) throws SQLException {
        return this.getIntInternal(this.translate(col, joins), joins);
    }

    protected int getIntInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 5, null, joins));
        return val == null ? 0 : val.intValue();
    }

    @Override
    public Locale getLocale(Object obj) throws SQLException {
        return this.getLocaleInternal(this.translate(obj, null), null);
    }

    @Override
    public Locale getLocale(Column col, Joins joins) throws SQLException {
        return this.getLocaleInternal(this.translate(col, joins), joins);
    }

    protected Locale getLocaleInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 26, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Locale) {
            return (Locale)val;
        }
        String[] vals = StringUtil.split((String)val.toString(), (String)"_", (int)0);
        if (vals.length < 2) {
            throw new SQLException(val.toString());
        }
        if (vals.length == 2) {
            return new Locale(vals[0], vals[1]);
        }
        return new Locale(vals[0], vals[1], vals[2]);
    }

    @Override
    public long getLong(Object obj) throws SQLException {
        return this.getLongInternal(this.translate(obj, null), null);
    }

    @Override
    public long getLong(Column col, Joins joins) throws SQLException {
        return this.getLongInternal(this.translate(col, joins), joins);
    }

    protected long getLongInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 6, null, joins));
        return val == null ? 0L : val.longValue();
    }

    @Override
    public Number getNumber(Object obj) throws SQLException {
        return this.getNumberInternal(this.translate(obj, null), null);
    }

    @Override
    public Number getNumber(Column col, Joins joins) throws SQLException {
        return this.getNumberInternal(this.translate(col, joins), joins);
    }

    protected Number getNumberInternal(Object obj, Joins joins) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 10, null, joins));
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        return new BigDecimal(val.toString());
    }

    @Override
    public Object getObject(Object obj, int metaType, Object arg) throws SQLException {
        return this.getObjectInternal(obj, metaType, arg, null);
    }

    @Override
    public Object getObject(Column col, Object arg, Joins joins) throws SQLException {
        return this.getObjectInternal(col, col.getJavaType(), arg, joins);
    }

    protected abstract Object getObjectInternal(Object var1, int var2, Object var3, Joins var4) throws SQLException;

    protected abstract Object getStreamInternal(JDBCStore var1, Object var2, int var3, Object var4, Joins var5) throws SQLException;

    @Override
    public Object getSQLObject(Object obj, Map map) throws SQLException {
        return this.getSQLObjectInternal(this.translate(obj, null), map, null);
    }

    @Override
    public Object getSQLObject(Column col, Map map, Joins joins) throws SQLException {
        return this.getSQLObjectInternal(this.translate(col, joins), map, joins);
    }

    protected Object getSQLObjectInternal(Object obj, Map map, Joins joins) throws SQLException {
        return this.checkNull(this.getObjectInternal(obj, 1008, map, joins));
    }

    @Override
    public Ref getRef(Object obj, Map map) throws SQLException {
        return this.getRefInternal(this.translate(obj, null), map, null);
    }

    @Override
    public Ref getRef(Column col, Map map, Joins joins) throws SQLException {
        return this.getRefInternal(this.translate(col, joins), map, joins);
    }

    protected Ref getRefInternal(Object obj, Map map, Joins joins) throws SQLException {
        return (Ref)this.checkNull(this.getObjectInternal(obj, 1009, map, joins));
    }

    @Override
    public short getShort(Object obj) throws SQLException {
        return this.getShortInternal(this.translate(obj, null), null);
    }

    @Override
    public short getShort(Column col, Joins joins) throws SQLException {
        return this.getShortInternal(this.translate(col, joins), joins);
    }

    protected short getShortInternal(Object obj, Joins joins) throws SQLException {
        Number val = (Number)this.checkNull(this.getObjectInternal(obj, 7, null, joins));
        return val == null ? (short)0 : val.shortValue();
    }

    @Override
    public String getString(Object obj) throws SQLException {
        return this.getStringInternal(this.translate(obj, null), null, obj instanceof Column && ((Column)obj).getType() == 2005);
    }

    @Override
    public String getString(Column col, Joins joins) throws SQLException {
        return this.getStringInternal(this.translate(col, joins), joins, col.getType() == 2005);
    }

    protected String getStringInternal(Object obj, Joins joins, boolean isClobString) throws SQLException {
        Object val = this.checkNull(this.getObjectInternal(obj, 9, null, joins));
        return val == null ? null : val.toString();
    }

    @Override
    public Time getTime(Object obj, Calendar cal) throws SQLException {
        return this.getTimeInternal(this.translate(obj, null), cal, null);
    }

    @Override
    public Time getTime(Column col, Calendar cal, Joins joins) throws SQLException {
        return this.getTimeInternal(this.translate(col, joins), cal, joins);
    }

    protected Time getTimeInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return (Time)this.checkNull(this.getObjectInternal(obj, 1010, cal, joins));
    }

    @Override
    public Timestamp getTimestamp(Object obj, Calendar cal) throws SQLException {
        return this.getTimestampInternal(this.translate(obj, null), cal, null);
    }

    @Override
    public Timestamp getTimestamp(Column col, Calendar cal, Joins joins) throws SQLException {
        return this.getTimestampInternal(this.translate(col, joins), cal, joins);
    }

    protected Timestamp getTimestampInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
        return (Timestamp)this.checkNull(this.getObjectInternal(obj, 1011, cal, joins));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    protected Object checkNull(Object val) {
        this._wasNull = val == null;
        return val;
    }

    @Override
    public void setLocking(boolean locking) {
        this._locking = locking;
    }

    @Override
    public boolean isLocking() {
        return this._locking;
    }

    @Override
    public void startDataRequest(Object mapping) {
    }

    @Override
    public void endDataRequest() {
    }

    protected Object translate(Object obj, Joins joins) throws SQLException {
        return obj;
    }

    private static class NoOpJoins
    implements Joins {
        private NoOpJoins() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isOuter() {
            return false;
        }

        @Override
        public Joins crossJoin(Table localTable, Table foreignTable) {
            return this;
        }

        @Override
        public Joins join(ForeignKey fk, boolean inverse, boolean toMany) {
            return this;
        }

        @Override
        public Joins outerJoin(ForeignKey fk, boolean inverse, boolean toMany) {
            return this;
        }

        @Override
        public Joins joinRelation(String name, ForeignKey fk, ClassMapping target, int subs, boolean inverse, boolean toMany) {
            return this;
        }

        @Override
        public Joins outerJoinRelation(String name, ForeignKey fk, ClassMapping target, int subs, boolean inverse, boolean toMany) {
            return this;
        }

        @Override
        public Joins setVariable(String var) {
            return this;
        }

        @Override
        public Joins setSubselect(String alias) {
            return this;
        }

        @Override
        public Joins setJoinContext(Context context) {
            return this;
        }

        public void appendTo(SQLBuffer buf) {
        }

        @Override
        public Joins setCorrelatedVariable(String var) {
            return this;
        }

        @Override
        public String getCorrelatedVariable() {
            return null;
        }

        @Override
        public void moveJoinsToParent() {
        }
    }
}

