/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.identifier;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.DBIdentifierUtil;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.NameSet;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.identifier.IdentifierConfiguration;
import org.apache.openjpa.lib.identifier.IdentifierRule;
import org.apache.openjpa.lib.identifier.IdentifierUtilImpl;
import org.apache.openjpa.lib.util.StringUtil;

public class DBIdentifierUtilImpl
extends IdentifierUtilImpl
implements DBIdentifierUtil,
Configurable {
    private JDBCConfiguration _conf = null;

    public DBIdentifierUtilImpl() {
    }

    public DBIdentifierUtilImpl(IdentifierConfiguration config) {
        super(config);
    }

    @Override
    public DBIdentifier getValidColumnIdentifier(DBIdentifier name, Table table, int maxLen, boolean checkForUniqueness) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        String rule = name.getType().name();
        maxLen = this.getMaxLen(rule, name, maxLen);
        DBIdentifier sName = DBIdentifier.removeLeading(name, "_");
        return this.makeIdentifierValid(sName, table, maxLen, checkForUniqueness);
    }

    @Override
    public DBIdentifier getValidForeignKeyIdentifier(DBIdentifier name, Table table, Table toTable, int maxLen) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        String rule = name.getType().name();
        maxLen = this.getMaxLen(rule, name, maxLen);
        DBIdentifier sName = this.makeName(rule, name, table, "F");
        return this.makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), maxLen, true);
    }

    @Override
    public DBIdentifier getValidUniqueIdentifier(DBIdentifier name, Table table, int maxLen) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        String rule = name.getType().name();
        maxLen = this.getMaxLen(rule, name, maxLen);
        DBIdentifier sName = this.makeName(rule, name, table, "U");
        return this.makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), maxLen, true);
    }

    @Override
    public DBIdentifier getValidIndexIdentifier(DBIdentifier name, Table table, int maxLen) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        String rule = name.getType().name();
        maxLen = this.getMaxLen(rule, name, maxLen);
        DBIdentifier sName = this.makeName(rule, name, table, "I");
        return this.makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), maxLen, true);
    }

    @Override
    public DBIdentifier getValidSequenceIdentifier(DBIdentifier name, Schema schema, int maxLen) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        String rule = name.getType().name();
        maxLen = this.getMaxLen(rule, name, maxLen);
        DBIdentifier sName = this.makeName(rule, name, "S");
        return this.makeIdentifierValid(sName, schema.getSchemaGroup(), maxLen, true);
    }

    @Override
    public DBIdentifier getValidTableIdentifier(DBIdentifier name, Schema schema, int maxLen) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        String rule = name.getType().name();
        maxLen = this.getMaxLen(rule, name, maxLen);
        DBIdentifier sName = this.makeName(rule, name, null);
        return this.makeIdentifierValid(sName, schema.getSchemaGroup(), maxLen, true);
    }

    @Override
    public DBIdentifier makeNameValid(String name, NameSet set, int maxLen, int nameType, boolean checkForUniqueness) {
        DBIdentifier.DBIdentifierType id = DBIdentifier.DBIdentifierType.DEFAULT;
        switch (nameType) {
            case 1: {
                id = DBIdentifier.DBIdentifierType.TABLE;
                break;
            }
            case 2: {
                id = DBIdentifier.DBIdentifierType.SEQUENCE;
                break;
            }
            case 3: {
                id = DBIdentifier.DBIdentifierType.COLUMN;
            }
        }
        return this.makeIdentifierValid(DBIdentifier.newIdentifier(name, id), set, maxLen, checkForUniqueness);
    }

    @Override
    public DBIdentifier makeIdentifierValid(DBIdentifier sname, NameSet set, int maxLen, boolean checkForUniqueness) {
        DBIdentifier validName = sname;
        String rule = sname.getType().name();
        maxLen = this.getMaxLen(rule, validName, maxLen);
        int nameLen = validName.getName().length();
        if (nameLen > maxLen) {
            validName = DBIdentifier.truncate(validName, nameLen - maxLen);
            nameLen = validName.getName().length();
        }
        if (this.isReservedWord(rule, validName.getName())) {
            if (nameLen == maxLen) {
                validName = DBIdentifier.truncate(validName, 1);
            }
            validName = DBIdentifier.append(validName, "0");
            nameLen = validName.getName().length();
        }
        if (set != null && checkForUniqueness) {
            int version = 1;
            int chars = 1;
            while (!(validName.getType() != DBIdentifier.DBIdentifierType.TABLE ? (validName.getType() != DBIdentifier.DBIdentifierType.SEQUENCE ? !set.isNameTaken(validName) : !((SchemaGroup)set).isKnownSequence(QualifiedDBIdentifier.getPath(validName))) : !((SchemaGroup)set).isKnownTable(QualifiedDBIdentifier.getPath(validName)))) {
                if (version > 1) {
                    validName = DBIdentifier.truncate(validName, chars);
                }
                if ((double)version >= Math.pow(10.0, chars)) {
                    ++chars;
                }
                if (nameLen + chars > maxLen) {
                    validName = DBIdentifier.truncate(validName, nameLen + chars - maxLen);
                }
                validName = DBIdentifier.append(validName, Integer.toString(version));
                nameLen = validName.getName().length();
                ++version;
            }
        }
        if (validName.isDelimited()) {
            String delimCase = this.getIdentifierConfiguration().getDelimitedCase();
            if (delimCase.equals("lower")) {
                return DBIdentifier.toLower(validName, true);
            }
            if (delimCase.equals("upper")) {
                return DBIdentifier.toUpper(validName, true);
            }
            return validName;
        }
        return DBIdentifier.toUpper(validName);
    }

    @Override
    public String toDBName(DBIdentifier name) {
        return this.toDBName(name, true);
    }

    @Override
    public String toDBName(DBIdentifier name, boolean delimit) {
        if (DBIdentifier.isNull(name)) {
            return null;
        }
        if (this.getIdentifierConfiguration().getSupportsDelimitedIdentifiers() && delimit && this.getIdentifierConfiguration().delimitAll() && !name.isDelimited()) {
            return this.delimit(name, true);
        }
        String rule = name.getType().name();
        if (name instanceof QualifiedDBIdentifier) {
            QualifiedDBIdentifier path = (QualifiedDBIdentifier)name;
            return this.convertFull(Normalizer.getNamingConfiguration(), rule, path.getName());
        }
        return this.convert(Normalizer.getNamingConfiguration(), rule, name.getName());
    }

    @Override
    public String toDBName(String name) {
        return this.toDBName(name, true);
    }

    @Override
    public String toDBName(String name, boolean delimit) {
        return this.toDBName(this.getIdentifierConfiguration().getDefaultIdentifierRule().getName(), name, delimit);
    }

    private String toDBName(String rule, String name, boolean delimit) {
        if (name == null) {
            return null;
        }
        if (this.getIdentifierConfiguration().getSupportsDelimitedIdentifiers() && delimit && this.getIdentifierConfiguration().delimitAll() && !Normalizer.isDelimited(name)) {
            return this.delimit(rule, name, true);
        }
        return this.convert(Normalizer.getNamingConfiguration(), rule, name);
    }

    @Override
    public DBIdentifier fromDBName(String name, DBIdentifier.DBIdentifierType id) {
        if (name == null) {
            return DBIdentifier.NULL;
        }
        if (!this.getIdentifierConfiguration().getSupportsDelimitedIdentifiers()) {
            return DBIdentifier.newIdentifier(name, id);
        }
        String delimCase = this.getIdentifierConfiguration().getDelimitedCase();
        String nonDelimCase = this.getIdentifierConfiguration().getSchemaCase();
        String caseName = name;
        if (delimCase.equals(nonDelimCase)) {
            return DBIdentifier.newIdentifier(name, id, false, false, !delimCase.equals("preserve"));
        }
        if (delimCase.equals("preserve")) {
            caseName = nonDelimCase.equals("lower") ? name.toLowerCase() : name.toUpperCase();
        } else if (delimCase.equals("lower")) {
            if (nonDelimCase.equals("upper")) {
                caseName = name.toUpperCase();
            }
        } else if (delimCase.equals("upper") && nonDelimCase.equals("lower")) {
            caseName = name.toLowerCase();
        }
        boolean delimit = !caseName.equals(name) || this.getIdentifierConfiguration().delimitAll();
        return DBIdentifier.newIdentifier(delimit ? name : caseName, id, false, delimit, !delimCase.equals("preserve"));
    }

    @Override
    public DBIdentifier append(DBIdentifier.DBIdentifierType resultId, DBIdentifier ... names) {
        if (names == null || names.length == 0) {
            return DBIdentifier.NULL;
        }
        DBIdentifier sName = DBIdentifier.newIdentifier("", resultId);
        for (DBIdentifier name : names) {
            DBIdentifier.append(sName, name.getName());
        }
        return sName;
    }

    @Override
    public String appendColumns(Column[] columns) {
        if (columns == null || columns.length == 0) {
            return "";
        }
        if (columns.length == 1) {
            return this.toDBName(columns[0].getIdentifier());
        }
        StringBuilder colsb = new StringBuilder("");
        for (int i = 0; i < columns.length; ++i) {
            colsb.append(this.toDBName(columns[i].getIdentifier()));
            if (i >= columns.length - 1) continue;
            colsb.append(", ");
        }
        return colsb.toString();
    }

    public String delimit(DBIdentifier name, boolean force) {
        QualifiedDBIdentifier path;
        String rule = name.getType().name();
        if (!(!(name instanceof QualifiedDBIdentifier) || (path = (QualifiedDBIdentifier)name).getType() == DBIdentifier.DBIdentifierType.COLUMN && path.isUnqualifiedColumn() || path.getType() != DBIdentifier.DBIdentifierType.COLUMN && path.isUnqualifiedObject())) {
            DBIdentifier[] names = QualifiedDBIdentifier.splitPath(name);
            for (int i = 0; i < names.length; ++i) {
                DBIdentifier sName = names[i].getUnqualifiedName();
                if (sName.isDelimited()) continue;
                String pRule = sName.getType().name();
                names[i].setName(this.delimit(pRule, sName.getName(), force));
            }
            return QualifiedDBIdentifier.newPath(names).getName();
        }
        return this.delimit(rule, name.getName(), force);
    }

    public String shorten(String name, int targetLength) {
        return DBDictionary.shorten(name, targetLength);
    }

    @Override
    public DBIdentifier getGeneratedKeySequenceName(Column col, int maxLen) {
        DBIdentifier tname = col.getTableIdentifier();
        DBIdentifier cname = col.getIdentifier();
        int max = maxLen;
        int extraChars = -max + tname.getName().length() + 1 + cname.getName().length() + 4;
        String tsname = tname.getName();
        if (extraChars > 0) {
            tsname = tsname.substring(0, tsname.length() - extraChars);
        }
        return DBIdentifier.combine(DBIdentifier.DBIdentifierType.SEQUENCE, tsname, cname.getName(), "SEQ");
    }

    @Override
    public DBIdentifier convertSchemaCase(DBIdentifier name) {
        if (DBIdentifier.isNull(name)) {
            return DBIdentifier.NULL;
        }
        DBIdentifier sName = name.clone();
        String delimCase = this.getIdentifierConfiguration().getDelimitedCase();
        if (name.isDelimited()) {
            if ("upper".equals(delimCase)) {
                sName = DBIdentifier.toUpper(sName, true);
            } else if ("lower".equals(delimCase)) {
                sName = DBIdentifier.toLower(sName, true);
            }
            return DBIdentifier.removeDelimiters(sName);
        }
        if (!this.getIdentifierConfiguration().delimitAll()) {
            String schemaCase = this.getIdentifierConfiguration().getSchemaCase();
            if ("lower".equals(schemaCase)) {
                return DBIdentifier.toLower(sName);
            }
            if ("preserve".equals(schemaCase)) {
                return sName;
            }
            return DBIdentifier.toUpper(sName);
        }
        return sName;
    }

    @Override
    public String convertAlias(String alias) {
        if (!this.needsConversion(this.getIdentifierConfiguration())) {
            return alias;
        }
        String[] names = Normalizer.splitName(alias);
        if (names.length <= 1) {
            return alias;
        }
        for (int i = 1; i < names.length; ++i) {
            names[i] = this.toDBName(this.getIdentifierConfiguration().getDefaultIdentifierRule().toString(), names[i], true);
        }
        return this.joinNames(this.getIdentifierConfiguration().getDefaultIdentifierRule(), names);
    }

    private DBIdentifier makeName(String rule, DBIdentifier name, Table tbl, String prefix) {
        DBIdentifier sName = DBIdentifier.removeLeading(name, "_");
        String tableName = tbl.getIdentifier().getName();
        int len = Math.min(tableName.length(), 7);
        String str = this.combineNames(Normalizer.getNamingConfiguration(), rule, new String[]{prefix == null ? "" : prefix, this.shorten(tableName, len), sName.getName()});
        sName.setName(str);
        return sName;
    }

    private DBIdentifier makeName(String rule, DBIdentifier name, String prefix) {
        DBIdentifier sName = DBIdentifier.removeLeading(name, "_");
        if (!StringUtil.isEmpty((String)prefix)) {
            sName = DBIdentifier.preCombine(sName, prefix);
        }
        return sName;
    }

    private int getMaxLen(String rule, DBIdentifier name, int maxLen) {
        IdentifierConfiguration config = this.getIdentifierConfiguration();
        if (maxLen < 1) {
            IdentifierRule nrule = config.getIdentifierRule((Object)rule);
            maxLen = nrule.getMaxLength();
        }
        if (config.delimitAll() || name.isDelimited()) {
            maxLen -= config.getLeadingDelimiter().length() + config.getTrailingDelimiter().length();
        }
        return maxLen;
    }

    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    public void setConfiguration(Configuration conf) {
        this._conf = (JDBCConfiguration)conf;
    }
}

