/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.Strategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.MetaDataException;

public abstract class MappingInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int JOIN_NONE = 0;
    public static final int JOIN_FORWARD = 1;
    public static final int JOIN_INVERSE = 2;
    private static final Object NULL = new Object();
    private static final Localizer _loc = Localizer.forPackage(MappingInfo.class);
    private String _strategy = null;
    private List<Column> _cols = null;
    private Index _idx = null;
    private Unique _unq = null;
    private ForeignKey _fk = null;
    private boolean _canIdx = true;
    private boolean _canUnq = true;
    private boolean _canFK = true;
    private boolean _implicitRelation = false;
    private int _join = 0;
    private ColumnIO _io = null;

    public String getStrategy() {
        return this._strategy;
    }

    public void setStrategy(String strategy) {
        this._strategy = strategy;
    }

    public List<Column> getColumns() {
        if (this._cols == null) {
            return Collections.emptyList();
        }
        return this._cols;
    }

    @Deprecated
    public List<Column> getColumns(String tableName) {
        return this.getColumns(DBIdentifier.newTable(tableName));
    }

    public List<Column> getColumns(DBIdentifier tableName) {
        if (this._cols == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column col : this._cols) {
            if (!DBIdentifier.equal(col.getTableIdentifier(), tableName)) continue;
            result.add(col);
        }
        return result;
    }

    public void setColumns(List<Column> cols) {
        this._cols = cols;
    }

    public Index getIndex() {
        return this._idx;
    }

    public void setIndex(Index idx) {
        this._idx = idx;
    }

    public boolean canIndex() {
        return this._canIdx;
    }

    public void setCanIndex(boolean indexable) {
        this._canIdx = indexable;
    }

    public boolean isImplicitRelation() {
        return this._implicitRelation;
    }

    public void setImplicitRelation(boolean flag) {
        this._implicitRelation |= flag;
    }

    public ForeignKey getForeignKey() {
        return this._fk;
    }

    public void setForeignKey(ForeignKey fk) {
        this._fk = fk;
        if (fk != null && this._join == 0) {
            this._join = 1;
        }
    }

    public boolean canForeignKey() {
        return this._canFK;
    }

    public void setCanForeignKey(boolean fkable) {
        this._canFK = fkable;
    }

    public Unique getUnique() {
        return this._unq;
    }

    public void setUnique(Unique unq) {
        this._unq = unq;
    }

    public boolean canUnique() {
        return this._canUnq;
    }

    public void setCanUnique(boolean uniquable) {
        this._canUnq = uniquable;
    }

    public ColumnIO getColumnIO() {
        return this._io;
    }

    public void setColumnIO(ColumnIO io) {
        this._io = io;
    }

    public int getJoinDirection() {
        return this._join;
    }

    public void setJoinDirection(int join) {
        this._join = join;
    }

    public void clear() {
        this.clear(true);
    }

    protected void clear(boolean canFlags) {
        this._strategy = null;
        this._cols = null;
        this._io = null;
        this._idx = null;
        this._unq = null;
        this._fk = null;
        this._join = 0;
        if (canFlags) {
            this._canIdx = true;
            this._canFK = true;
            this._canUnq = true;
        }
    }

    public void copy(MappingInfo info) {
        if (this._strategy == null) {
            this._strategy = info.getStrategy();
        }
        if (this._canIdx && this._idx == null) {
            if (info.getIndex() != null) {
                this._idx = info.getIndex();
            } else {
                this._canIdx = info.canIndex();
            }
        }
        if (this._canUnq && this._unq == null) {
            if (info.getUnique() != null) {
                this._unq = info.getUnique();
            } else {
                this._canUnq = info.canUnique();
            }
        }
        if (this._canFK && this._fk == null) {
            if (info.getForeignKey() != null) {
                this._fk = info.getForeignKey();
            } else {
                this._canFK = info.canForeignKey();
            }
        }
        this._implicitRelation = info.isImplicitRelation();
        List<Column> cols = this.getColumns();
        List<Column> icols = info.getColumns();
        if (!icols.isEmpty() && (cols.isEmpty() || cols.size() == icols.size())) {
            if (cols.isEmpty()) {
                cols = new ArrayList<Column>(icols.size());
            }
            for (int i = 0; i < icols.size(); ++i) {
                if (cols.size() == i) {
                    cols.add(new Column());
                }
                cols.get(i).copy(icols.get(i));
            }
            this.setColumns(cols);
        }
    }

    public boolean hasSchemaComponents() {
        return this._cols != null && !this._cols.isEmpty() || this._idx != null || this._unq != null || this._fk != null || !this._canIdx || !this._canFK || !this._canUnq;
    }

    public void assertNoSchemaComponents(MetaDataContext context, boolean die) {
        if (this._cols == null || this._cols.isEmpty()) {
            this.assertNoIndex(context, die);
            this.assertNoUnique(context, die);
            this.assertNoForeignKey(context, die);
            return;
        }
        Localizer.Message msg = _loc.get("unexpected-cols", (Object)context);
        if (die) {
            throw new MetaDataException(msg);
        }
        context.getRepository().getLog().warn((Object)msg);
    }

    public void assertStrategy(MetaDataContext context, Object contextStrat, Object expected, boolean die) {
        String strat;
        if (contextStrat == expected) {
            return;
        }
        if (contextStrat == null) {
            if (this._strategy == null) {
                return;
            }
            if (this._strategy.equals(expected.getClass().getName())) {
                return;
            }
            if (expected instanceof Strategy && this._strategy.equals(((Strategy)expected).getAlias())) {
                return;
            }
            strat = this._strategy;
        } else {
            strat = contextStrat instanceof Strategy ? ((Strategy)contextStrat).getAlias() : contextStrat.getClass().getName();
        }
        Localizer.Message msg = _loc.get("unexpected-strategy", (Object)context, expected, (Object)strat);
        if (die) {
            throw new MetaDataException(msg);
        }
        context.getRepository().getLog().warn((Object)msg);
    }

    public void assertNoIndex(MetaDataContext context, boolean die) {
        if (this._idx == null) {
            return;
        }
        Localizer.Message msg = _loc.get("unexpected-index", (Object)context);
        if (die) {
            throw new MetaDataException(msg);
        }
        context.getRepository().getLog().warn((Object)msg);
    }

    public void assertNoUnique(MetaDataContext context, boolean die) {
        if (this._unq == null) {
            return;
        }
        Localizer.Message msg = _loc.get("unexpected-unique", (Object)context);
        if (die) {
            throw new MetaDataException(msg);
        }
        context.getRepository().getLog().warn((Object)msg);
    }

    public void assertNoForeignKey(MetaDataContext context, boolean die) {
        if (this._fk == null || this.isImplicitRelation()) {
            return;
        }
        Localizer.Message msg = _loc.get("unexpected-fk", (Object)context);
        if (die) {
            throw new MetaDataException(msg);
        }
        context.getRepository().getLog().warn((Object)msg);
    }

    public void assertNoJoin(MetaDataContext context, boolean die) {
        boolean join = false;
        if (this._cols != null) {
            for (int i = 0; !join && i < this._cols.size(); ++i) {
                Column col = this._cols.get(i);
                if (DBIdentifier.isNull(col.getTargetIdentifier())) continue;
                join = true;
            }
        }
        if (!join) {
            return;
        }
        Localizer.Message msg = _loc.get("unexpected-join", (Object)context);
        if (die) {
            throw new MetaDataException(msg);
        }
        context.getRepository().getLog().warn((Object)msg);
    }

    @Deprecated
    public Table createTable(MetaDataContext context, TableDefaults def, String schemaName, String given, boolean adapt) {
        return this.createTable(context, def, DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(given), adapt);
    }

    public Table createTable(MetaDataContext context, TableDefaults def, DBIdentifier schemaName, DBIdentifier given, boolean adapt) {
        Table table;
        QualifiedDBIdentifier path;
        MappingRepository repos = (MappingRepository)context.getRepository();
        if (DBIdentifier.isNull(given) && (def == null || !adapt && !repos.getMappingDefaults().defaultMissingInfo())) {
            throw new MetaDataException(_loc.get("no-table", (Object)context));
        }
        if (DBIdentifier.isNull(schemaName) && (schemaName = Schemas.getNewTableSchemaIdentifier((JDBCConfiguration)repos.getConfiguration())) != null && schemaName.getType() == DBIdentifier.DBIdentifierType.NULL) {
            String name = repos.getMetaDataFactory().getDefaults().getDefaultSchema();
            schemaName = name != null ? DBIdentifier.newSchema(name) : schemaName;
        }
        SchemaGroup group = repos.getSchemaGroup();
        Schema schema = null;
        if (DBIdentifier.isNull(given)) {
            schema = group.getSchema(schemaName);
            if (schema == null) {
                schema = group.addSchema(schemaName);
            }
            given = def.getIdentifier(schema);
        }
        if (DBIdentifier.isNull((path = QualifiedDBIdentifier.getPath(given)).getSchemaName())) {
            if (!DBIdentifier.isNull(schemaName)) {
                path.setSchemaName(schemaName);
            }
        } else {
            schemaName = path.getSchemaName();
            schema = null;
        }
        if ((table = group.findTable(path)) != null) {
            return table;
        }
        if (!adapt) {
            throw new MetaDataException(_loc.get("bad-table", (Object)given, (Object)context));
        }
        if (schema == null && (schema = group.getSchema(schemaName)) == null) {
            schema = group.addSchema(schemaName);
        }
        if ((table = schema.getTable(given)) == null) {
            table = schema.addTable(given);
        }
        return table;
    }

    protected Column[] createColumns(MetaDataContext context, String prefix, Column[] tmplates, Table table, boolean adapt) {
        MappingInfo.assertTable(context, table);
        if (prefix == null) {
            prefix = "generic";
        }
        List<Column> given = this.getColumns();
        if (context instanceof FieldMapping && ((FieldMapping)context).hasMapsIdCols()) {
            given = ((FieldMapping)context).getValueInfo().getMapsIdColumns();
        }
        boolean fill = ((MappingRepository)context.getRepository()).getMappingDefaults().defaultMissingInfo();
        if (!(given.isEmpty() && (adapt || fill) || given.size() == tmplates.length)) {
            given = this.getColumns(table.getIdentifier());
            if (!adapt && !fill && given.size() != tmplates.length) {
                given = this.getColumns("");
                if (!adapt && !fill && given.size() != tmplates.length) {
                    throw new MetaDataException(_loc.get(prefix + "-num-cols", (Object)context, (Object)String.valueOf(tmplates.length), (Object)String.valueOf(given.size())));
                }
            }
        }
        Column[] cols = new Column[tmplates.length];
        this._io = null;
        for (int i = 0; i < tmplates.length; ++i) {
            Column col = given.isEmpty() ? null : given.get(i);
            cols[i] = MappingInfo.mergeColumn(context, prefix, tmplates[i], true, col, table, adapt, fill);
            this.setIOFromColumnFlags(col, i);
        }
        return cols;
    }

    private void setIOFromColumnFlags(Column col, int i) {
        if (col == null || !col.getFlag(2) && !col.getFlag(4) && !col.isNotNull()) {
            return;
        }
        if (this._io == null) {
            this._io = new ColumnIO();
        }
        this._io.setInsertable(i, !col.getFlag(2));
        this._io.setUpdatable(i, !col.getFlag(4));
        this._io.setNullInsertable(i, !col.isNotNull());
        this._io.setNullUpdatable(i, !col.isNotNull());
    }

    private static void assertTable(MetaDataContext context, Table table) {
        if (table == null) {
            throw new MetaDataException(_loc.get("unmapped", (Object)context));
        }
    }

    protected static Column mergeColumn(MetaDataContext context, String prefix, Column tmplate, boolean compat, Column given, Table table, boolean adapt, boolean fill) {
        QualifiedDBIdentifier path;
        DBIdentifier colName;
        MappingInfo.assertTable(context, table);
        DBIdentifier dBIdentifier = colName = given == null ? DBIdentifier.NULL : given.getIdentifier();
        if (DBIdentifier.isNull(colName) && !adapt && !fill) {
            throw new MetaDataException(_loc.get(prefix + "-no-col-name", (Object)context));
        }
        MappingRepository repos = (MappingRepository)context.getRepository();
        DBDictionary dict = repos.getDBDictionary();
        if (DBIdentifier.isNull(colName)) {
            colName = tmplate.getIdentifier();
        }
        if ((path = QualifiedDBIdentifier.getPath(colName)).isUnqualifiedColumn()) {
            colName = path.getIdentifier();
        } else if (!DBIdentifier.isNull(path.getObjectTableName())) {
            MappingInfo.findTable(context, path.getObjectTableName(), table, null, null);
            colName = path.getUnqualifiedName();
        }
        Column col = table.getColumn(colName);
        if (col == null && !adapt) {
            if (colName.getName().length() > dict.maxColumnNameLength || dict.getInvalidColumnWordSet().contains(DBIdentifier.toUpper(colName).getName()) && !table.getClass().getName().contains("DynamicTable")) {
                col = table.getColumn(colName = dict.getValidColumnName(colName, new Table()));
                if (col == null && !adapt) {
                    throw new MetaDataException(_loc.get(prefix + "-bad-col-name", (Object)context, (Object)colName, (Object)table));
                }
            } else {
                throw new MetaDataException(_loc.get(prefix + "-bad-col-name", (Object)context, (Object)colName, (Object)table));
            }
        }
        int type = tmplate.getType();
        int size = tmplate.getSize();
        if (type == 1111) {
            int precis = 0;
            int scale = 0;
            if (given != null) {
                precis = given.getSize();
                scale = given.getDecimalDigits();
            }
            type = dict.getJDBCType(tmplate.getJavaType(), size == -1, precis, scale, tmplate.isXML());
        }
        boolean ttype = true;
        int otype = type;
        String typeName = tmplate.getTypeName();
        Boolean notNull = null;
        if (tmplate.isNotNullExplicit()) {
            notNull = tmplate.isNotNull() ? Boolean.TRUE : Boolean.FALSE;
        }
        int decimals = tmplate.getDecimalDigits();
        String defStr = tmplate.getDefaultString();
        boolean autoAssign = tmplate.isAutoAssigned();
        boolean relationId = tmplate.isRelationId();
        boolean implicitRelation = tmplate.isImplicitRelation();
        String targetField = tmplate.getTargetField();
        if (given != null) {
            if (given.getType() != 1111) {
                Log log;
                ttype = false;
                if (compat && !given.isCompatible(type, typeName, size, decimals) && (log = repos.getLog()).isWarnEnabled()) {
                    log.warn((Object)_loc.get(prefix + "-incompat-col", (Object)context, (Object)colName, (Object)Schemas.getJDBCName(type)));
                }
                otype = given.getType();
                type = dict.getPreferredType(otype);
            }
            typeName = given.getTypeName();
            if (given.getSize() > 0) {
                size = given.getSize();
            }
            decimals = given.getDecimalDigits();
            if (given.isNotNullExplicit()) {
                Boolean bl = notNull = given.isNotNull() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (given.getDefaultString() != null) {
                defStr = given.getDefaultString();
            }
            if (given.isAutoAssigned()) {
                autoAssign = true;
            }
            if (given.isRelationId()) {
                relationId = true;
            }
            if (given.isImplicitRelation()) {
                implicitRelation = true;
            }
        }
        if (size == 0 && (otype == 12 || otype == 1)) {
            size = dict.characterColumnSize;
        }
        if (col == null) {
            col = table.addColumn(colName);
            col.setType(type);
        } else if (!(!compat && ttype || col.isCompatible(type, typeName, size, decimals))) {
            Localizer.Message msg = _loc.get(prefix + "-bad-col", (Object)context, (Object)Schemas.getJDBCName(type), (Object)col.getDescription());
            if (!adapt && !dict.disableSchemaFactoryColumnTypeErrors) {
                throw new MetaDataException(msg);
            }
            Log log = repos.getLog();
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            col.setType(type);
        } else if (given != null && given.getType() != 1111) {
            col.setType(type);
        }
        if (compat) {
            col.setJavaType(tmplate.getJavaType());
        } else if (col.getJavaType() == 8) {
            if (given != null && given.getJavaType() != 8) {
                col.setJavaType(given.getJavaType());
            } else {
                col.setJavaType(JavaTypes.getTypeCode(Schemas.getJavaType(col.getType(), col.getSize(), col.getDecimalDigits())));
            }
        }
        col.setAutoAssigned(autoAssign);
        col.setRelationId(relationId);
        col.setImplicitRelation(implicitRelation);
        col.setTargetField(targetField);
        if (defStr != null) {
            col.setDefaultString(defStr);
        }
        if (notNull != null) {
            col.setNotNull(notNull);
        }
        if (adapt) {
            if (typeName != null) {
                col.setTypeName(typeName);
            }
            if (size != 0) {
                col.setSize(size);
            }
            if (decimals != 0) {
                col.setDecimalDigits(decimals);
            }
        }
        if (tmplate.hasComment()) {
            col.setComment(tmplate.getComment());
        }
        if (tmplate.isXML()) {
            col.setXML(tmplate.isXML());
        }
        return col;
    }

    private static Table findTable(MetaDataContext context, DBIdentifier name, Table expected, Table inverse, ClassMapping rel) {
        if (expected == null && rel != null) {
            expected = rel.getTable();
        }
        if (expected != null && MappingInfo.isTableName(name, expected)) {
            return expected;
        }
        if (inverse != null && MappingInfo.isTableName(name, inverse)) {
            return inverse;
        }
        if (rel != null) {
            rel = rel.getJoinablePCSuperclassMapping();
        }
        while (rel != null) {
            if (MappingInfo.isTableName(name, rel.getTable())) {
                return rel.getTable();
            }
            rel = rel.getJoinablePCSuperclassMapping();
        }
        throw new MetaDataException(_loc.get("col-wrong-table", (Object)context, (Object)expected, (Object)name.getName()));
    }

    private static boolean isTableName(DBIdentifier name, Table table) {
        return DBIdentifier.equal(name, table.getIdentifier()) || DBIdentifier.equal(name, table.getFullIdentifier());
    }

    protected Index createIndex(MetaDataContext context, String prefix, Index tmplate, Column[] cols, boolean adapt) {
        boolean unq;
        if (prefix == null) {
            prefix = "generic";
        }
        if (cols == null || cols.length == 0) {
            if (this._idx != null) {
                throw new MetaDataException(_loc.get(prefix + "-no-index-cols", (Object)context));
            }
            return null;
        }
        Table table = cols[0].getTable();
        Index[] idxs = table.getIndexes();
        Index exist = null;
        for (int i = 0; i < idxs.length; ++i) {
            if (!idxs[i].columnsMatch(cols)) continue;
            exist = idxs[i];
            break;
        }
        if (!this._canIdx) {
            if (exist == null) {
                return null;
            }
            if (!adapt) {
                throw new MetaDataException(_loc.get(prefix + "-index-exists", (Object)context));
            }
            table.removeIndex(exist);
            return null;
        }
        if (exist != null) {
            if (this._idx != null && this._idx.isUnique() && !exist.isUnique()) {
                if (!adapt) {
                    throw new MetaDataException(_loc.get(prefix + "-index-not-unique", (Object)context));
                }
                exist.setUnique(true);
            }
            return exist;
        }
        MappingRepository repos = (MappingRepository)context.getRepository();
        boolean fill = repos.getMappingDefaults().defaultMissingInfo();
        if (this._idx == null && (tmplate == null || !adapt && !fill)) {
            return null;
        }
        DBIdentifier name = DBIdentifier.NULL;
        if (this._idx != null) {
            name = this._idx.getIdentifier();
            unq = this._idx.isUnique();
            if (this._idx.getColumns() != null && this._idx.getColumns().length > 1) {
                cols = this._idx.getColumns();
            }
        } else {
            unq = tmplate.isUnique();
        }
        if (DBIdentifier.isNull(name)) {
            if (tmplate != null) {
                name = tmplate.getIdentifier();
            } else {
                name = cols[0].getIdentifier();
                name = repos.getDBDictionary().getValidIndexName(name, table);
            }
        }
        Index idx = table.addIndex(name);
        idx.setUnique(unq);
        idx.setColumns(cols);
        return idx;
    }

    protected Unique createUnique(MetaDataContext context, String prefix, Unique tmplate, Column[] cols, boolean adapt) {
        boolean deferred;
        if (prefix == null) {
            prefix = "generic";
        }
        if (cols == null || cols.length == 0) {
            if (this._unq != null || tmplate != null) {
                throw new MetaDataException(_loc.get(prefix + "-no-unique-cols", (Object)context));
            }
            return null;
        }
        Table table = cols[0].getTable();
        Unique[] unqs = table.getUniques();
        Unique exist = null;
        for (int i = 0; i < unqs.length; ++i) {
            if (!unqs[i].columnsMatch(cols)) continue;
            exist = unqs[i];
            break;
        }
        if (!this._canUnq) {
            if (exist == null) {
                return null;
            }
            if (!adapt) {
                throw new MetaDataException(_loc.get(prefix + "-unique-exists", (Object)context));
            }
            table.removeUnique(exist);
            return null;
        }
        if (tmplate == null && this._unq == null) {
            return exist;
        }
        MappingRepository repos = (MappingRepository)context.getRepository();
        if (exist != null) {
            Log log;
            if (this._unq != null && this._unq.isDeferred() && !exist.isDeferred() && (log = repos.getLog()).isWarnEnabled()) {
                log.warn((Object)_loc.get(prefix + "-defer-unique", (Object)context));
            }
            return exist;
        }
        DBDictionary dict = repos.getDBDictionary();
        if (this._unq != null && !dict.supportsUniqueConstraints) {
            Log log = repos.getLog();
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get(prefix + "-unique-support", (Object)context));
            }
            return null;
        }
        boolean fill = repos.getMappingDefaults().defaultMissingInfo();
        if (!adapt && !fill && this._unq == null) {
            return null;
        }
        DBIdentifier name = DBIdentifier.NULL;
        if (this._unq != null) {
            name = this._unq.getIdentifier();
            deferred = this._unq.isDeferred();
        } else {
            name = tmplate.getIdentifier();
            deferred = tmplate.isDeferred();
        }
        if (deferred && !dict.supportsDeferredConstraints) {
            Log log = repos.getLog();
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get(prefix + "-create-defer-unique", (Object)context, (Object)dict.platform));
            }
            deferred = false;
        }
        if (DBIdentifier.isEmpty(name)) {
            name = cols[0].getIdentifier();
            name = repos.getDBDictionary().getValidUniqueName(name, table);
        }
        Unique unq = table.addUnique(name);
        unq.setDeferred(deferred);
        unq.setColumns(cols);
        return unq;
    }

    protected ForeignKey createForeignKey(MetaDataContext context, String prefix, List<Column> given, ForeignKeyDefaults def, Table table, ClassMapping cls, ClassMapping rel, boolean inversable, boolean adapt) {
        Log log;
        ForeignKey tmplate;
        MappingInfo.assertTable(context, table);
        if (prefix == null) {
            prefix = "generic";
        }
        Object[][] joins = this.createJoins(context, prefix, table, cls, rel, given, def, inversable, adapt);
        this._join = 1;
        Table local = table;
        Table foreign = rel.getTable();
        boolean constant = false;
        boolean localSet = false;
        for (int i = 0; i < joins.length; ++i) {
            if (joins[i][1] instanceof Column) {
                Table tmp = ((Column)joins[i][0]).getTable();
                if (!localSet) {
                    local = tmp;
                    localSet = true;
                } else if (tmp != local) {
                    throw new MetaDataException(_loc.get(prefix + "-mult-fk-tables", (Object)context, (Object)local, (Object)tmp));
                }
                foreign = ((Column)joins[i][1]).getTable();
                if (joins[i][2] != Boolean.TRUE) continue;
                this._join = 2;
                continue;
            }
            constant = true;
        }
        ForeignKey exist = null;
        if (!constant && local.getForeignKeys().length > 0) {
            Column[] cols = new Column[joins.length];
            Column[] pks = new Column[joins.length];
            for (int i = 0; i < joins.length; ++i) {
                cols[i] = (Column)joins[i][0];
                pks[i] = (Column)joins[i][1];
            }
            ForeignKey[] fks = local.getForeignKeys();
            for (int i = 0; i < fks.length; ++i) {
                if (fks[i].getConstantColumns().length != 0 || fks[i].getConstantPrimaryKeyColumns().length != 0 || !fks[i].columnsMatch(cols, pks)) continue;
                exist = fks[i];
                break;
            }
        }
        MappingRepository repos = (MappingRepository)context.getRepository();
        DBDictionary dict = repos.getDBDictionary();
        if (exist != null) {
            Log log2;
            if (!this._canFK) {
                if (exist.getDeleteAction() != 1 && !adapt) {
                    throw new MetaDataException(_loc.get(prefix + "-fk-exists", (Object)context));
                }
                exist.setDeleteAction(1);
            }
            if (this._fk != null && this._fk.isDeferred() && !exist.isDeferred() && (log2 = repos.getLog()).isWarnEnabled()) {
                log2.warn((Object)_loc.get(prefix + "-defer-fk", (Object)context));
            }
            if (adapt && this._fk != null) {
                if (this._fk.getUpdateAction() != 1) {
                    exist.setUpdateAction(this._fk.getUpdateAction());
                }
                if (this._fk.getDeleteAction() != 1) {
                    exist.setDeleteAction(this._fk.getDeleteAction());
                }
            }
            this.setIOFromJoins(exist, joins);
            return exist;
        }
        DBIdentifier name = DBIdentifier.NULL;
        int delAction = 1;
        int upAction = 1;
        boolean deferred = false;
        boolean fill = repos.getMappingDefaults().defaultMissingInfo();
        ForeignKey foreignKey = def == null ? null : (tmplate = def.get(local, foreign, this._join == 2));
        if (this._fk != null && (tmplate == null || !adapt && !fill)) {
            name = this._fk.getIdentifier();
            delAction = this._fk.getDeleteAction();
            upAction = this._fk.getUpdateAction();
            deferred = this._fk.isDeferred();
        } else if (this._canFK && (adapt || fill)) {
            if (this._fk == null && tmplate != null) {
                name = tmplate.getIdentifier();
                delAction = tmplate.getDeleteAction();
                upAction = tmplate.getUpdateAction();
                deferred = tmplate.isDeferred();
            } else if (this._fk != null && tmplate != null) {
                name = this._fk.getIdentifier();
                if (DBIdentifier.isNull(name) && !DBIdentifier.isNull(tmplate.getIdentifier())) {
                    name = tmplate.getIdentifier();
                }
                if ((delAction = this._fk.getDeleteAction()) == 1) {
                    delAction = tmplate.getDeleteAction();
                }
                if ((upAction = this._fk.getUpdateAction()) == 1) {
                    upAction = tmplate.getUpdateAction();
                }
                deferred = this._fk.isDeferred();
            }
        }
        if (!dict.supportsDeleteAction(delAction) || !dict.supportsUpdateAction(upAction)) {
            log = repos.getLog();
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get(prefix + "-unsupported-fk-action", (Object)context));
            }
            delAction = 1;
            upAction = 1;
        }
        if (deferred && !dict.supportsDeferredConstraints) {
            log = repos.getLog();
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get(prefix + "-create-defer-fk", (Object)context, (Object)dict.platform));
            }
            deferred = false;
        }
        ForeignKey fk = local.addForeignKey(name);
        fk.setDeleteAction(delAction);
        fk.setUpdateAction(upAction);
        fk.setDeferred(deferred);
        for (int i = 0; i < joins.length; ++i) {
            Column col = (Column)joins[i][0];
            if (joins[i][1] instanceof Column) {
                fk.join(col, (Column)joins[i][1]);
                continue;
            }
            if (joins[i][2] == Boolean.TRUE != (this._join == 2)) {
                fk.joinConstant(joins[i][1], col);
                continue;
            }
            fk.joinConstant(col, joins[i][1]);
        }
        this.setIOFromJoins(fk, joins);
        return fk;
    }

    private void setIOFromJoins(ForeignKey fk, Object[][] joins) {
        List<Column> cols = this.getColumns();
        this._io = null;
        if (cols.isEmpty()) {
            return;
        }
        int constIdx = 0;
        for (int i = 0; i < joins.length; ++i) {
            int idx;
            if (joins[i][1] instanceof Column) {
                idx = i - constIdx;
            } else {
                if (joins[i][2] == Boolean.TRUE != (this._join == 2)) continue;
                idx = fk.getColumns().length + constIdx++;
            }
            this.setIOFromColumnFlags(cols.get(i), idx);
        }
    }

    private Object[][] createJoins(MetaDataContext context, String prefix, Table table, ClassMapping cls, ClassMapping rel, List<Column> given, ForeignKeyDefaults def, boolean inversable, boolean adapt) {
        MappingRepository repos = (MappingRepository)context.getRepository();
        boolean fill = repos.getMappingDefaults().defaultMissingInfo();
        if (given.isEmpty()) {
            if (!adapt && !fill) {
                throw new MetaDataException(_loc.get(prefix + "-no-fk-cols", (Object)context));
            }
            Column[] targets = rel.getPrimaryKeyColumns();
            Object[][] joins = new Object[targets.length][3];
            for (int i = 0; i < targets.length; ++i) {
                Column tmplate = new Column();
                tmplate.setIdentifier(targets[i].getIdentifier());
                tmplate.setJavaType(targets[i].getJavaType());
                tmplate.setType(targets[i].getType());
                tmplate.setTypeName(targets[i].getTypeName());
                tmplate.setSize(targets[i].getSize());
                tmplate.setDecimalDigits(targets[i].getDecimalDigits());
                if (def != null) {
                    def.populate(table, rel.getTable(), tmplate, targets[i], false, i, targets.length);
                }
                joins[i][0] = MappingInfo.mergeColumn(context, prefix, tmplate, true, null, table, adapt, fill);
                joins[i][1] = targets[i];
            }
            return joins;
        }
        Object[][] joins = new Object[given.size()][3];
        for (int i = 0; i < joins.length; ++i) {
            Column col = given.get(i);
            this.mergeJoinColumn(context, prefix, col, joins, i, table, cls, rel, def, inversable && !col.getFlag(128), adapt, fill);
        }
        return joins;
    }

    private void mergeJoinColumn(MetaDataContext context, String prefix, Column given, Object[][] joins, int idx, Table table, ClassMapping cls, ClassMapping rel, ForeignKeyDefaults def, boolean inversable, boolean adapt, boolean fill) {
        PrimaryKey pk;
        boolean forceInverse;
        QualifiedDBIdentifier path;
        Column[] pks;
        DBIdentifier name = given.getIdentifier();
        if (DBIdentifier.isNull(name) && given.getFlag(128) && cls != null && (pks = cls.getPrimaryKeyColumns()).length == 1) {
            name = pks[0].getIdentifier();
        }
        if (DBIdentifier.isNull(name) && !adapt && !fill) {
            throw new MetaDataException(_loc.get(prefix + "-no-fkcol-name", (Object)context));
        }
        Table local = table;
        Table foreign = rel.getTable();
        boolean fullName = false;
        boolean inverse = false;
        if (!DBIdentifier.isNull(name) && !DBIdentifier.isNull((path = QualifiedDBIdentifier.getPath(name)).getObjectTableName())) {
            local = DBIdentifier.isEmpty(path.getObjectTableName()) ? foreign : MappingInfo.findTable(context, path.getObjectTableName(), local, foreign, null);
            fullName = true;
            name = path.getIdentifier().getUnqualifiedName();
            if (local != table) {
                foreign = table;
                inverse = true;
            }
        }
        boolean bl = forceInverse = !fullName && this._join == 2;
        if (forceInverse) {
            local = foreign;
            foreign = table;
            inverse = true;
        }
        DBIdentifier targetName = given.getTargetIdentifier();
        Object target = null;
        Table ttable = null;
        boolean constant = false;
        boolean fullTarget = false;
        if (DBIdentifier.isNull(targetName) && given.getTargetField() != null) {
            ClassMapping tcls = inverse ? cls : rel;
            String fieldName = given.getTargetField();
            String[] names = Normalizer.splitName(fieldName);
            boolean bl2 = fullTarget = names.length > 1;
            if (names.length > 1 && StringUtil.isEmpty((String)names[0])) {
                if (!inverse) {
                    tcls = cls;
                }
                fieldName = names[1];
            } else if (names.length > 1) {
                tcls = MappingInfo.findClassMapping(context, names[0], cls, rel);
                fieldName = names[1];
            }
            if (tcls == null) {
                throw new MetaDataException(_loc.get(prefix + "-bad-fktargetcls", (Object)context, (Object)fieldName, (Object)name));
            }
            FieldMapping field = tcls.getFieldMapping(fieldName);
            if (field == null) {
                throw new MetaDataException(_loc.get(prefix + "-bad-fktargetfield", new Object[]{context, fieldName, name, tcls}));
            }
            if (field.getColumns().length != 1) {
                throw new MetaDataException(_loc.get(prefix + "-fktargetfield-cols", (Object)context, (Object)fieldName, (Object)name));
            }
            ttable = field.getJoinForeignKey() != null ? field.getTable() : field.getDefiningMapping().getTable();
            targetName = field.getColumns()[0].getIdentifier();
        } else if (!DBIdentifier.isNull(targetName)) {
            String targetNameStr = targetName.getName();
            if (targetNameStr.charAt(0) == '\'') {
                constant = true;
                target = targetNameStr.substring(1, targetNameStr.length() - 1);
            } else if (targetNameStr.charAt(0) == '-' || targetNameStr.charAt(0) == '.' || Character.isDigit(targetNameStr.charAt(0))) {
                constant = true;
                try {
                    if (targetNameStr.indexOf(46) == -1) {
                        target = new Integer(targetNameStr);
                    }
                    target = new Double(targetNameStr);
                }
                catch (RuntimeException re) {
                    throw new MetaDataException(_loc.get(prefix + "-bad-fkconst", (Object)context, (Object)targetName, (Object)name));
                }
            } else if ("null".equalsIgnoreCase(targetNameStr)) {
                constant = true;
            } else {
                QualifiedDBIdentifier path2 = QualifiedDBIdentifier.getPath(targetName);
                boolean bl3 = fullTarget = !DBIdentifier.isNull(path2.getObjectTableName());
                if (!DBIdentifier.isNull(path2.getObjectTableName()) && DBIdentifier.isEmpty(path2.getObjectTableName())) {
                    if (!inverse) {
                        ttable = local;
                    }
                    targetName = path2.getIdentifier().getUnqualifiedName();
                } else if (!DBIdentifier.isNull(path2.getObjectTableName())) {
                    ttable = MappingInfo.findTable(context, path2.getObjectTableName(), foreign, local, inverse ? cls : rel);
                    targetName = path2.getIdentifier().getUnqualifiedName();
                }
            }
        }
        if (ttable == local && local != foreign) {
            if (fullName) {
                throw new MetaDataException(_loc.get(prefix + "-bad-fktarget-inverse", new Object[]{context, name, foreign, ttable}));
            }
            local = foreign;
            foreign = ttable;
        } else if (ttable != null) {
            foreign = ttable;
        }
        boolean bl4 = inverse = inverse || local != table || local == foreign && (fullName && !fullTarget || DBIdentifier.isNull(name) && fullTarget);
        if (!inversable && !constant && inverse) {
            if (local == foreign) {
                throw new MetaDataException(_loc.get(prefix + "-bad-fk-self-inverse", (Object)context, (Object)local));
            }
            throw new MetaDataException(_loc.get(prefix + "-bad-fk-inverse", (Object)context, (Object)local, (Object)table));
        }
        if (DBIdentifier.isNull(name) && constant) {
            throw new MetaDataException(_loc.get(prefix + "-no-fkcol-name-adapt", (Object)context));
        }
        if (DBIdentifier.isNull(name) && DBIdentifier.isNull(targetName)) {
            pk = foreign.getPrimaryKey();
            if (joins.length != 1 || pk == null || pk.getColumns().length != 1) {
                throw new MetaDataException(_loc.get(prefix + "-no-fkcol-name-adapt", (Object)context));
            }
            targetName = pk.getColumns()[0].getIdentifier();
        } else if (!DBIdentifier.isNull(name) && DBIdentifier.isNull(targetName)) {
            pk = foreign.getPrimaryKey();
            if (joins.length == 1 && pk != null && pk.getColumns().length == 1) {
                targetName = pk.getColumns()[0].getIdentifier();
            } else if (foreign.getColumn(name) != null) {
                targetName = name;
            } else {
                throw new MetaDataException(_loc.get(prefix + "-no-fkcol-target-adapt", (Object)context, (Object)name));
            }
        }
        Column tmplate = new Column();
        tmplate.setIdentifier(name);
        if (!constant) {
            Column tcol = foreign.getColumn(targetName, false);
            if (tcol == null) {
                String schemaCase = rel.getMappingRepository().getDBDictionary().schemaCase;
                if ("lower".equals(schemaCase)) {
                    tcol = foreign.getColumn(DBIdentifier.toLower(targetName, true), false);
                } else if ("upper".equals(schemaCase)) {
                    tcol = foreign.getColumn(DBIdentifier.toUpper(targetName, true), false);
                }
            }
            if (tcol == null) {
                throw new MetaDataException(_loc.get(prefix + "-bad-fktarget", new Object[]{context, targetName, name, foreign}));
            }
            if (DBIdentifier.isNull(name)) {
                tmplate.setIdentifier(tcol.getIdentifier());
            }
            tmplate.setJavaType(tcol.getJavaType());
            tmplate.setType(tcol.getType());
            tmplate.setTypeName(tcol.getTypeName());
            tmplate.setSize(tcol.getSize());
            tmplate.setDecimalDigits(tcol.getDecimalDigits());
            target = tcol;
        } else if (target instanceof String) {
            tmplate.setJavaType(9);
        } else if (target instanceof Integer) {
            tmplate.setJavaType(5);
        } else if (target instanceof Double) {
            tmplate.setJavaType(3);
        }
        if (def != null) {
            def.populate(local, foreign, tmplate, target, inverse, idx, joins.length);
        }
        if (!DBIdentifier.isNull(name)) {
            tmplate.setIdentifier(name);
        }
        Column col = MappingInfo.mergeColumn(context, prefix, tmplate, true, given, local, adapt, fill);
        joins[idx][0] = col;
        joins[idx][1] = target;
        if (inverse) {
            joins[idx][2] = Boolean.TRUE;
        }
    }

    private static ClassMapping findClassMapping(MetaDataContext context, String clsName, ClassMapping cls, ClassMapping rel) {
        if (MappingInfo.isClassMappingName(clsName, cls)) {
            return cls;
        }
        if (MappingInfo.isClassMappingName(clsName, rel)) {
            return rel;
        }
        throw new MetaDataException(_loc.get("target-wrong-cls", new Object[]{context, clsName, cls, rel}));
    }

    private static boolean isClassMappingName(String name, ClassMapping cls) {
        if (cls == null) {
            return false;
        }
        if (name.equals(cls.getDescribedType().getName()) || name.equals(ClassUtil.getClassName((Class)cls.getDescribedType()))) {
            return true;
        }
        return MappingInfo.isClassMappingName(name, cls.getPCSuperclassMapping());
    }

    protected void syncColumns(MetaDataContext context, Column[] cols, boolean forceJDBCType) {
        if (cols == null || cols.length == 0) {
            this._cols = null;
        } else {
            this._cols = new ArrayList<Column>(cols.length);
            for (int i = 0; i < cols.length; ++i) {
                Column col = MappingInfo.syncColumn(context, cols[i], cols.length, forceJDBCType, cols[i].getTable(), null, null, false);
                this.setColumnFlagsFromIO(col, i);
                this._cols.add(col);
            }
        }
    }

    private void setColumnFlagsFromIO(Column col, int i) {
        if (this._io == null) {
            return;
        }
        col.setFlag(4, !this._io.isUpdatable(i, false));
        col.setFlag(2, !this._io.isInsertable(i, false));
    }

    protected void syncIndex(MetaDataContext context, Index idx) {
        if (idx == null) {
            this._idx = null;
            return;
        }
        this._canIdx = true;
        this._idx = new Index();
        this._idx.setIdentifier(idx.getIdentifier());
        this._idx.setUnique(idx.isUnique());
        if (idx.getColumns() != null && idx.getColumns().length > 1) {
            this._idx.setColumns(idx.getColumns());
        }
    }

    protected void syncUnique(MetaDataContext context, Unique unq) {
        if (unq == null) {
            this._unq = null;
            return;
        }
        this._canUnq = true;
        this._unq = new Unique();
        this._unq.setIdentifier(unq.getIdentifier());
        this._unq.setDeferred(unq.isDeferred());
    }

    protected void syncForeignKey(MetaDataContext context, ForeignKey fk, Table local, Table target) {
        int i;
        Column col;
        if (fk == null) {
            this._fk = null;
            this._cols = null;
            this._join = 0;
            return;
        }
        if (this._join == 0) {
            this._join = 1;
        }
        if (fk.isLogical()) {
            this._fk = null;
        } else {
            this._canFK = true;
            this._fk = new ForeignKey();
            this._fk.setIdentifier(fk.getIdentifier());
            this._fk.setDeleteAction(fk.getDeleteAction());
            this._fk.setUpdateAction(fk.getUpdateAction());
            this._fk.setDeferred(fk.isDeferred());
        }
        Column[] cols = fk.getColumns();
        Column[] pkCols = fk.getPrimaryKeyColumns();
        Column[] ccols = fk.getConstantColumns();
        Object[] cs = fk.getConstants();
        Column[] cpkCols = fk.getConstantPrimaryKeyColumns();
        Object[] cpks = fk.getPrimaryKeyConstants();
        int size = cols.length + ccols.length + cpkCols.length;
        this._cols = new ArrayList<Column>(size);
        for (int i2 = 0; i2 < cols.length; ++i2) {
            col = MappingInfo.syncColumn(context, cols[i2], size, false, local, target, pkCols[i2], this._join == 2);
            this.setColumnFlagsFromIO(col, i2);
            this._cols.add(col);
        }
        for (i = 0; i < ccols.length; ++i) {
            Object constant = cs[i] == null ? NULL : cs[i];
            col = MappingInfo.syncColumn(context, ccols[i], size, false, local, target, constant, this._join == 2);
            this.setColumnFlagsFromIO(col, cols.length + i);
            this._cols.add(col);
        }
        for (i = 0; i < cpkCols.length; ++i) {
            Object constant = cpks[i] == null ? NULL : cpks[i];
            this._cols.add(MappingInfo.syncColumn(context, cpkCols[i], size, false, target, local, constant, this._join != 2));
        }
    }

    protected static Column syncColumn(MetaDataContext context, Column col, int num, boolean forceJDBCType, Table colTable, Table targetTable, Object target, boolean inverse) {
        String typeName;
        DBDictionary dict = ((MappingRepository)context.getRepository()).getDBDictionary();
        Column copy = new Column();
        if (col.getTable() != colTable || inverse) {
            copy.setIdentifier(QualifiedDBIdentifier.newPath(dict.getFullIdentifier(col.getTable(), true), col.getIdentifier()));
        } else {
            copy.setIdentifier(col.getIdentifier());
        }
        if (target != null) {
            if (target == NULL) {
                copy.setTargetIdentifier(DBIdentifier.newColumn("null"));
            } else if (target instanceof Column) {
                Column tcol = (Column)target;
                if (!inverse && tcol.getTable() != targetTable || inverse && tcol.getTable() != colTable) {
                    copy.setTargetIdentifier(QualifiedDBIdentifier.newPath(dict.getFullIdentifier(tcol.getTable(), true), tcol.getIdentifier()));
                } else if (!MappingInfo.defaultTarget(col, tcol, num)) {
                    copy.setTargetIdentifier(tcol.getIdentifier());
                }
            } else if (target instanceof Number) {
                copy.setTargetIdentifier(DBIdentifier.newConstant(target.toString()));
            } else {
                copy.setTargetIdentifier(DBIdentifier.newConstant("'" + target + "'"));
            }
        } else if (num > 1) {
            copy.setTargetField(col.getTargetField());
        }
        if (!(col.getSize() == 0 || col.getSize() == dict.characterColumnSize || col.getSize() == -1 && col.isLob())) {
            copy.setSize(col.getSize());
        }
        if (col.getDecimalDigits() != 0) {
            copy.setDecimalDigits(col.getDecimalDigits());
        }
        if (col.getDefaultString() != null) {
            copy.setDefaultString(col.getDefaultString());
        }
        if (col.isNotNull() && !col.isPrimaryKey() && (!MappingInfo.isPrimitive(col.getJavaType()) || MappingInfo.isForeignKey(col))) {
            copy.setNotNull(true);
        }
        if ((typeName = col.getTypeName()) != null || copy.getSize() != 0 || copy.getDecimalDigits() != 0) {
            boolean defSized;
            copy.setType(col.getType());
            String defName = dict.getTypeName(copy);
            copy.setType(1111);
            boolean bl = defSized = defName.indexOf(40) != -1;
            if (!defSized) {
                if (copy.getSize() > 0) {
                    copy.setSize(0);
                }
                copy.setDecimalDigits(0);
            }
            if (typeName != null) {
                if (typeName.indexOf(40) == -1 && defSized) {
                    defName = defName.substring(0, defName.indexOf(40));
                }
                if (!typeName.equalsIgnoreCase(defName)) {
                    copy.setTypeName(typeName);
                }
            }
        }
        if (forceJDBCType || target != null && !(target instanceof Column) && col.getType() != 12 || dict.getJDBCType(col.getJavaType(), false) != col.getType()) {
            copy.setType(col.getType());
        }
        return copy;
    }

    private static boolean isForeignKey(Column col) {
        if (col.getTable() == null) {
            return false;
        }
        ForeignKey[] fks = col.getTable().getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            if (!fks[i].containsColumn(col) && !fks[i].containsConstantColumn(col)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrimitive(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private static boolean defaultTarget(Column col, Column targetCol, int num) {
        if (col.getIdentifier().equals(targetCol.getIdentifier())) {
            return true;
        }
        if (num > 1) {
            return false;
        }
        PrimaryKey pk = targetCol.getTable().getPrimaryKey();
        if (pk == null || pk.getColumns().length != 1) {
            return false;
        }
        return targetCol == pk.getColumns()[0];
    }

    public static interface ForeignKeyDefaults {
        public ForeignKey get(Table var1, Table var2, boolean var3);

        public void populate(Table var1, Table var2, Column var3, Object var4, boolean var5, int var6, int var7);
    }

    public static interface TableDefaults {
        @Deprecated
        public String get(Schema var1);

        public DBIdentifier getIdentifier(Schema var1);
    }
}

