/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jest.AbstractCommand;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.ObjectFormatter;
import org.apache.openjpa.persistence.jest.ProcessingException;
import org.apache.openjpa.util.ApplicationIds;

class FindCommand
extends AbstractCommand {
    private static final String ARG_TYPE = "type";
    private static final List<String> _mandatoryArgs = Arrays.asList("type");
    private static final List<String> _validQualifiers = Arrays.asList("format", "plan");

    public FindCommand(JPAServletContext ctx) {
        super(ctx);
    }

    @Override
    protected Collection<String> getMandatoryArguments() {
        return _mandatoryArgs;
    }

    @Override
    protected int getMinimumArguments() {
        return 1;
    }

    @Override
    protected Collection<String> getValidQualifiers() {
        return _validQualifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws ProcessingException {
        block7: {
            JPAServletContext ctx = this.getExecutionContext();
            OpenJPAEntityManager em = ctx.getPersistenceContext();
            String type = this.getMandatoryArgument(ARG_TYPE);
            ClassMetaData meta = ctx.resolve(type);
            Map<String, String> parameters = this.getArguments();
            Object[] pks = new Object[parameters.size()];
            Iterator<Map.Entry<String, String>> params = parameters.entrySet().iterator();
            for (int i = 0; i < parameters.size(); ++i) {
                pks[i] = params.next().getKey();
            }
            Object oid = ApplicationIds.fromPKValues((Object[])pks, (ClassMetaData)meta);
            this.pushFetchPlan(em);
            try {
                Object pc = em.find(meta.getDescribedType(), oid);
                if (pc != null) {
                    OpenJPAStateManager sm = this.toStateManager(pc);
                    ObjectFormatter<?> formatter = this.getObjectFormatter();
                    ctx.getResponse().setContentType(formatter.getMimeType());
                    try {
                        formatter.writeOut(Collections.singleton(sm), em.getMetamodel(), _loc.get("find-title").toString(), _loc.get("find-desc").toString(), ctx.getRequestURI(), (OutputStream)ctx.getResponse().getOutputStream());
                        break block7;
                    }
                    catch (IOException e) {
                        throw new ProcessingException(ctx, (Throwable)e);
                    }
                }
                throw new ProcessingException(ctx, _loc.get("entity-not-found", (Object)type, (Object)Arrays.toString(pks)), 404);
            }
            finally {
                this.popFetchPlan(true);
            }
        }
    }
}

