/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.jest.DomainCommand;
import org.apache.openjpa.persistence.jest.FindCommand;
import org.apache.openjpa.persistence.jest.JESTCommand;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.ProcessingException;
import org.apache.openjpa.persistence.jest.PropertiesCommand;
import org.apache.openjpa.persistence.jest.PrototypeFactory;
import org.apache.openjpa.persistence.jest.QueryCommand;
import org.apache.openjpa.persistence.jest.TokenReplacedStream;

public class JESTContext
implements JPAServletContext {
    private final String _unit;
    private final OpenJPAEntityManagerFactory _emf;
    private OpenJPAEntityManager _em;
    private final HttpServletRequest _request;
    private final HttpServletResponse _response;
    protected MetaDataRepository _repos;
    private String _rootResource;
    protected Log _log;
    protected static PrototypeFactory<String, JESTCommand> _cf = new PrototypeFactory();
    public static final Localizer _loc = Localizer.forPackage(JESTContext.class);
    private static final String ONE_YEAR_FROM_NOW;
    public static final char QUERY_SEPARATOR = '?';
    public static final String CONTEXT_ROOT = "/";
    public static final String JEST_TEMPLATE = "jest.html";

    public JESTContext(String unit, OpenJPAEntityManagerFactory emf, HttpServletRequest request, HttpServletResponse response) {
        this._unit = unit;
        this._emf = emf;
        this._request = request;
        this._response = response;
        OpenJPAConfiguration conf = this._emf.getConfiguration();
        this._log = conf.getLog("JEST");
        this._repos = conf.getMetaDataRepositoryInstance();
    }

    @Override
    public String getPersistenceUnitName() {
        return this._unit;
    }

    @Override
    public OpenJPAEntityManager getPersistenceContext() {
        if (this._em == null) {
            this._em = this._emf.createEntityManager();
        }
        return this._em;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this._request;
    }

    @Override
    public String getRequestURI() {
        StringBuffer buf = this._request.getRequestURL();
        String query = this._request.getQueryString();
        if (!this.isEmpty(query)) {
            buf.append('?').append(query);
        }
        return buf.toString();
    }

    @Override
    public HttpServletResponse getResponse() {
        return this._response;
    }

    public void execute() throws Exception {
        String path = this._request.getPathInfo();
        if (this.isContextRoot(path)) {
            this.getRootResource();
            return;
        }
        String action = JESTContext.getAction(path);
        JESTCommand command = _cf.newInstance(action, this);
        if (command == null) {
            this.findResource(path.substring(1));
            return;
        }
        try {
            command.parse();
            command.process();
        }
        catch (ProcessingException e1) {
            throw e1;
        }
        catch (Exception e2) {
            try {
                this.findResource(path.substring(action.length() + 1));
            }
            catch (ProcessingException e3) {
                throw e2;
            }
        }
    }

    public static String getAction(String path) {
        int idx;
        if (path == null) {
            return CONTEXT_ROOT;
        }
        if (path.startsWith(CONTEXT_ROOT)) {
            path = path.substring(1);
        }
        return (idx = path.indexOf(CONTEXT_ROOT)) == -1 ? path : path.substring(0, idx);
    }

    @Override
    public ClassMetaData resolve(String alias) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this._repos.getMetaData(alias, loader, true);
    }

    void findResource(String rsrc) throws ProcessingException {
        this._response.setHeader("Cache-Control", "public");
        this._response.setHeader("Expires", ONE_YEAR_FROM_NOW);
        InputStream in = this.getClass().getResourceAsStream(rsrc);
        if (in == null) {
            if (rsrc.startsWith(CONTEXT_ROOT)) {
                in = this.getClass().getResourceAsStream(rsrc.substring(1));
            }
            if (in == null) {
                throw new ProcessingException((JPAServletContext)this, _loc.get("resource-not-found", (Object)rsrc), 404);
            }
        }
        try {
            String mimeType = this._request.getSession().getServletContext().getMimeType(rsrc);
            if (mimeType == null) {
                mimeType = "application/text";
            }
            this._response.setContentType(mimeType);
            ServletOutputStream out = this._response.getOutputStream();
            if (mimeType.startsWith("image/")) {
                byte[] b = new byte[1024];
                int i = 0;
                int l = 0;
                while ((l = in.read(b)) != -1) {
                    out.write(b, 0, l);
                    i += l;
                }
                this._response.setContentLength(i);
            } else {
                int c = 0;
                while ((c = in.read()) != -1) {
                    out.write((char)c);
                }
            }
        }
        catch (IOException e) {
            throw new ProcessingException(this, (Throwable)e, _loc.get("resource-not-found", (Object)rsrc), 404);
        }
    }

    @Override
    public void log(short level, String message) {
        switch (level) {
            case 3: {
                this._log.info((Object)message);
                break;
            }
            case 5: {
                this._log.fatal((Object)message);
                break;
            }
            case 6: {
                this._log.fatal((Object)message);
                break;
            }
            case 1: {
                this._log.trace((Object)message);
                break;
            }
            case 4: {
                this._log.warn((Object)message);
                break;
            }
            default: {
                this._request.getSession().getServletContext().log(message);
            }
        }
    }

    boolean isContextRoot(String path) {
        return path == null || CONTEXT_ROOT.equals(path);
    }

    boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private void getRootResource() throws IOException {
        this._response.setHeader("Cache-Control", "public");
        this._response.setHeader("Expires", ONE_YEAR_FROM_NOW);
        if (this._rootResource == null) {
            String[] tokens = new String[]{"${persistence.unit}", this.getPersistenceUnitName(), "${jest.uri}", this._request.getRequestURL().toString(), "${webapp.name}", this._request.getContextPath().startsWith(CONTEXT_ROOT) ? this._request.getContextPath().substring(1) : this._request.getContextPath(), "${servlet.name}", this._request.getServletPath().startsWith(CONTEXT_ROOT) ? this._request.getServletPath().substring(1) : this._request.getServletPath(), "${server.name}", this._request.getServerName(), "${server.port}", "" + this._request.getServerPort(), "${dojo.base}", "http://ajax.googleapis.com/ajax/libs/dojo/1.5", "${dojo.theme}", "claro"};
            InputStream in = this.getClass().getResourceAsStream(JEST_TEMPLATE);
            CharArrayWriter out = new CharArrayWriter();
            new TokenReplacedStream().replace(in, out, tokens);
            this._rootResource = out.toString();
        }
        this._response.getOutputStream().write(this._rootResource.getBytes());
    }

    static {
        _cf.register("find", FindCommand.class);
        _cf.register("query", QueryCommand.class);
        _cf.register("domain", DomainCommand.class);
        _cf.register("properties", PropertiesCommand.class);
        Calendar now = Calendar.getInstance();
        now.add(1, 1);
        ONE_YEAR_FROM_NOW = new Date(now.getTimeInMillis()).toString();
    }
}

