/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.jest.ExceptionFormatter;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.w3c.dom.Document;

public class ProcessingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final JPAServletContext ctx;
    private final int _errorCode;

    public ProcessingException(JPAServletContext ctx, Throwable error) {
        this(ctx, error, 500);
    }

    public ProcessingException(JPAServletContext ctx, Throwable error, int errorCode) {
        super(error);
        this.ctx = ctx;
        this._errorCode = errorCode;
    }

    public ProcessingException(JPAServletContext ctx, Localizer.Message message, int errorCode) {
        super(message.toString());
        this.ctx = ctx;
        this._errorCode = errorCode;
    }

    public ProcessingException(JPAServletContext ctx, Throwable error, Localizer.Message message) {
        this(ctx, error, message, 500);
    }

    public ProcessingException(JPAServletContext ctx, Throwable error, Localizer.Message message, int errorCode) {
        super(message.toString(), error);
        this.ctx = ctx;
        this._errorCode = errorCode;
    }

    @Override
    public void printStackTrace() {
        HttpServletResponse response = this.ctx.getResponse();
        response.setContentType("text/xml");
        response.setStatus(this._errorCode);
        String uri = this.ctx.getRequestURI().toString();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable t = this.getCause() == null ? this : this.getCause();
        ExceptionFormatter formatter = new ExceptionFormatter();
        Document xml = formatter.createXML("Request URI: " + uri, t);
        try {
            formatter.write(xml, (OutputStream)response.getOutputStream());
            response.sendError(this._errorCode);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Request URI: " + uri, e);
        }
    }
}

