/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jest.AbstractCommand;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.ProcessingException;

class QueryCommand
extends AbstractCommand {
    private static final String ARG_QUERY = "q";
    public static final String QUALIFIER_MAXRESULT = "max";
    public static final String QUALIFIER_FIRSTRESULT = "first";
    public static final String QUALIFIER_NAMED = "named";
    public static final String QUALIFIER_SINGLE = "single";
    private static final List<String> _mandatoryArgs = Arrays.asList("q");
    private static final List<String> _validQualifiers = Arrays.asList("format", "plan", "named", "single", "first", "max");

    public QueryCommand(JPAServletContext ctx) {
        super(ctx);
    }

    @Override
    protected Collection<String> getMandatoryArguments() {
        return _mandatoryArgs;
    }

    @Override
    protected int getMinimumArguments() {
        return 0;
    }

    @Override
    protected Collection<String> getValidQualifiers() {
        return _validQualifiers;
    }

    @Override
    public void process() throws ProcessingException {
        JPAServletContext ctx = this.getExecutionContext();
        String spec = this.getMandatoryArgument(ARG_QUERY);
        OpenJPAEntityManager em = ctx.getPersistenceContext();
        try {
            OpenJPAQuery query;
            OpenJPAQuery openJPAQuery = query = this.isBooleanQualifier(QUALIFIER_NAMED) ? em.createNamedQuery(spec) : em.createQuery(spec);
            if (this.hasQualifier(QUALIFIER_FIRSTRESULT)) {
                query.setFirstResult(Integer.parseInt(this.getQualifier(QUALIFIER_FIRSTRESULT)));
            }
            if (this.hasQualifier(QUALIFIER_MAXRESULT)) {
                query.setMaxResults(Integer.parseInt(this.getQualifier(QUALIFIER_MAXRESULT)));
            }
            this.pushFetchPlan(query);
            Map<String, String> args = this.getArguments();
            for (Map.Entry<String, String> entry : args.entrySet()) {
                query.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            this.getObjectFormatter().writeOut(this.toStateManager(this.isBooleanQualifier(QUALIFIER_SINGLE) ? Collections.singleton(query.getSingleResult()) : query.getResultList()), em.getMetamodel(), _loc.get("query-title").toString(), _loc.get("query-desc").toString(), ctx.getRequestURI(), (OutputStream)ctx.getResponse().getOutputStream());
        }
        catch (ArgumentException e1) {
            throw new ProcessingException(ctx, (Throwable)e1, _loc.get("query-execution-error", (Object)spec), 400);
        }
        catch (Exception e) {
            throw new ProcessingException(ctx, (Throwable)e, _loc.get("query-execution-error", (Object)spec));
        }
        finally {
            this.popFetchPlan(false);
        }
    }
}

