/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;

public class TokenReplacedStream {
    public void replace(InputStream in, Writer out, String ... prs) throws IOException {
        BufferedReader inRdr = new BufferedReader(new InputStreamReader(in));
        this.replace(inRdr, out, prs);
    }

    public void replace(Reader in, Writer out, String ... prs) throws IOException {
        if (prs.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of pattern/string pairs: " + Arrays.toString(prs) + ". Must be even number of arguments.");
        }
        Pattern[] patterns = new Pattern[prs.length / 2];
        for (int i = 0; i < prs.length; i += 2) {
            patterns[i / 2] = new Pattern(prs[i], prs[i + 1]);
        }
        StringBuilder tmp = new StringBuilder();
        int c = 0;
        while ((c = in.read()) != -1) {
            int cursor = this.match((char)c, patterns);
            if (cursor < 0) {
                if (tmp.length() > 0) {
                    for (int j = 0; j < tmp.length(); ++j) {
                        out.write(tmp.charAt(j));
                    }
                    tmp.delete(0, tmp.length());
                }
                out.write((char)c);
                continue;
            }
            Pattern p = this.matched(patterns);
            if (p != null) {
                char[] replace;
                for (char value : replace = p.replace().toCharArray()) {
                    out.write(value);
                }
                this.reset(patterns);
                tmp.delete(0, tmp.length());
                continue;
            }
            tmp.append((char)c);
        }
    }

    int match(char c, Pattern ... patterns) {
        if (patterns == null) {
            return -1;
        }
        int result = -1;
        for (Pattern p : patterns) {
            result = Math.max(result, p.match(c));
        }
        return result;
    }

    Pattern matched(Pattern ... patterns) {
        if (patterns == null) {
            return null;
        }
        for (Pattern p : patterns) {
            if (!p.isMatched()) continue;
            return p;
        }
        return null;
    }

    void reset(Pattern ... patterns) {
        if (patterns == null) {
            return;
        }
        for (Pattern p : patterns) {
            p.reset();
        }
    }

    public static class Pattern {
        private final char[] chars;
        private final String _replace;
        private int _cursor;

        public Pattern(String s, String replace) {
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("Pattern [" + s + "] can not be empty or null ");
            }
            if (replace == null) {
                throw new IllegalArgumentException("Replacement [" + replace + "] is null for pattern [" + s + "]");
            }
            this.chars = s.toCharArray();
            this._cursor = -1;
            this._replace = replace;
        }

        public int match(char c) {
            if (c != this.chars[++this._cursor]) {
                this.reset();
            }
            return this._cursor;
        }

        public void reset() {
            this._cursor = -1;
        }

        public boolean isMatched() {
            return this._cursor == this.chars.length - 1;
        }

        public String replace() {
            return this._replace;
        }

        public String toString() {
            return new String(this.chars) + ":" + this._cursor;
        }
    }
}

