/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.ClassRedefiner;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.BytecodeWriter;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.GeneratedClasses;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;
import serp.bytecode.BCClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedClassSubclasser {
    private static final Localizer _loc = Localizer.forPackage(ManagedClassSubclasser.class);

    public static List<Class> prepareUnenhancedClasses(OpenJPAConfiguration conf, Collection<? extends Class> classes, ClassLoader envLoader) {
        if (classes == null) {
            return null;
        }
        if (classes.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Log log = conf.getLog("openjpa.Enhance");
        if (conf.getRuntimeUnenhancedClassesConstant() != 0) {
            ArrayList<Class> unenhanced = new ArrayList<Class>();
            for (Class clazz : classes) {
                if (PersistenceCapable.class.isAssignableFrom(clazz)) continue;
                unenhanced.add(clazz);
            }
            if (unenhanced.size() > 0) {
                Localizer.Message msg = _loc.get("runtime-optimization-disabled", unenhanced);
                if (conf.getRuntimeUnenhancedClassesConstant() == 2) {
                    log.warn((Object)msg);
                } else {
                    throw new UserException(msg);
                }
            }
            return null;
        }
        boolean redefine = ClassRedefiner.canRedefineClasses();
        if (redefine) {
            log.info((Object)_loc.get("enhance-and-subclass-and-redef-start", classes));
        } else {
            log.info((Object)_loc.get("enhance-and-subclass-no-redef-start", classes));
        }
        final HashMap<Class, byte[]> map = new HashMap<Class, byte[]>();
        final ArrayList<Class> arrayList = new ArrayList<Class>(classes.size());
        final ArrayList ints = new ArrayList(classes.size());
        Set<Class> unspecified = null;
        for (final Class clazz : classes) {
            final PCEnhancer enhancer = new PCEnhancer(conf, clazz);
            enhancer.setBytecodeWriter(new BytecodeWriter(){

                public void write(BCClass bc) throws IOException {
                    ManagedClassSubclasser.write(bc, enhancer, map, clazz, arrayList, ints);
                }
            });
            if (redefine) {
                enhancer.setRedefine(true);
            }
            enhancer.setCreateSubclass(true);
            enhancer.setAddDefaultConstructor(true);
            ManagedClassSubclasser.configureMetaData(enhancer.getMetaData(), conf, redefine, false);
            unspecified = ManagedClassSubclasser.collectRelatedUnspecifiedTypes(enhancer.getMetaData(), classes, unspecified);
            int runResult = enhancer.run();
            if (runResult != 8) continue;
            try {
                enhancer.record();
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        if (unspecified != null && !unspecified.isEmpty()) {
            throw new UserException(_loc.get("unspecified-unenhanced-types", classes, (Object)unspecified));
        }
        ClassRedefiner.redefineClasses(conf, map);
        for (Class clazz : map.keySet()) {
            ManagedClassSubclasser.setIntercepting(conf, envLoader, clazz);
            ManagedClassSubclasser.configureMetaData(conf, envLoader, clazz, redefine);
        }
        for (Class clazz : arrayList) {
            ManagedClassSubclasser.configureMetaData(conf, envLoader, clazz, redefine);
        }
        for (Class clazz : ints) {
            ManagedClassSubclasser.setIntercepting(conf, envLoader, clazz);
        }
        return arrayList;
    }

    private static Set<Class> collectRelatedUnspecifiedTypes(ClassMetaData meta, Collection<? extends Class> classes, Set<Class> unspecified) {
        unspecified = ManagedClassSubclasser.collectUnspecifiedType(meta.getPCSuperclass(), classes, unspecified);
        for (FieldMetaData fmd : meta.getFields()) {
            if (fmd.isTransient()) continue;
            if (fmd.isTypePC()) {
                unspecified = ManagedClassSubclasser.collectUnspecifiedType(fmd.getType(), classes, unspecified);
            }
            if (fmd.getElement() != null && fmd.getElement().isTypePC()) {
                unspecified = ManagedClassSubclasser.collectUnspecifiedType(fmd.getElement().getType(), classes, unspecified);
            }
            if (fmd.getKey() != null && fmd.getKey().isTypePC()) {
                unspecified = ManagedClassSubclasser.collectUnspecifiedType(fmd.getKey().getType(), classes, unspecified);
            }
            if (fmd.getValue() == null || !fmd.getValue().isTypePC()) continue;
            unspecified = ManagedClassSubclasser.collectUnspecifiedType(fmd.getValue().getType(), classes, unspecified);
        }
        return unspecified;
    }

    private static Set<Class> collectUnspecifiedType(Class cls, Collection<? extends Class> classes, Set<Class> unspecified) {
        if (cls != null && !classes.contains(cls) && !ImplHelper.isManagedType(null, (Class)cls)) {
            if (unspecified == null) {
                unspecified = new HashSet<Class>();
            }
            unspecified.add(cls);
        }
        return unspecified;
    }

    private static void configureMetaData(OpenJPAConfiguration conf, ClassLoader envLoader, Class cls, boolean redefineAvailable) {
        ClassMetaData meta = conf.getMetaDataRepositoryInstance().getMetaData(cls, envLoader, true);
        ManagedClassSubclasser.configureMetaData(meta, conf, redefineAvailable, true);
    }

    private static void configureMetaData(ClassMetaData meta, OpenJPAConfiguration conf, boolean redefineAvailable, boolean warn) {
        ManagedClassSubclasser.setDetachedState(meta);
        if (warn && meta.getAccessType() == 2 && !redefineAvailable) {
            block3: for (FieldMetaData fmd : meta.getDeclaredFields()) {
                switch (fmd.getTypeCode()) {
                    case 12: 
                    case 13: {
                        continue block3;
                    }
                    default: {
                        if (fmd.isInDefaultFetchGroup() || fmd.isVersion() || fmd.isPrimaryKey()) continue block3;
                        Log log = conf.getLog("openjpa.Enhance");
                        log.warn((Object)_loc.get("subclasser-fetch-group-override", (Object)meta.getDescribedType().getName(), (Object)fmd.getName()));
                        fmd.setInDefaultFetchGroup(true);
                    }
                }
            }
        }
    }

    private static void write(BCClass bc, PCEnhancer enhancer, Map<Class, byte[]> map, Class cls, List subs, List ints) throws IOException {
        if (bc == enhancer.getManagedTypeBytecode()) {
            if (enhancer.isAlreadyRedefined()) {
                ints.add(bc.getType());
            } else if (JavaVersions.VERSION >= 5) {
                map.put(bc.getType(), bc.toByteArray());
            }
        } else if (!enhancer.isAlreadySubclassed()) {
            ClassLoader loader = GeneratedClasses.getMostDerivedLoader((Class)cls, PersistenceCapable.class);
            subs.add(GeneratedClasses.loadBCClass((BCClass)bc, (ClassLoader)loader));
        }
    }

    private static void setIntercepting(OpenJPAConfiguration conf, ClassLoader envLoader, Class cls) {
        ClassMetaData meta = conf.getMetaDataRepositoryInstance().getMetaData(cls, envLoader, true);
        meta.setIntercepting(true);
    }

    private static void setDetachedState(ClassMetaData meta) {
        if ("`syn".equals(meta.getDetachedState())) {
            meta.setDetachedState(null);
        }
    }
}

