/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import [Ljava.lang.Object;;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.ObjectValue;

public class PluginListValue
extends ObjectValue {
    private static final String[] EMPTY = new String[0];
    private String[] _names = EMPTY;
    private String[] _props = EMPTY;

    public PluginListValue(String prop) {
        super(prop);
    }

    public String[] getClassNames() {
        return this._names;
    }

    public void setClassNames(String[] names) {
        if (names == null) {
            names = EMPTY;
        }
        this._names = names;
        this.set(null, true);
        this.valueChanged();
    }

    public String[] getProperties() {
        return this._props;
    }

    public void setProperties(String[] props) {
        if (props == null) {
            props = EMPTY;
        }
        this._props = props;
        this.set(null, true);
        this.valueChanged();
    }

    public Object instantiate(Class elemType, Configuration conf, boolean fatal) {
        Object[] ret;
        if (this._names.length == 0) {
            ret = (Object[])Array.newInstance(elemType, 0);
        } else {
            ret = (Object[])Array.newInstance(elemType, this._names.length);
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.newInstance(this._names[i], elemType, conf, fatal);
                Configurations.configureInstance(ret[i], conf, this._props[i], this.getProperty());
            }
        }
        this.set(ret, true);
        return ret;
    }

    public String getString() {
        if (this._names.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._names.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Configurations.getPlugin(this.alias(this._names[i]), this._props[i]));
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public void setString(String str) {
        if (StringUtils.isEmpty((String)str)) {
            str = this.getDefault();
        }
        if (StringUtils.isEmpty((String)str)) {
            this._names = EMPTY;
            this._props = EMPTY;
            this.set(null, true);
            this.valueChanged();
            return;
        }
        ArrayList<String> plugins = new ArrayList<String>();
        StringBuffer plugin = new StringBuffer();
        boolean inParen = false;
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '(': {
                    inParen = true;
                    plugin.append(c);
                    continue block5;
                }
                case ')': {
                    inParen = false;
                    plugin.append(c);
                    continue block5;
                }
                case ',': {
                    if (inParen) {
                        plugin.append(c);
                        continue block5;
                    }
                    plugins.add(plugin.toString());
                    plugin = new StringBuffer();
                    continue block5;
                }
                default: {
                    plugin.append(c);
                }
            }
        }
        if (plugin.length() > 0) {
            plugins.add(plugin.toString());
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> props = new ArrayList<String>();
        for (int i = 0; i < plugins.size(); ++i) {
            str = (String)plugins.get(i);
            String clsName = this.unalias(Configurations.getClassName(str));
            if (clsName == null) continue;
            names.add(clsName);
            props.add(Configurations.getProperties(str));
        }
        this._names = names.toArray(new String[names.size()]);
        this._props = props.toArray(new String[props.size()]);
        this.set(null, true);
        this.valueChanged();
    }

    public Class getValueType() {
        return Object;.class;
    }

    protected void objectChanged() {
        Object[] vals = (Object[])this.get();
        if (vals == null || vals.length == 0) {
            this._names = EMPTY;
        } else {
            this._names = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                this._names[i] = vals[i] == null ? null : vals[i].getClass().getName();
            }
        }
        this._props = EMPTY;
    }

    protected String getInternalString() {
        throw new IllegalStateException();
    }

    protected void setInternalString(String str) {
        throw new IllegalStateException();
    }
}

