/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.openjpa.lib.jdbc.DelegatingResultSet;
import org.apache.openjpa.lib.util.Closeable;

public class DelegatingPreparedStatement
implements PreparedStatement,
Closeable {
    private final PreparedStatement _stmnt;
    private final DelegatingPreparedStatement _del;
    private final Connection _conn;

    public DelegatingPreparedStatement(PreparedStatement stmnt, Connection conn) {
        this._conn = conn;
        this._stmnt = stmnt;
        this._del = this._stmnt instanceof DelegatingPreparedStatement ? (DelegatingPreparedStatement)this._stmnt : null;
    }

    protected ResultSet wrapResult(ResultSet rs, boolean wrap) {
        if (!wrap || rs == null) {
            return rs;
        }
        return new DelegatingResultSet(rs, this);
    }

    public PreparedStatement getDelegate() {
        return this._stmnt;
    }

    public PreparedStatement getInnermostDelegate() {
        return this._del == null ? this._stmnt : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingPreparedStatement) {
            other = ((DelegatingPreparedStatement)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("prepstmnt ").append(this.hashCode());
        this.appendInfo(buf);
        return buf.toString();
    }

    protected void appendInfo(StringBuffer buf) {
        if (this._del != null) {
            this._del.appendInfo(buf);
        }
    }

    @Override
    public ResultSet executeQuery(String str) throws SQLException {
        return this.executeQuery(str, true);
    }

    protected ResultSet executeQuery(String sql, boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.executeQuery(sql, false) : this._stmnt.executeQuery(sql);
        return this.wrapResult(rs, wrap);
    }

    @Override
    public int executeUpdate(String str) throws SQLException {
        return this._stmnt.executeUpdate(str);
    }

    @Override
    public boolean execute(String str) throws SQLException {
        return this._stmnt.execute(str);
    }

    @Override
    public void close() throws SQLException {
        this._stmnt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._stmnt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this._stmnt.setMaxFieldSize(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._stmnt.getMaxRows();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this._stmnt.setMaxRows(i);
    }

    @Override
    public void setEscapeProcessing(boolean bool) throws SQLException {
        this._stmnt.setEscapeProcessing(bool);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._stmnt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this._stmnt.setQueryTimeout(i);
    }

    @Override
    public void cancel() throws SQLException {
        this._stmnt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._stmnt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._stmnt.clearWarnings();
    }

    @Override
    public void setCursorName(String str) throws SQLException {
        this._stmnt.setCursorName(str);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(true);
    }

    protected ResultSet getResultSet(boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.getResultSet(false) : this._stmnt.getResultSet();
        return this.wrapResult(rs, wrap);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._stmnt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this._stmnt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this._stmnt.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._stmnt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this._stmnt.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._stmnt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._stmnt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._stmnt.getResultSetType();
    }

    @Override
    public void addBatch(String str) throws SQLException {
        this._stmnt.addBatch(str);
    }

    @Override
    public void clearBatch() throws SQLException {
        this._stmnt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this._stmnt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(true);
    }

    protected ResultSet executeQuery(boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.executeQuery(false) : this._stmnt.executeQuery();
        return this.wrapResult(rs, wrap);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this._stmnt.executeUpdate();
    }

    @Override
    public void setNull(int i1, int i2) throws SQLException {
        this._stmnt.setNull(i1, i2);
    }

    @Override
    public void setBoolean(int i, boolean b) throws SQLException {
        this._stmnt.setBoolean(i, b);
    }

    @Override
    public void setByte(int i, byte b) throws SQLException {
        this._stmnt.setByte(i, b);
    }

    @Override
    public void setShort(int i, short s) throws SQLException {
        this._stmnt.setShort(i, s);
    }

    @Override
    public void setInt(int i1, int i2) throws SQLException {
        this._stmnt.setInt(i1, i2);
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        this._stmnt.setLong(i, l);
    }

    @Override
    public void setFloat(int i, float f) throws SQLException {
        this._stmnt.setFloat(i, f);
    }

    @Override
    public void setDouble(int i, double d) throws SQLException {
        this._stmnt.setDouble(i, d);
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bd) throws SQLException {
        this._stmnt.setBigDecimal(i, bd);
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        this._stmnt.setString(i, s);
    }

    @Override
    public void setBytes(int i, byte[] b) throws SQLException {
        this._stmnt.setBytes(i, b);
    }

    @Override
    public void setDate(int i, Date d) throws SQLException {
        this._stmnt.setDate(i, d);
    }

    @Override
    public void setTime(int i, Time t) throws SQLException {
        this._stmnt.setTime(i, t);
    }

    @Override
    public void setTimestamp(int i, Timestamp t) throws SQLException {
        this._stmnt.setTimestamp(i, t);
    }

    @Override
    public void setAsciiStream(int i1, InputStream is, int i2) throws SQLException {
        this._stmnt.setAsciiStream(i1, is, i2);
    }

    @Override
    public void setUnicodeStream(int i1, InputStream is, int i2) throws SQLException {
        this._stmnt.setUnicodeStream(i1, is, i2);
    }

    @Override
    public void setBinaryStream(int i1, InputStream is, int i2) throws SQLException {
        this._stmnt.setBinaryStream(i1, is, i2);
    }

    @Override
    public void clearParameters() throws SQLException {
        this._stmnt.clearParameters();
    }

    @Override
    public void setObject(int i1, Object o, int i2, int i3) throws SQLException {
        this._stmnt.setObject(i1, o, i2, i3);
    }

    @Override
    public void setObject(int i1, Object o, int i2) throws SQLException {
        this._stmnt.setObject(i1, o, i2);
    }

    @Override
    public void setObject(int i, Object o) throws SQLException {
        this._stmnt.setObject(i, o);
    }

    @Override
    public boolean execute() throws SQLException {
        return this._stmnt.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this._stmnt.addBatch();
    }

    @Override
    public void setCharacterStream(int i1, Reader r, int i2) throws SQLException {
        this._stmnt.setCharacterStream(i1, r, i2);
    }

    @Override
    public void setRef(int i, Ref r) throws SQLException {
        this._stmnt.setRef(i, r);
    }

    @Override
    public void setBlob(int i, Blob b) throws SQLException {
        this._stmnt.setBlob(i, b);
    }

    @Override
    public void setClob(int i, Clob c) throws SQLException {
        this._stmnt.setClob(i, c);
    }

    @Override
    public void setArray(int i, Array a) throws SQLException {
        this._stmnt.setArray(i, a);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._stmnt.getMetaData();
    }

    @Override
    public void setDate(int i, Date d, Calendar c) throws SQLException {
        this._stmnt.setDate(i, d, c);
    }

    @Override
    public void setTime(int i, Time t, Calendar c) throws SQLException {
        this._stmnt.setTime(i, t, c);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar c) throws SQLException {
        this._stmnt.setTimestamp(i, t, c);
    }

    @Override
    public void setNull(int i1, int i2, String s) throws SQLException {
        this._stmnt.setNull(i1, i2, s);
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this._stmnt.getMoreResults(i);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmnt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        return this._stmnt.executeUpdate(s, i);
    }

    @Override
    public int executeUpdate(String s, int[] ia) throws SQLException {
        return this._stmnt.executeUpdate(s, ia);
    }

    @Override
    public int executeUpdate(String s, String[] sa) throws SQLException {
        return this._stmnt.executeUpdate(s, sa);
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        return this._stmnt.execute(s, i);
    }

    @Override
    public boolean execute(String s, int[] ia) throws SQLException {
        return this._stmnt.execute(s, ia);
    }

    @Override
    public boolean execute(String s, String[] sa) throws SQLException {
        return this._stmnt.execute(s, sa);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._stmnt.getResultSetHoldability();
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        this._stmnt.setURL(i, url);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this._stmnt.getParameterMetaData();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getDelegate().getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.getDelegate();
        }
        return null;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._stmnt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this._stmnt.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._stmnt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this._stmnt.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this._stmnt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this._stmnt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this._stmnt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this._stmnt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this._stmnt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this._stmnt.setClob(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this._stmnt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this._stmnt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this._stmnt.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this._stmnt.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this._stmnt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this._stmnt.setNString(parameterIndex, value);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this._stmnt.setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this._stmnt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._stmnt.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._stmnt.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this._stmnt.setPoolable(poolable);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

