/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.audit;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.openjpa.audit.Auditable;
import org.apache.openjpa.audit.AuditableOperation;
import org.apache.openjpa.audit.AuditedEntry;
import org.apache.openjpa.audit.Auditor;
import org.apache.openjpa.audit.X;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class TestAudit
extends TestCase {
    private static OpenJPAEntityManagerFactory emf;
    private static Auditor auditor;
    private static Object oid;
    EntityManager em;

    public void setUp() {
        if (emf == null) {
            emf = OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"audit"));
            TestAudit.assertNotNull((Object)emf);
            auditor = emf.getConfiguration().getAuditorInstance();
            this.em = emf.createEntityManager();
            this.clearAuditedEntries();
            oid = this.createManagedObject();
        } else {
            this.em = emf.createEntityManager();
        }
    }

    private Object createManagedObject() {
        this.em.getTransaction().begin();
        X x = new X();
        x.setName("New Object");
        x.setPrice(100);
        this.em.persist((Object)x);
        this.em.getTransaction().commit();
        return emf.getPersistenceUnitUtil().getIdentifier((Object)x);
    }

    private void clearAuditedEntries() {
        this.em.getTransaction().begin();
        this.em.createQuery("delete from AuditedEntry a").executeUpdate();
        this.em.getTransaction().commit();
    }

    public void testAuditorIsConfigured() {
        TestAudit.assertNotNull((Object)auditor);
    }

    public void testIsEntityAuditable() {
        TestAudit.assertNotNull((Object)X.class.getAnnotation(Auditable.class));
    }

    public void testNewInstancesAreAudited() {
        X x = (X)this.em.find(X.class, oid);
        TestAudit.assertNotNull((Object)x);
        AuditedEntry entry = this.findLastAuditedEntry(AuditableOperation.CREATE);
        TestAudit.assertNotNull((Object)entry);
        TestAudit.assertEquals((Object)x, (Object)entry.getAudited());
        TestAudit.assertEquals((Object)AuditableOperation.CREATE, (Object)entry.getOperation());
        TestAudit.assertEquals(X.class, entry.getAudited().getClass());
        TestAudit.assertTrue((boolean)entry.getUpdatedFields().isEmpty());
    }

    public void testUpdateOutsideTransactionAreAudited() {
        X x = (X)this.em.find(X.class, oid);
        TestAudit.assertNotNull((Object)x);
        x.setName("Updated Object outside transaction");
        this.em.getTransaction().begin();
        x = (X)this.em.merge((Object)x);
        this.em.getTransaction().commit();
        AuditedEntry entry = this.findLastAuditedEntry(AuditableOperation.UPDATE);
        TestAudit.assertNotNull((Object)entry);
        TestAudit.assertEquals((Object)x, (Object)entry.getAudited());
        TestAudit.assertEquals((Object)AuditableOperation.UPDATE, (Object)entry.getOperation());
        TestAudit.assertTrue((boolean)entry.getUpdatedFields().contains("name"));
        TestAudit.assertFalse((boolean)entry.getUpdatedFields().contains("price"));
    }

    public void testUpdateInsideTransactionAreAudited() {
        X x = (X)this.em.find(X.class, oid);
        TestAudit.assertNotNull((Object)x);
        this.em.getTransaction().begin();
        x.setPrice(x.getPrice() + 100);
        x = (X)this.em.merge((Object)x);
        this.em.getTransaction().commit();
        AuditedEntry entry = this.findLastAuditedEntry(AuditableOperation.UPDATE);
        TestAudit.assertNotNull((Object)entry);
        TestAudit.assertEquals((Object)x, (Object)entry.getAudited());
        TestAudit.assertEquals((Object)AuditableOperation.UPDATE, (Object)entry.getOperation());
        TestAudit.assertFalse((boolean)entry.getUpdatedFields().contains("name"));
        TestAudit.assertTrue((boolean)entry.getUpdatedFields().contains("price"));
    }

    public void testAuditDoesNotLeakMemory() {
        int N = 1000;
        OpenJPAEntityManager em = emf.createEntityManager();
        long m2 = this.insert(N, (EntityManager)em);
        em = Persistence.createEntityManagerFactory((String)"no-audit").createEntityManager();
        TestAudit.assertNull((Object)OpenJPAPersistence.cast((EntityManager)em).getEntityManagerFactory().getConfiguration().getAuditorInstance());
        long m0 = this.insert(N, (EntityManager)em);
        System.err.println("Memory used with no auditor " + m0);
        System.err.println("Memory used with auditor " + m2);
        double pct = 100.0 * (double)(m2 - m0) / (double)m0;
        System.err.println("Extra memory with auditor " + pct);
        TestAudit.assertTrue((pct < 10.0 ? 1 : 0) != 0);
    }

    private long insert(int N, EntityManager em) {
        TestAudit.assertTrue((boolean)this.ensureGarbageCollection());
        long m1 = Runtime.getRuntime().freeMemory();
        em.getTransaction().begin();
        for (int i = 0; i < N; ++i) {
            X x = new X();
            x.setName("X" + System.currentTimeMillis());
            em.persist((Object)x);
        }
        em.getTransaction().commit();
        TestAudit.assertTrue((boolean)this.ensureGarbageCollection());
        long m2 = Runtime.getRuntime().freeMemory();
        long mused = m1 - m2;
        return mused;
    }

    AuditedEntry findLastAuditedEntry(AuditableOperation op) {
        List entry = this.em.createQuery("select a from AuditedEntry a where a.operation=:op order by a.id desc", AuditedEntry.class).setMaxResults(1).setParameter("op", (Object)op).getResultList();
        return (AuditedEntry)entry.get(0);
    }

    public boolean ensureGarbageCollection() {
        ReferenceQueue detector = new ReferenceQueue();
        Object marker = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(marker, detector);
        marker = null;
        System.gc();
        try {
            return detector.remove() == ref;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

