/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.openjpa.conf.CacheMarshallerImpl;
import org.apache.openjpa.conf.CacheMarshallersValue;
import org.apache.openjpa.conf.MetaDataCacheMaintenance;
import org.apache.openjpa.conf.OpenJPAVersionAndConfigurationTypeValidationPolicy;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.NamedQueryEntity;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;

public class TestCacheMarshallerEndToEnd
extends AbstractCachedEMFTestCase {
    private static final Object[] STORE_PROPS = new Object[]{"openjpa.CacheMarshallers", "default(Id=" + MetaDataCacheMaintenance.class.getName() + ", OutputFile=target/" + MetaDataCacheMaintenance.class.getName() + ".ser" + ", ConsumeSerializationErrors=false" + ", ValidationPolicy=" + OpenJPAVersionAndConfigurationTypeValidationPolicy.class.getName() + ")", "openjpa.QueryCompilationCache", "java.util.concurrent.ConcurrentHashMap", AllFieldTypes.class, NamedQueryEntity.class, CLEAR_TABLES};
    private static final Object[] LOAD_PROPS = new Object[]{"openjpa.CacheMarshallers", "default(Id=" + MetaDataCacheMaintenance.class.getName() + ", InputURL=file:target/" + MetaDataCacheMaintenance.class.getName() + ".ser" + ", ConsumeSerializationErrors=false" + ", ValidationPolicy=" + OpenJPAVersionAndConfigurationTypeValidationPolicy.class.getName() + ")", "openjpa.QueryCompilationCache", "java.util.concurrent.ConcurrentHashMap", AllFieldTypes.class, NamedQueryEntity.class};

    public void testCacheMarshallerEndToEnd() throws IOException {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(STORE_PROPS);
        CacheMarshallerImpl cm = (CacheMarshallerImpl)CacheMarshallersValue.getMarshallerById((Configuration)emf.getConfiguration(), (String)MetaDataCacheMaintenance.class.getName());
        cm.getOutputFile().delete();
        MetaDataCacheMaintenance maint = new MetaDataCacheMaintenance(JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf), false);
        LogImpl log = new LogImpl();
        maint.setLog((Log)log);
        maint.store();
        this.assertContains(log.lines, "    " + AllFieldTypes.class.getName());
        this.assertContains(log.lines, "    " + NamedQueryEntity.class.getName());
        this.assertContains(log.lines, "    NamedQueryEntity.namedQuery");
        this.clear((EntityManagerFactory)emf);
        this.closeEMF((EntityManagerFactory)emf);
        emf = this.createEMF(LOAD_PROPS);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new NamedQueryEntity("foo"));
        em.flush();
        Query q = em.createNamedQuery("NamedQueryEntity.namedQuery");
        TestCacheMarshallerEndToEnd.assertEquals((int)1, (int)q.getResultList().size());
        em.getTransaction().rollback();
        em.close();
        this.clear((EntityManagerFactory)emf);
        this.closeEMF((EntityManagerFactory)emf);
    }

    private void assertContains(List<String> lines, String prefix) {
        for (String line : lines) {
            if (!line.startsWith(prefix)) continue;
            return;
        }
        TestCacheMarshallerEndToEnd.fail((String)("should contain a line starting with " + prefix + ": " + lines));
    }

    private class LogImpl
    implements Log {
        private List<String> lines = new ArrayList<String>();

        private LogImpl() {
        }

        public boolean isTraceEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            throw new UnsupportedOperationException();
        }

        public boolean isFatalEnabled() {
            throw new UnsupportedOperationException();
        }

        public void trace(Object o) {
            this.lines.add(o.toString());
        }

        public void trace(Object o, Throwable t) {
            throw new UnsupportedOperationException();
        }

        public void info(Object o) {
            this.lines.add(o.toString());
        }

        public void info(Object o, Throwable t) {
            throw new UnsupportedOperationException();
        }

        public void warn(Object o) {
            this.lines.add(o.toString());
        }

        public void warn(Object o, Throwable t) {
            this.lines.add(o.toString());
        }

        public void error(Object o) {
            throw new UnsupportedOperationException();
        }

        public void error(Object o, Throwable t) {
            throw new UnsupportedOperationException();
        }

        public void fatal(Object o) {
            throw new UnsupportedOperationException();
        }

        public void fatal(Object o, Throwable t) {
            throw new UnsupportedOperationException();
        }
    }
}

