/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.common.apps.PObject;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDynamicConfiguration
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(PObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigurationIsEqualByValueAndHashCode() {
        OpenJPAEntityManagerFactorySPI emf1 = this.createEMF("Creates new EntityManagerFactory");
        TestDynamicConfiguration.assertNotNull((Object)emf1);
        OpenJPAConfiguration conf1 = emf1.getConfiguration();
        OpenJPAEntityManagerFactorySPI emf2 = this.createEMF("Creates new EntityManagerFactory");
        TestDynamicConfiguration.assertNotNull((Object)emf2);
        OpenJPAConfiguration conf2 = emf2.getConfiguration();
        try {
            TestDynamicConfiguration.assertFalse((emf1 == emf2 ? 1 : 0) != 0);
            TestDynamicConfiguration.assertFalse((boolean)emf1.equals(emf2));
            TestDynamicConfiguration.assertFalse((conf1 == conf2 ? 1 : 0) != 0);
            TestDynamicConfiguration.assertEquals((Object)conf1, (Object)conf2);
            TestDynamicConfiguration.assertEquals((int)conf1.hashCode(), (int)conf2.hashCode());
            TestDynamicConfiguration.assertEquals((Object)conf1.toProperties(false), (Object)conf2.toProperties(false));
        }
        finally {
            this.clear((EntityManagerFactory)emf1);
            this.closeEMF((EntityManagerFactory)emf1);
            this.clear((EntityManagerFactory)emf2);
            this.closeEMF((EntityManagerFactory)emf2);
        }
    }

    public void testConfigurationIsReadOnlyAfterFirstConstruction() {
        OpenJPAConfiguration conf = this.emf.getConfiguration();
        TestDynamicConfiguration.assertFalse((boolean)conf.isReadOnly());
        this.emf.createEntityManager();
        TestDynamicConfiguration.assertTrue((boolean)conf.isReadOnly());
    }

    public void testNonDynamicValuesCanNotBeChanged() {
        this.emf.createEntityManager();
        OpenJPAConfiguration conf = this.emf.getConfiguration();
        String oldValue = conf.getConnectionURL();
        String newValue = "jdbc://mydb:8087/DBDoesNotExist";
        try {
            conf.setConnectionURL(newValue);
            TestDynamicConfiguration.fail((String)"Expected exception to modify configuration");
        }
        catch (Exception ex) {
            TestDynamicConfiguration.assertEquals((String)oldValue, (String)conf.getConnectionURL());
        }
    }

    public void testDynamicValuesCanBeChanged() {
        OpenJPAConfiguration conf = this.emf.getConfiguration();
        int oldValue = conf.getLockTimeout();
        int newValue = oldValue + 10;
        conf.setLockTimeout(newValue);
        TestDynamicConfiguration.assertEquals((int)newValue, (int)conf.getLockTimeout());
    }

    public void testDynamicValuesAreCorrectlySet() {
        OpenJPAConfiguration conf = this.emf.getConfiguration();
        Value lockTimeoutValue = conf.getValue("LockTimeout");
        TestDynamicConfiguration.assertNotNull((Object)lockTimeoutValue);
        TestDynamicConfiguration.assertTrue((boolean)lockTimeoutValue.isDynamic());
        Value connectionURLValue = conf.getValue("ConnectionURL");
        TestDynamicConfiguration.assertNotNull((Object)connectionURLValue);
        TestDynamicConfiguration.assertFalse((boolean)connectionURLValue.isDynamic());
    }

    public void testDynamicChangeDoesNotChangeHashCode() {
        OpenJPAConfiguration conf1 = this.emf.getConfiguration();
        int oldValue = conf1.getLockTimeout();
        int newValue = oldValue + 10;
        int oldHash = conf1.hashCode();
        conf1.setLockTimeout(newValue);
        int newHash = conf1.hashCode();
        TestDynamicConfiguration.assertEquals((int)oldHash, (int)newHash);
    }

    public void testClassMetaDataRecognizesDataCacheTimeoutValueChange() {
        OpenJPAConfiguration conf = this.emf.getConfiguration();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc = new PObject();
        em.persist((Object)pc);
        int oldValue = conf.getDataCacheTimeout();
        ClassMetaData meta = conf.getMetaDataRepositoryInstance().getCachedMetaData(PObject.class);
        TestDynamicConfiguration.assertNotNull((Object)meta);
        TestDynamicConfiguration.assertEquals((int)oldValue, (int)meta.getDataCacheTimeout());
        int newValue = oldValue + 10;
        conf.setDataCacheTimeout(newValue);
        TestDynamicConfiguration.assertEquals((int)newValue, (int)conf.getDataCacheTimeout());
        TestDynamicConfiguration.assertEquals((int)newValue, (int)meta.getDataCacheTimeout());
    }
}

