/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.IsolationLevel;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryHints
extends SingleEMFTestCase {
    EntityManager em;
    OpenJPAQuery<?> query;

    @Override
    public void setUp() {
        super.setUp(null);
        this.em = this.emf.createEntityManager();
        String sql = "select * from Person";
        this.query = OpenJPAPersistence.cast((Query)this.em.createNativeQuery(sql));
    }

    public void testSupportedHintsContainProductDerivationHints() {
        this.assertSupportedHint("openjpa.hint.OracleSelectHint", true);
        this.assertSupportedHint("openjpa.hint.MySQLSelectHint", true);
        this.assertSupportedHint("openjpa.hint.MariaDBSelectHint", true);
    }

    public void testSupportedHintsContainFetchPlanHints() {
        this.assertSupportedHint("openjpa.FetchPlan.LockTimeout", true);
    }

    public void testSupportedHintsIgnoresSomeFetchPlanBeanStyleProperty() {
        this.assertSupportedHint("openjpa.FetchPlan.QueryResultCache", false);
    }

    public void testSupportedHintsContainQueryProperty() {
        this.assertSupportedHint("openjpa.Subclasses", true);
    }

    public void testSupportedHintsContainKernelQueryHints() {
        this.assertSupportedHint("openjpa.hint.IgnorePreparedQuery", true);
    }

    public void testSupportedHintsContainJPAQueryHints() {
        this.assertSupportedHint("javax.persistence.query.timeout", true);
    }

    public void testUnrecognizedKeyIsIgnored() {
        String unrecognizedKey = "acme.org.hint.SomeThingUnknown";
        this.query.setHint(unrecognizedKey, (Object)"xyz");
        TestQueryHints.assertFalse((boolean)this.query.getHints().containsKey(unrecognizedKey));
        TestQueryHints.assertNull((Object)this.query.getFetchPlan().getDelegate().getHint(unrecognizedKey));
    }

    public void testRecognizedKeyIsNotRecordedButAvailable() {
        String recognizedKey = "openjpa.some.derivation.hint";
        this.query.setHint(recognizedKey, (Object)"abc");
        TestQueryHints.assertFalse((boolean)this.query.getHints().containsKey(recognizedKey));
        TestQueryHints.assertEquals((Object)"abc", (Object)this.query.getFetchPlan().getDelegate().getHint(recognizedKey));
    }

    public void testSupportedKeyIsRecordedAndAvailable() {
        String supportedKey = "openjpa.FetchPlan.FetchBatchSize";
        this.query.setHint(supportedKey, (Object)42);
        TestQueryHints.assertTrue((boolean)this.query.getHints().containsKey(supportedKey));
        TestQueryHints.assertEquals((int)42, (int)this.query.getFetchPlan().getFetchBatchSize());
    }

    public void testSupportedKeyWrongValue() {
        String supportedKey = "openjpa.FetchPlan.FetchBatchSize";
        short goodValue = 42;
        float badValue = 57.9f;
        this.query.setHint(supportedKey, (Object)goodValue);
        TestQueryHints.assertTrue((boolean)this.query.getHints().containsKey(supportedKey));
        TestQueryHints.assertEquals((int)goodValue, (int)this.query.getFetchPlan().getFetchBatchSize());
        try {
            this.query.setHint(supportedKey, (Object)Float.valueOf(badValue));
            TestQueryHints.fail((String)("Expected to fail to set " + supportedKey + " hint to " + badValue));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSupportedKeyIntegerValueConversion() {
        String supportedKey = "openjpa.hint.OptimizeResultCount";
        String goodValue = "57";
        int badValue = -3;
        this.query.setHint(supportedKey, (Object)goodValue);
        TestQueryHints.assertTrue((boolean)this.query.getHints().containsKey(supportedKey));
        TestQueryHints.assertEquals((Object)57, (Object)this.query.getFetchPlan().getDelegate().getHint(supportedKey));
        try {
            this.query.setHint(supportedKey, (Object)badValue);
            TestQueryHints.fail((String)("Expected to fail to set " + supportedKey + " hint to " + badValue));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSupportedKeyBooleanValueConversion() {
        String supportedKey = "openjpa.hint.IgnorePreparedQuery";
        String goodValue = "true";
        this.query.setHint(supportedKey, (Object)goodValue);
        TestQueryHints.assertTrue((boolean)this.query.getHints().containsKey(supportedKey));
        TestQueryHints.assertEquals((Object)true, (Object)this.query.getFetchPlan().getDelegate().getHint(supportedKey));
        goodValue = "false";
        this.query.setHint(supportedKey, (Object)goodValue);
        TestQueryHints.assertTrue((boolean)this.query.getHints().containsKey(supportedKey));
        TestQueryHints.assertEquals((Object)false, (Object)this.query.getFetchPlan().getDelegate().getHint(supportedKey));
    }

    public void testJPAHintSetsFetchPlan() {
        this.query.setHint("javax.persistence.lock.timeout", (Object)5671);
        this.query.setHint("javax.persistence.query.timeout", (Object)7500);
        TestQueryHints.assertEquals((int)5671, (int)this.query.getFetchPlan().getLockTimeout());
        TestQueryHints.assertEquals((int)7500, (int)this.query.getFetchPlan().getQueryTimeout());
    }

    public void testInvalidLockTimeoutHint() {
        try {
            this.query.setHint("javax.persistence.lock.timeout", (Object)-5671);
            TestQueryHints.fail((String)"Expected setHint to fail with an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidQueryTimeoutHint() {
        try {
            this.query.setHint("javax.persistence.query.timeout", (Object)-7500);
            TestQueryHints.fail((String)"Expected setHint to fail with an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFetchPlanIsolation() {
        this.query.setHint("openjpa.FetchPlan.Isolation", (Object)"SERIALIZABLE");
        TestQueryHints.assertTrue((boolean)this.query.getHints().containsKey("openjpa.FetchPlan.Isolation"));
        TestQueryHints.assertEquals((Object)IsolationLevel.SERIALIZABLE, (Object)((JDBCFetchPlan)this.query.getFetchPlan()).getIsolation());
    }

    public void testInvalidFetchPlanIsolation() {
        this.query.setHint("openjpa.FetchPlan.TransactionIsolation", (Object)"SERIALIZABLE");
        TestQueryHints.assertFalse((boolean)this.query.getHints().containsKey("openjpa.FetchPlan.TransactionIsolation"));
        TestQueryHints.assertNotEquals(IsolationLevel.SERIALIZABLE, ((JDBCFetchPlan)this.query.getFetchPlan()).getIsolation());
    }

    void assertSupportedHint(String hint, boolean contains) {
        if (contains) {
            TestQueryHints.assertTrue((String)("Expected supported hint [" + hint + "]"), (boolean)this.query.getSupportedHints().contains(hint));
        } else {
            TestQueryHints.assertFalse((String)("Unexpected supported hint [" + hint + "]"), (boolean)this.query.getSupportedHints().contains(hint));
        }
    }
}

