/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.common.apps.QTimeout;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryProperties
extends SingleEMFTestCase {
    private Map<String, String> props = null;

    @Override
    public void setUp() throws Exception {
        super.setUp(QTimeout.class, CLEAR_TABLES);
        this.props = new HashMap<String, String>();
        this.props.put("javax.persistence.lock.timeout", "12000");
        this.props.put("javax.persistence.query.timeout", "7000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoProperties() {
        this.getLog().trace((Object)"testNoProperties() - no properties in persistence.xml");
        OpenJPAEntityManagerFactory emf1 = null;
        OpenJPAEntityManagerFactory emf2 = null;
        OpenJPAEntityManager em1 = null;
        OpenJPAEntityManager em2 = null;
        try {
            Integer lTime = new Integer(0);
            Integer qTime = new Integer(0);
            emf1 = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-no-properties", (String)"persistence3.xml");
            TestQueryProperties.assertNotNull((Object)emf1);
            emf2 = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-no-properties", (String)"persistence3.xml", this.props);
            TestQueryProperties.assertNotNull((Object)emf2);
            OpenJPAConfiguration conf1 = emf1.getConfiguration();
            TestQueryProperties.assertNotNull((Object)conf1);
            TestQueryProperties.assertEquals((String)"Expected no default lock timeout", (int)lTime, (int)conf1.getLockTimeout());
            TestQueryProperties.assertEquals((String)"Expected no default query timeout", (int)qTime, (int)conf1.getQueryTimeout());
            em1 = emf1.createEntityManager();
            TestQueryProperties.assertNotNull((Object)em1);
            OpenJPAQuery q = em1.createNamedQuery("NoHintList");
            Map hints = q.getHints();
            TestQueryProperties.assertFalse((boolean)hints.containsKey("javax.persistence.lock.timeout"));
            TestQueryProperties.assertFalse((boolean)hints.containsKey("javax.persistence.query.timeout"));
            Integer timeout = q.getFetchPlan().getLockTimeout();
            TestQueryProperties.assertEquals((String)"Expected no default lock timeout", (int)lTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected no default query timeout", (int)qTime, (int)timeout);
            OpenJPAConfiguration conf2 = emf2.getConfiguration();
            TestQueryProperties.assertNotNull((Object)conf2);
            lTime = 12000;
            qTime = 7000;
            TestQueryProperties.assertEquals((String)"Expected Map updated lock timeout", (int)lTime, (int)conf2.getLockTimeout());
            TestQueryProperties.assertEquals((String)"Expected Map updated query timeout", (int)qTime, (int)conf2.getQueryTimeout());
            em2 = emf2.createEntityManager();
            TestQueryProperties.assertNotNull((Object)em2);
            q = em2.createNamedQuery("NoHintList");
            timeout = q.getFetchPlan().getLockTimeout();
            TestQueryProperties.assertEquals((String)"Expected Map updated lock timeout", (int)lTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected Map updated query timeout", (int)qTime, (int)timeout);
            lTime = 15000;
            qTime = 10000;
            q.setHint("javax.persistence.lock.timeout", (Object)lTime);
            q.setHint("javax.persistence.query.timeout", (Object)qTime);
            hints = q.getHints();
            timeout = (Integer)hints.get("javax.persistence.lock.timeout");
            TestQueryProperties.assertEquals((String)"Expected setHint updated javax.persistence.lock.timeout", (int)lTime, (int)timeout);
            timeout = (Integer)hints.get("javax.persistence.query.timeout");
            TestQueryProperties.assertEquals((String)"Expected setHint updated javax.persistence.query.timeout", (int)qTime, (int)timeout);
            timeout = q.getFetchPlan().getLockTimeout();
            TestQueryProperties.assertEquals((String)"Expected setHint updated lockTimeout", (int)lTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected setHint updated queryTimeout", (int)qTime, (int)timeout);
        }
        catch (Throwable throwable) {
            this.closeEMF((EntityManagerFactory)emf1);
            this.closeEMF((EntityManagerFactory)emf2);
            throw throwable;
        }
        this.closeEMF((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithProperties() {
        this.getLog().trace((Object)"testWithProperties() - properties in persistence.xml");
        OpenJPAEntityManagerFactory emf1 = null;
        OpenJPAEntityManagerFactory emf2 = null;
        OpenJPAEntityManager em1 = null;
        OpenJPAEntityManager em2 = null;
        try {
            Integer lTime = new Integer(10000);
            Integer qTime = new Integer(5000);
            emf1 = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-with-properties", (String)"persistence3.xml");
            TestQueryProperties.assertNotNull((Object)emf1);
            emf2 = OpenJPAPersistence.createEntityManagerFactory((String)"qtimeout-with-properties", (String)"persistence3.xml", this.props);
            TestQueryProperties.assertNotNull((Object)emf2);
            OpenJPAConfiguration conf1 = emf1.getConfiguration();
            TestQueryProperties.assertNotNull((Object)conf1);
            TestQueryProperties.assertEquals((String)"Default PU lock timeout", (int)lTime, (int)conf1.getLockTimeout());
            TestQueryProperties.assertEquals((String)"Default PU query timeout.", (int)qTime, (int)conf1.getQueryTimeout());
            em1 = emf1.createEntityManager();
            TestQueryProperties.assertNotNull((Object)em1);
            OpenJPAQuery q = em1.createNamedQuery("NoHintList");
            Integer timeout = q.getFetchPlan().getLockTimeout();
            TestQueryProperties.assertEquals((String)"Expected default PU lock timeout", (int)lTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected default PU query timeout", (int)qTime, (int)timeout);
            OpenJPAConfiguration conf2 = emf2.getConfiguration();
            TestQueryProperties.assertNotNull((Object)conf2);
            lTime = 12000;
            qTime = 7000;
            TestQueryProperties.assertEquals((String)"Expected Map updated lock timeout", (int)lTime, (int)conf2.getLockTimeout());
            TestQueryProperties.assertEquals((String)"Expected Map updated query timeout", (int)qTime, (int)conf2.getQueryTimeout());
            em2 = emf2.createEntityManager();
            TestQueryProperties.assertNotNull((Object)em2);
            q = em2.createNamedQuery("NoHintList");
            timeout = q.getFetchPlan().getLockTimeout();
            TestQueryProperties.assertEquals((String)"Expected Map updated lockTimeout", (int)lTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected Map updated queryTimeout", (int)qTime, (int)timeout);
            q = em2.createNamedQuery("Hint1000msec");
            qTime = 1000;
            Map hints = q.getHints();
            timeout = new Integer((String)hints.get("javax.persistence.query.timeout"));
            TestQueryProperties.assertEquals((String)"Expected QueryHints updated query timeout", (int)qTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected QueryHints updated queryTimeout", (int)qTime, (int)timeout);
            lTime = 15000;
            qTime = 10000;
            q.setHint("javax.persistence.lock.timeout", (Object)lTime);
            q.setHint("javax.persistence.query.timeout", (Object)qTime);
            hints = q.getHints();
            timeout = (Integer)hints.get("javax.persistence.lock.timeout");
            TestQueryProperties.assertEquals((String)"Expected setHint updated lock timeout", (int)lTime, (int)timeout);
            timeout = (Integer)hints.get("javax.persistence.query.timeout");
            TestQueryProperties.assertEquals((String)"Expected setHint updated query timeout", (int)qTime, (int)timeout);
            timeout = q.getFetchPlan().getLockTimeout();
            TestQueryProperties.assertEquals((String)"Expected setHint updated lockTimeout", (int)lTime, (int)timeout);
            timeout = q.getFetchPlan().getQueryTimeout();
            TestQueryProperties.assertEquals((String)"Expected setHint updated queryTimeout", (int)qTime, (int)timeout);
        }
        catch (Throwable throwable) {
            this.closeEMF((EntityManagerFactory)emf1);
            this.closeEMF((EntityManagerFactory)emf2);
            throw throwable;
        }
        this.closeEMF((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf2);
    }
}

