/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.BytecodeWriter;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;
import serp.bytecode.BCClass;
import serp.bytecode.Project;

public class TestEnhancementWithMultiplePUs
extends AbstractCachedEMFTestCase {
    public void testExplicitEnhancementWithClassNotInFirstPU() throws ClassNotFoundException {
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
        Configurations.populateConfiguration((Configuration)conf, (Options)new Options());
        MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        Project project = new Project();
        String className = "org.apache.openjpa.enhance.UnenhancedBootstrapInstance";
        BCClass bc = this.assertNotPC(loader, project, className);
        PCEnhancer enhancer = new PCEnhancer((OpenJPAConfiguration)conf, bc, repos, loader);
        TestEnhancementWithMultiplePUs.assertEquals((int)8, (int)enhancer.run());
        TestEnhancementWithMultiplePUs.assertTrue((boolean)Arrays.asList(bc.getInterfaceNames()).contains(PersistenceCapable.class.getName()));
    }

    private BCClass assertNotPC(ClassLoader loader, Project project, String className) {
        BCClass bc = project.loadClass(className, loader);
        TestEnhancementWithMultiplePUs.assertFalse((String)(className + " must not be enhanced already; it was."), (boolean)Arrays.asList(bc.getInterfaceNames()).contains(PersistenceCapable.class.getName()));
        return bc;
    }

    public void testEnhancementOfSecondPUWithClassNotInFirstPU() throws IOException {
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
        Options opts = new Options();
        opts.setProperty("p", "META-INF/persistence.xml#second-persistence-unit");
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        Project project = new Project();
        String className = "org.apache.openjpa.enhance.UnenhancedBootstrapInstance";
        BCClass bc = this.assertNotPC(loader, project, className);
        final ArrayList written = new ArrayList();
        BytecodeWriter writer = new BytecodeWriter(){

            public void write(BCClass type) throws IOException {
                Assert.assertTrue((boolean)Arrays.asList(type.getInterfaceNames()).contains(PersistenceCapable.class.getName()));
                written.add(type.getName());
            }
        };
        PCEnhancer.run((OpenJPAConfiguration)conf, null, (PCEnhancer.Flags)new PCEnhancer.Flags(), (MetaDataRepository)repos, (BytecodeWriter)writer, (ClassLoader)loader);
        TestEnhancementWithMultiplePUs.assertEquals((int)1, (int)written.size());
        TestEnhancementWithMultiplePUs.assertTrue((boolean)written.contains(className));
    }

    public void testEnhancementOfAllPUsWithinAResource() throws IOException {
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
        Options opts = new Options();
        opts.setProperty("p", "META-INF/persistence.xml");
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        Project project = new Project();
        this.assertNotPC(loader, project, "org.apache.openjpa.enhance.UnenhancedBootstrapInstance");
        this.assertNotPC(loader, project, "org.apache.openjpa.enhance.UnenhancedBootstrapInstance2");
        final ArrayList written = new ArrayList();
        BytecodeWriter writer = new BytecodeWriter(){

            public void write(BCClass type) throws IOException {
                Assert.assertTrue((boolean)Arrays.asList(type.getInterfaceNames()).contains(PersistenceCapable.class.getName()));
                written.add(type.getName());
            }
        };
        opts = new Options();
        opts.setProperty("MetaDataRepository", "org.apache.openjpa.enhance.RestrictedMetaDataRepository(excludedTypes=org.apache.openjpa.persistence.jdbc.annotations.UnenhancedMixedAccess)");
        opts.put((Object)(PCEnhancer.class.getName() + "#bytecodeWriter"), (Object)writer);
        PCEnhancer.run(null, (Options)opts);
        TestEnhancementWithMultiplePUs.assertTrue((boolean)written.contains("org.apache.openjpa.enhance.UnenhancedBootstrapInstance"));
        TestEnhancementWithMultiplePUs.assertTrue((boolean)written.contains("org.apache.openjpa.enhance.UnenhancedBootstrapInstance2"));
    }
}

