/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance.ids;

import java.util.List;
import java.util.Random;
import javax.persistence.TypedQuery;
import org.apache.openjpa.enhance.ids.Device;
import org.apache.openjpa.enhance.ids.DeviceId;
import org.apache.openjpa.enhance.ids.Hardware;
import org.apache.openjpa.enhance.ids.HardwareId;
import org.apache.openjpa.enhance.ids.Software;
import org.apache.openjpa.enhance.ids.SoftwareId;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOptimizeIdCopy
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(Device.class, Hardware.class, Software.class, CLEAR_TABLES);
    }

    public void testIdOptimization() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Software sw = new Software();
        int id = new Random().nextInt();
        sw.setIdInt(id);
        sw.setIdInteger(10);
        sw.setIdString("StringIdVal");
        em.getTransaction().begin();
        em.persist((Object)sw);
        em.getTransaction().commit();
        em.clear();
        TypedQuery swq = em.createQuery("select sw from Software sw", Software.class);
        List swl = swq.getResultList();
        TestOptimizeIdCopy.assertTrue((String)"Software result list > 0", (swl.size() > 0 ? 1 : 0) != 0);
        TestOptimizeIdCopy.assertFalse((String)"First constructor was not used", (boolean)SoftwareId.usedConstructor[0]);
        TestOptimizeIdCopy.assertFalse((String)"Second constructor was not used", (boolean)SoftwareId.usedConstructor[1]);
        TestOptimizeIdCopy.assertTrue((String)"Third (correct) constructor was used", (boolean)SoftwareId.usedConstructor[2]);
        em.close();
    }

    public void testIdOptimizationConstructorOutOfOrder() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Hardware hw = new Hardware();
        String id = "Model" + new Random().nextInt();
        hw.setModel("Model" + id);
        hw.setSerial("123XYZ");
        em.getTransaction().begin();
        em.persist((Object)hw);
        em.getTransaction().commit();
        em.clear();
        TypedQuery hwq = em.createQuery("select hw from Hardware hw", Hardware.class);
        List hwl = hwq.getResultList();
        TestOptimizeIdCopy.assertTrue((String)"Hardware result list > 0", (hwl.size() > 0 ? 1 : 0) != 0);
        TestOptimizeIdCopy.assertTrue((String)"First (correct) constructor was used", (boolean)HardwareId.usedConstructor[0]);
        TestOptimizeIdCopy.assertFalse((String)"Second constructor was not used", (boolean)HardwareId.usedConstructor[1]);
        em.close();
    }

    public void testNoOptimization() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int id = new Random().nextInt();
        Device d = new Device();
        d.setId(id);
        d.setType(10);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        TypedQuery dq = em.createQuery("select d from Device d", Device.class);
        List dl = dq.getResultList();
        TestOptimizeIdCopy.assertTrue((String)"Device result list > 0", (dl.size() > 0 ? 1 : 0) != 0);
        TestOptimizeIdCopy.assertTrue((String)"First (default) constructor was used", (boolean)DeviceId.usedConstructor[0]);
        TestOptimizeIdCopy.assertFalse((String)"Second constructor was not used", (boolean)DeviceId.usedConstructor[1]);
        TestOptimizeIdCopy.assertFalse((String)"Third constructor was not used", (boolean)DeviceId.usedConstructor[2]);
        em.close();
    }
}

