/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.EntityF;
import org.apache.openjpa.jdbc.kernel.EntityG;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestForeignKeyCountViolation
extends SingleEMFTestCase {
    private JDBCConfiguration _conf;

    @Override
    public void setUp() {
        super.setUp(EntityF.class, EntityG.class);
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        this._conf = (JDBCConfiguration)this.emf.getConfiguration();
    }

    public void testFKCount() throws SQLException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Table tableG = this.getMapping(EntityG.class).getTable();
        tableG.addForeignKey();
        int b4Count = tableG.getForeignKeys().length;
        EntityF f = new EntityF();
        f.setId(1);
        ArrayList<EntityG> listG = new ArrayList<EntityG>();
        EntityG g1 = new EntityG();
        g1.setId(1);
        listG.add(g1);
        g1.setEntityF(f);
        EntityG g2 = new EntityG();
        g2.setId(2);
        listG.add(g2);
        g2.setEntityF(f);
        EntityG g3 = new EntityG();
        g3.setId(3);
        listG.add(g3);
        g3.setEntityF(f);
        EntityG g4 = new EntityG();
        g4.setId(4);
        listG.add(g4);
        g4.setEntityF(f);
        f.setListG(listG);
        em.getTransaction().begin();
        em.persist((Object)f);
        em.persist((Object)g1);
        em.persist((Object)g2);
        em.persist((Object)g3);
        em.persist((Object)g4);
        em.getTransaction().commit();
        ForeignKey[] fks = tableG.getForeignKeys();
        DataSource ds = (DataSource)this._conf.getConnectionFactory();
        Connection c = ds.getConnection(this._conf.getConnectionUserName(), this._conf.getConnectionPassword());
        for (int i = 0; i < fks.length; ++i) {
            fks[i].loadNameFromDB(this._conf.getDBDictionaryInstance(), c);
        }
        TestForeignKeyCountViolation.assertEquals((int)b4Count, (int)tableG.getForeignKeys().length);
        em.close();
    }

    public void testFKNamefromDB() throws SQLException {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Table tableG = this.getMapping(EntityG.class).getTable();
        tableG.addForeignKey();
        EntityF f = new EntityF();
        f.setId(1);
        ArrayList<EntityG> listG = new ArrayList<EntityG>();
        EntityG g1 = new EntityG();
        g1.setId(1);
        listG.add(g1);
        g1.setEntityF(f);
        EntityG g2 = new EntityG();
        g2.setId(2);
        listG.add(g2);
        g2.setEntityF(f);
        EntityG g3 = new EntityG();
        g3.setId(3);
        listG.add(g3);
        g3.setEntityF(f);
        EntityG g4 = new EntityG();
        g4.setId(4);
        listG.add(g4);
        g4.setEntityF(f);
        f.setListG(listG);
        em.getTransaction().begin();
        em.persist((Object)f);
        em.persist((Object)g1);
        em.persist((Object)g2);
        em.persist((Object)g3);
        em.persist((Object)g4);
        em.getTransaction().commit();
        DataSource ds = (DataSource)this._conf.getConnectionFactory();
        Connection c = ds.getConnection(this._conf.getConnectionUserName(), this._conf.getConnectionPassword());
        ForeignKey[] fkfromDB = this._conf.getDBDictionaryInstance().getImportedKeys(c.getMetaData(), c.getCatalog(), tableG.getSchemaName(), tableG.getName(), c);
        ArrayList<String> fkListfromDB = new ArrayList<String>();
        ArrayList<String> fkListfromTable = new ArrayList<String>();
        for (int i2 = 0; i2 < fkfromDB.length; ++i2) {
            fkListfromDB.add(fkfromDB[i2].getName());
        }
        ForeignKey[] fks = tableG.getForeignKeys();
        for (i = 0; i < fks.length; ++i) {
            String fkNamefromDB = fks[i].loadNameFromDB(this._conf.getDBDictionaryInstance(), c);
            if (fkNamefromDB == null) continue;
            fkListfromTable.add(fkNamefromDB);
        }
        TestForeignKeyCountViolation.assertEquals((int)fkListfromDB.toArray().length, (int)fkListfromTable.toArray().length);
        Collections.sort(fkListfromTable);
        Collections.sort(fkListfromDB);
        for (i = 0; i < fkListfromDB.size(); ++i) {
            TestForeignKeyCountViolation.assertEquals((String)((String)fkListfromDB.get(i)), (String)((String)fkListfromTable.get(i)));
        }
        em.close();
    }
}

