/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.ArrayList;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.EntityA;
import org.apache.openjpa.jdbc.kernel.EntityB;
import org.apache.openjpa.jdbc.kernel.EntityC;
import org.apache.openjpa.jdbc.kernel.EntityD;
import org.apache.openjpa.jdbc.kernel.EntityE;
import org.apache.openjpa.jdbc.kernel.EntityF;
import org.apache.openjpa.jdbc.kernel.EntityG;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNoForeignKeyViolation
extends SingleEMFTestCase {
    private EntityA entityA;
    private EntityB entityB;
    private EntityC entityC;
    private EntityD entityD;

    @Override
    public void setUp() {
        this.setUp(EntityA.class, EntityB.class, EntityC.class, EntityD.class, EntityE.class, EntityF.class, EntityG.class);
        this.createTestData();
    }

    private void createTestData() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.entityA = new EntityA();
        this.entityB = new EntityB();
        this.entityC = new EntityC();
        this.entityD = new EntityD();
        this.entityA.setName("entityA");
        this.entityB.setName("entityB");
        this.entityC.setName("entityC");
        this.entityD.setName("entityD");
        this.entityA.setEntityB(this.entityB);
        this.entityB.setEntityC(this.entityC);
        this.entityC.setEntityD(this.entityD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSqlOrder() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            em.persist((Object)this.entityA);
            em.getTransaction().commit();
            EntityD newEntityD = new EntityD();
            newEntityD.setName("newEntityD");
            this.entityC.setEntityD(newEntityD);
            em.getTransaction().begin();
            em.merge((Object)this.entityC);
            em.getTransaction().commit();
            EntityC newEntityC = new EntityC();
            newEntityC.setName("newEntityC");
            newEntityD = new EntityD();
            newEntityD.setName("newNewEntityD");
            newEntityC.setEntityD(newEntityD);
            this.entityB.setEntityC(newEntityC);
            em.getTransaction().begin();
            em.merge((Object)this.entityB);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleCycle() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            this.entityD.setEntityA(this.entityA);
            em.persist((Object)this.entityA);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexCycle() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            EntityE entityE = new EntityE();
            entityE.setName("entityE");
            entityE.setEntityB(this.entityB);
            em.getTransaction().begin();
            em.persist((Object)entityE);
            this.entityD.setEntityA(this.entityA);
            em.persist((Object)this.entityA);
            em.getTransaction().commit();
            em.getTransaction().begin();
            em.remove((Object)entityE);
            em.remove((Object)this.entityA);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexTwoCycles() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            EntityE entityE = new EntityE();
            entityE.setName("entityE");
            entityE.setEntityB(this.entityB);
            em.getTransaction().begin();
            em.persist((Object)entityE);
            this.entityD.setEntityA(this.entityA);
            this.entityD.setEntityB(this.entityB);
            em.persist((Object)this.entityA);
            em.getTransaction().commit();
            em.getTransaction().begin();
            em.remove((Object)entityE);
            em.remove((Object)this.entityA);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForeignKeyCascade() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            EntityF f = new EntityF();
            f.setId(1);
            ArrayList<EntityG> listG = new ArrayList<EntityG>();
            EntityG g1 = new EntityG();
            g1.setId(1);
            listG.add(g1);
            g1.setEntityF(f);
            EntityG g2 = new EntityG();
            g2.setId(2);
            listG.add(g2);
            g2.setEntityF(f);
            EntityG g3 = new EntityG();
            g3.setId(3);
            listG.add(g3);
            g3.setEntityF(f);
            EntityG g4 = new EntityG();
            g4.setId(4);
            listG.add(g4);
            g4.setEntityF(f);
            f.setListG(listG);
            em.getTransaction().begin();
            em.persist((Object)f);
            em.persist((Object)g1);
            em.persist((Object)g2);
            em.persist((Object)g3);
            em.persist((Object)g4);
            em.getTransaction().commit();
            em.getTransaction().begin();
            em.remove((Object)f);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            TestNoForeignKeyViolation.fail((String)"Fail to delete EntityF");
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

