/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.openjpa.persistence.simple.TemporalFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMTestCase;
import org.apache.openjpa.util.ProxyCalendar;

public class TestCalendarField
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(TemporalFieldTypes.class);
    }

    public void testCalendarField() throws IOException, SQLException {
        TimeZone tz = TimeZone.getTimeZone("Europe/Budapest");
        for (TemporalFieldTypes t : this.find(TemporalFieldTypes.class)) {
            this.remove(t);
        }
        TemporalFieldTypes tft = new TemporalFieldTypes();
        TestCalendarField.assertEquals((Object)tz, (Object)tft.getCalendarTimeZoneField().getTimeZone());
        this.persist(tft);
        this.reset();
        tft = this.find(TemporalFieldTypes.class).get(0);
        TestCalendarField.assertEquals((Object)tz, (Object)tft.getCalendarTimeZoneField().getTimeZone());
    }

    public void testCalendarQuery() throws Exception {
        this.persist(new TemporalFieldTypes());
        this.persist(new TemporalFieldTypes());
        this.persist(new TemporalFieldTypes());
        this.em.clear();
        Calendar cal = (Calendar)this.em.createQuery("SELECT t.calendarTimeZoneField FROM TemporalFieldTypes t WHERE 1=1", Calendar.class).setMaxResults(1).getSingleResult();
        TestCalendarField.assertFalse((boolean)(cal instanceof ProxyCalendar));
        List cals = this.em.createQuery("SELECT t.calendarTimeZoneField FROM TemporalFieldTypes t WHERE 1=1", Calendar.class).setMaxResults(3).getResultList();
        for (Calendar c : cals) {
            TestCalendarField.assertFalse((boolean)(c instanceof ProxyCalendar));
        }
    }
}

