/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jira1794;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.openjpa.jira1794.AggEntity;
import org.apache.openjpa.jira1794.AggEntity_;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestAggregateFunctions
extends SingleEMFTestCase {
    private static final int MAX = 0;
    private static final int MIN = 1;
    private static final int SUM = 2;
    private static final String[] numericAggregateFunctions = new String[]{"MAX", "AVG", "MIN", "SUM"};
    private static final String[] stringAggregateFunctions = new String[]{"MAX", "MIN"};
    private static final String[] numericAttributes = new String[]{"ae.pintVal", "ae.intVal", "ae.shortVal", "ae.pshortVal", "ae.pintVal", "ae.intVal", "ae.plongVal", "ae.longVal", "ae.pfloatVal", "ae.floatVal", "ae.pdblVal", "ae.dblVal"};

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, AggEntity.class);
    }

    protected boolean nullResultExpected() {
        return true;
    }

    public void testAggregateJPQL() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.verifyResult((EntityManager)em, numericAggregateFunctions, numericAttributes, true);
        this.verifyResult((EntityManager)em, stringAggregateFunctions, new String[]{"ae.stringVal"}, true, true);
        AggEntity ae = new AggEntity();
        ae.init();
        em.getTransaction().begin();
        em.persist((Object)ae);
        em.getTransaction().commit();
        this.verifyResult((EntityManager)em, numericAggregateFunctions, numericAttributes, false);
        this.verifyResult((EntityManager)em, stringAggregateFunctions, new String[]{"ae.stringVal"}, false);
        em.close();
    }

    public void testAggregateCriteria() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Metamodel mm = this.emf.getMetamodel();
        mm.getEntities();
        TypedQuery q = null;
        for (int agg = 0; agg <= 2; ++agg) {
            CriteriaQuery<Short> cqs = this.buildNumericCriteriaQuery((EntityManager)em, Short.class, AggEntity_.shortVal, agg);
            q = em.createQuery(cqs);
            this.verifyQueryResult((Query)q, true);
            cqs = this.buildNumericCriteriaQuery((EntityManager)em, Short.class, AggEntity_.pshortVal, agg);
            q = em.createQuery(cqs);
            this.verifyQueryResult((Query)q, true);
            CriteriaQuery<Integer> cqi = this.buildNumericCriteriaQuery((EntityManager)em, Integer.class, AggEntity_.intVal, agg);
            q = em.createQuery(cqi);
            this.verifyQueryResult((Query)q, true);
            cqi = this.buildNumericCriteriaQuery((EntityManager)em, Integer.class, AggEntity_.pintVal, agg);
            q = em.createQuery(cqi);
            this.verifyQueryResult((Query)q, true);
            CriteriaQuery<Float> cqf = this.buildNumericCriteriaQuery((EntityManager)em, Float.class, AggEntity_.floatVal, agg);
            q = em.createQuery(cqf);
            this.verifyQueryResult((Query)q, true);
            cqf = this.buildNumericCriteriaQuery((EntityManager)em, Float.class, AggEntity_.pfloatVal, agg);
            q = em.createQuery(cqi);
            this.verifyQueryResult((Query)q, true);
            CriteriaQuery<Double> cqd = this.buildNumericCriteriaQuery((EntityManager)em, Double.class, AggEntity_.dblVal, agg);
            q = em.createQuery(cqd);
            this.verifyQueryResult((Query)q, true);
            cqd = this.buildNumericCriteriaQuery((EntityManager)em, Double.class, AggEntity_.pdblVal, agg);
            q = em.createQuery(cqi);
            this.verifyQueryResult((Query)q, true);
        }
        CriteriaQuery<Double> cqd = this.buildAvgCriteriaQuery((EntityManager)em, Double.class, AggEntity_.dblVal);
        q = em.createQuery(cqd);
        this.verifyQueryResult((Query)q, true);
        cqd = this.buildAvgCriteriaQuery((EntityManager)em, Double.class, AggEntity_.pdblVal);
        q = em.createQuery(cqd);
        this.verifyQueryResult((Query)q, true);
        em.close();
    }

    private <T extends Number> CriteriaQuery<T> buildNumericCriteriaQuery(EntityManager em, Class<T> type, SingularAttribute<AggEntity, T> sa, int at) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(type);
        Root aer = cq.from(AggEntity.class);
        Path path = aer.get(sa);
        Expression exp = null;
        switch (at) {
            case 0: {
                exp = cb.max((Expression)path);
                break;
            }
            case 1: {
                exp = cb.min((Expression)path);
                break;
            }
            case 2: {
                exp = cb.sum((Expression)path);
            }
        }
        cq.select(exp);
        return cq;
    }

    private CriteriaQuery<Double> buildAvgCriteriaQuery(EntityManager em, Class<Double> type, SingularAttribute<AggEntity, Double> sa) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(type);
        Root aer = cq.from(AggEntity.class);
        return cq.select((Selection)cb.avg((Expression)aer.get(sa)));
    }

    private void verifyResult(EntityManager em, String[] aggregates, String[] attributes, boolean expectNull) {
        this.verifyResult(em, aggregates, attributes, expectNull, false);
    }

    private void verifyResult(EntityManager em, String[] aggregates, String[] attributes, boolean expectNull, boolean isString) {
        for (String func : aggregates) {
            for (String attr : attributes) {
                String sql = "SELECT " + func + "(" + attr + ")" + " FROM AggEntity ae WHERE " + attr + " <= " + "(SELECT " + func + "(" + attr.replaceFirst("^ae.", "ae2.") + ") FROM AggEntity ae2)";
                Query q = em.createQuery(sql);
                this.verifyQueryResult(q, expectNull, isString);
            }
        }
    }

    private void verifyQueryResult(Query q, boolean emptyRs) {
        this.verifyQueryResult(q, emptyRs, false);
    }

    private void verifyQueryResult(Query q, boolean emptyRs, boolean isString) {
        Object result = q.getSingleResult();
        if (!emptyRs && !isString) {
            TestAggregateFunctions.assertNotNull((Object)result);
        } else if (isString || this.nullResultExpected()) {
            TestAggregateFunctions.assertNull((Object)result);
        } else {
            TestAggregateFunctions.assertNotNull((Object)result);
        }
        List resultList = q.getResultList();
        TestAggregateFunctions.assertEquals((int)1, (int)resultList.size());
        if (!emptyRs && !isString) {
            TestAggregateFunctions.assertNotNull((Object)result);
        } else if (isString || this.nullResultExpected()) {
            TestAggregateFunctions.assertNull((Object)result);
        } else {
            TestAggregateFunctions.assertNotNull((Object)result);
        }
    }
}

