/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class SimpleTransaction
implements Transaction {
    private final Set<Synchronization> synchs = new HashSet<Synchronization>();
    private Throwable rollbackCause;
    private volatile int status = 5;

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
        if (this.status == 1) {
            throw new RuntimeException(this + " can not commit. Marked for rollback");
        }
        this.status = 8;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Synchronization synch : this.synchs) {
            try {
                synch.beforeCompletion();
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        this.status = errors.isEmpty() ? 3 : 4;
        for (Synchronization synch : this.synchs) {
            try {
                synch.afterCompletion(this.status);
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        this.status = errors.isEmpty() ? 3 : 5;
    }

    public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public boolean enlistResource(XAResource arg0) throws IllegalStateException, RollbackException, SystemException {
        return false;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    void setStatus(int newStatus) throws SystemException {
        this.status = newStatus;
    }

    public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
        this.synchs.add(synch);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.status = 9;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Synchronization synch : this.synchs) {
            try {
                synch.beforeCompletion();
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        for (Synchronization synch : this.synchs) {
            try {
                synch.afterCompletion(4);
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        int n = this.status = errors.isEmpty() ? 4 : 5;
        if (!errors.isEmpty()) {
            throw new RuntimeException((Throwable)errors.get(0));
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.setRollbackOnly(null);
    }

    void setRollbackOnly(Throwable cause) throws IllegalStateException, SystemException {
        this.rollbackCause = cause;
        this.status = 1;
    }

    Throwable getRollbackCause() {
        return this.rollbackCause;
    }

    public String toString() {
        return "TXN:" + this.hashCode() + "[" + this.statusCode() + "]";
    }

    String statusCode() {
        switch (this.status) {
            case 0: {
                return "active";
            }
            case 3: {
                return "committed";
            }
            case 8: {
                return "committing";
            }
            case 1: {
                return "marked rollback";
            }
            case 6: {
                return "none";
            }
            case 2: {
                return "prepared";
            }
            case 7: {
                return "preparing";
            }
            case 4: {
                return "rolled back";
            }
            case 9: {
                return "rolling back";
            }
            case 5: {
                return "unknown";
            }
        }
        return "error";
    }
}

