/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.event.AbstractLifecycleListener;
import org.apache.openjpa.event.AbstractTransactionListener;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.JoinSyntax;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public abstract class AbstractBrokerSerializationTest<T>
extends SingleEMFTestCase {
    private static LifeListener deserializedLifeListener;
    private static int testGlobalRefreshCount;
    private static TxListener deserializedTxListener;
    private static int testGlobalBeginCount;
    private Object id;

    @Override
    public void setUp() {
        testGlobalRefreshCount = 0;
        deserializedLifeListener = null;
        testGlobalBeginCount = 0;
        deserializedTxListener = null;
        this.setUp(this.getManagedType(), this.getSecondaryType(), CLEAR_TABLES, "openjpa.EntityManagerFactoryPool", "true");
        T e = this.newManagedInstance();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist(e);
        em.getTransaction().commit();
        this.id = em.getObjectId(e);
        em.close();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        testGlobalRefreshCount = 0;
        deserializedLifeListener = null;
        testGlobalBeginCount = 0;
        deserializedTxListener = null;
    }

    public void testEmptyBrokerSerialization() {
        OpenJPAEntityManager em2;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        AbstractBrokerSerializationTest.assertTrue((em != (em2 = this.deserializeEM(this.serialize(em))) ? 1 : 0) != 0);
        AbstractBrokerSerializationTest.assertTrue((JPAFacadeHelper.toBroker((EntityManager)em) != JPAFacadeHelper.toBroker((EntityManager)em2) ? 1 : 0) != 0);
        AbstractBrokerSerializationTest.assertSame((Object)em.getEntityManagerFactory(), (Object)em2.getEntityManagerFactory());
        AbstractBrokerSerializationTest.assertSame((Object)em2, (Object)JPAFacadeHelper.toBroker((EntityManager)em2).getUserObject((Object)"org.apache.openjpa.persistence.EntityManager"));
        em.close();
        AbstractBrokerSerializationTest.assertTrue((boolean)em2.isOpen());
        em2.close();
    }

    public void testNontransactionalBrokerSerialization() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Object e = em.find(this.getManagedType(), this.id);
        OpenJPAEntityManager em2 = this.deserializeEM(this.serialize(em));
        AbstractBrokerSerializationTest.assertFalse((boolean)em2.getTransaction().isActive());
        AbstractBrokerSerializationTest.assertFalse((boolean)em2.contains(e));
        AbstractBrokerSerializationTest.assertEquals((int)(1 * this.graphSize()), (int)em2.getManagedObjects().size());
        Object e2 = em2.find(this.getManagedType(), this.id);
        AbstractBrokerSerializationTest.assertEquals((Object)em.getObjectId(e), (Object)em2.getObjectId(e2));
        em.close();
        em2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnflushedOptimisticTxBrokerSerialization() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Object e = em.find(this.getManagedType(), this.id);
        OpenJPAEntityManager em2 = null;
        OpenJPAEntityManagerSPI em3 = null;
        try {
            em.getTransaction().begin();
            this.modifyInstance(e);
            T newe = this.newManagedInstance();
            em.persist(newe);
            em2 = this.deserializeEM(this.serialize(em));
            AbstractBrokerSerializationTest.assertTrue((boolean)em2.getTransaction().isActive());
            AbstractBrokerSerializationTest.assertFalse((boolean)em2.contains(e));
            Object e2 = em2.find(this.getManagedType(), this.id);
            AbstractBrokerSerializationTest.assertEquals((Object)em.getObjectId(e), (Object)em2.getObjectId(e2));
            AbstractBrokerSerializationTest.assertEquals((Object)"modified", (Object)this.getModifiedValue(e2));
            em.getTransaction().rollback();
            AbstractBrokerSerializationTest.assertTrue((boolean)em2.getTransaction().isActive());
            em2.getTransaction().commit();
            em3 = this.emf.createEntityManager();
            Object e3 = em3.find(this.getManagedType(), this.id);
            AbstractBrokerSerializationTest.assertEquals((Object)this.getModifiedValue(e2), (Object)this.getModifiedValue(e3));
            AbstractBrokerSerializationTest.assertTrue((1 < ((Number)em3.createQuery("select count(o) from " + this.getManagedType().getName() + " o").getSingleResult()).intValue() ? 1 : 0) != 0);
            this.close((EntityManager)em);
            this.close((EntityManager)em2);
            this.close((EntityManager)em3);
        }
        catch (Throwable throwable) {
            this.close((EntityManager)em);
            this.close((EntityManager)em2);
            this.close((EntityManager)em3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlushedOptimisticTxBrokerSerialization() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Object e = em.find(this.getManagedType(), this.id);
        em.getTransaction().begin();
        this.modifyInstance(e);
        em.flush();
        try {
            this.serialize(em);
        }
        catch (InvalidStateException ise) {
            AbstractBrokerSerializationTest.assertTrue((boolean)ise.getMessage().contains("flushed"));
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectedOptimisticTxBrokerSerialization() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("openjpa.ConnectionRetainMode", "always");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager(m);
        try {
            this.serialize(em);
        }
        catch (InvalidStateException ise) {
            AbstractBrokerSerializationTest.assertTrue((boolean)ise.getMessage().contains("connected"));
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyPessimisticTxBrokerSerialization() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("openjpa.Optimistic", "false");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager(m);
        em.getTransaction().begin();
        try {
            this.serialize(em);
            AbstractBrokerSerializationTest.fail((String)"should not be able to serialize");
        }
        catch (InvalidStateException ise) {
            AbstractBrokerSerializationTest.assertTrue((boolean)ise.getMessage().contains("datastore (pessimistic)"));
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonEmptyPessimisticTxBrokerSerialization() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("openjpa.Optimistic", "false");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager(m);
        Object e = em.find(this.getManagedType(), this.id);
        em.getTransaction().begin();
        try {
            this.serialize(em);
            AbstractBrokerSerializationTest.fail((String)"should not be able to serialize");
        }
        catch (InvalidStateException ise) {
            AbstractBrokerSerializationTest.assertTrue((boolean)ise.getMessage().contains("datastore (pessimistic)"));
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }

    public void testFetchConfigurationMutations() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        JDBCFetchPlan plan = (JDBCFetchPlan)em.getFetchPlan();
        AbstractBrokerSerializationTest.assertNotEquals(17, plan.getLockTimeout());
        AbstractBrokerSerializationTest.assertNotEquals(JoinSyntax.TRADITIONAL, plan.getJoinSyntax());
        plan.setLockTimeout(17);
        plan.setJoinSyntax(JoinSyntax.TRADITIONAL);
        OpenJPAEntityManager em2 = this.deserializeEM(this.serialize(em));
        JDBCFetchPlan plan2 = (JDBCFetchPlan)em2.getFetchPlan();
        AbstractBrokerSerializationTest.assertEquals((int)17, (int)plan2.getLockTimeout());
        AbstractBrokerSerializationTest.assertEquals((Object)JoinSyntax.TRADITIONAL, (Object)plan2.getJoinSyntax());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInMemorySavepointsWithNewInstances() {
        OpenJPAEntityManagerFactorySPI emf1 = this.createEMF(this.getManagedType(), this.getSecondaryType(), "openjpa.EntityManagerFactoryPool", "true", "openjpa.SavepointManager", "in-mem");
        OpenJPAEntityManager em = emf1.createEntityManager();
        OpenJPAEntityManager em2 = null;
        try {
            em.getTransaction().begin();
            T t = this.newManagedInstance();
            Object orig = this.getModifiedValue(t);
            em.persist(t);
            Object id = em.getObjectId(t);
            em.setSavepoint("foo");
            this.modifyInstance(t);
            AbstractBrokerSerializationTest.assertNotEquals(orig, this.getModifiedValue(t));
            em2 = this.deserializeEM(this.serialize(em));
            Object t2 = em2.find(this.getManagedType(), id);
            AbstractBrokerSerializationTest.assertNotEquals(orig, this.getModifiedValue(t2));
            em.rollbackToSavepoint("foo");
            AbstractBrokerSerializationTest.assertEquals((Object)orig, (Object)this.getModifiedValue(t));
            em2.rollbackToSavepoint("foo");
            AbstractBrokerSerializationTest.assertEquals((Object)orig, (Object)this.getModifiedValue(t2));
            this.close((EntityManager)em);
            this.close((EntityManager)em2);
        }
        catch (Throwable throwable) {
            this.close((EntityManager)em);
            this.close((EntityManager)em2);
            this.clear((EntityManagerFactory)emf1);
            this.closeEMF((EntityManagerFactory)emf1);
            throw throwable;
        }
        this.clear((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInMemorySavepointsWithModifiedInstances() {
        OpenJPAEntityManagerFactorySPI emf1 = this.createEMF(this.getManagedType(), this.getSecondaryType(), "openjpa.EntityManagerFactoryPool", "true", "openjpa.SavepointManager", "in-mem");
        OpenJPAEntityManager em = emf1.createEntityManager();
        OpenJPAEntityManager em2 = null;
        try {
            em.getTransaction().begin();
            Object t = em.find(this.getManagedType(), this.id);
            Object orig = this.getModifiedValue(t);
            em.setSavepoint("foo");
            this.modifyInstance(t);
            AbstractBrokerSerializationTest.assertNotEquals(orig, this.getModifiedValue(t));
            em2 = this.deserializeEM(this.serialize(em));
            Object t2 = em2.find(this.getManagedType(), this.id);
            AbstractBrokerSerializationTest.assertNotEquals(orig, this.getModifiedValue(t2));
            em.rollbackToSavepoint("foo");
            AbstractBrokerSerializationTest.assertEquals((Object)orig, (Object)this.getModifiedValue(t));
            em2.rollbackToSavepoint("foo");
            AbstractBrokerSerializationTest.assertEquals((Object)orig, (Object)this.getModifiedValue(t2));
            this.close((EntityManager)em);
            this.close((EntityManager)em2);
        }
        catch (Throwable throwable) {
            this.close((EntityManager)em);
            this.close((EntityManager)em2);
            this.clear((EntityManagerFactory)emf1);
            this.closeEMF((EntityManagerFactory)emf1);
            throw throwable;
        }
        this.clear((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testEventManagers() {
        TxListener txListener = new TxListener();
        this.emf.addTransactionListener((Object)txListener);
        LifeListener lifeListener = new LifeListener();
        this.emf.addLifecycleListener((Object)lifeListener, null);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Object t = em.find(this.getManagedType(), this.id);
        AbstractBrokerSerializationTest.assertEquals((int)0, (int)lifeListener.refreshCount);
        em.refresh(t);
        AbstractBrokerSerializationTest.assertEquals((int)(1 * this.graphSize()), (int)lifeListener.refreshCount);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.getTransaction().commit();
        AbstractBrokerSerializationTest.assertEquals((int)2, (int)txListener.beginCount);
        OpenJPAEntityManager em2 = this.deserializeEM(this.serialize(em));
        AbstractBrokerSerializationTest.assertNotNull((Object)deserializedLifeListener);
        AbstractBrokerSerializationTest.assertEquals((int)(1 * this.graphSize()), (int)deserializedLifeListener.refreshCount);
        AbstractBrokerSerializationTest.assertNotSame((Object)lifeListener, (Object)deserializedLifeListener);
        Object t2 = em2.find(this.getManagedType(), this.id);
        em2.refresh(t2);
        AbstractBrokerSerializationTest.assertEquals((int)(2 * this.graphSize()), (int)deserializedLifeListener.refreshCount);
        AbstractBrokerSerializationTest.assertEquals((int)(2 * this.graphSize()), (int)testGlobalRefreshCount);
        AbstractBrokerSerializationTest.assertNotNull((Object)deserializedTxListener);
        AbstractBrokerSerializationTest.assertEquals((int)2, (int)deserializedTxListener.beginCount);
        AbstractBrokerSerializationTest.assertNotSame((Object)txListener, (Object)deserializedTxListener);
        em2.getTransaction().begin();
        em2.getTransaction().rollback();
        AbstractBrokerSerializationTest.assertEquals((int)3, (int)deserializedTxListener.beginCount);
        AbstractBrokerSerializationTest.assertEquals((int)3, (int)testGlobalBeginCount);
    }

    byte[] serialize(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    OpenJPAEntityManager deserializeEM(byte[] bytes) {
        return (OpenJPAEntityManager)this.deserialize(bytes);
    }

    private Object deserialize(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    void close(EntityManager em) {
        if (em != null && em.isOpen() && em.getTransaction().isActive()) {
            em.getTransaction().rollback();
        }
        if (em != null && em.isOpen()) {
            em.close();
        }
    }

    protected abstract Class<T> getManagedType();

    protected abstract T newManagedInstance();

    protected abstract void modifyInstance(T var1);

    protected abstract Object getModifiedValue(T var1);

    protected int graphSize() {
        return 1;
    }

    protected Class<?> getSecondaryType() {
        return null;
    }

    static {
        testGlobalRefreshCount = 0;
        testGlobalBeginCount = 0;
    }

    private static class LifeListener
    extends AbstractLifecycleListener
    implements Serializable {
        private int refreshCount = 0;

        private LifeListener() {
        }

        public void afterRefresh(LifecycleEvent event) {
            ++this.refreshCount;
            testGlobalRefreshCount++;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            deserializedLifeListener = this;
        }
    }

    private static class TxListener
    extends AbstractTransactionListener
    implements Serializable {
        private int beginCount = 0;

        public void afterBegin(TransactionEvent event) {
            ++this.beginCount;
            testGlobalBeginCount++;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            deserializedTxListener = this;
        }
    }
}

