/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Collections;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.ManagedClassSubclasser;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.UnenhancedFieldAccess;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestDynamicClassRegistration
extends AbstractCachedEMFTestCase {
    private OpenJPAEntityManagerFactorySPI emf1;

    public void setUp() throws Exception {
        super.setUp();
        this.emf1 = this.createNamedEMF("empty-pu", new Object[0]);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.clear((EntityManagerFactory)this.emf1);
        this.closeEMF((EntityManagerFactory)this.emf1);
    }

    public void testEnhancedDynamicClassRegistration() throws ClassNotFoundException {
        TestDynamicClassRegistration.assertTrue((boolean)PersistenceCapable.class.isAssignableFrom(SimpleEntity.class));
        Class.forName(SimpleEntity.class.getName(), true, ((Object)((Object)this)).getClass().getClassLoader());
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf1, SimpleEntity.class);
        TestDynamicClassRegistration.assertNotNull((Object)meta);
        OpenJPAEntityManagerSPI em = this.emf1.createEntityManager();
        Query q = em.createQuery("select o from simple o");
        em.close();
    }

    public void testUnenhancedDynamicClassRegistration() {
        TestDynamicClassRegistration.assertFalse((boolean)PersistenceCapable.class.isAssignableFrom(UnenhancedFieldAccess.class));
        ManagedClassSubclasser.prepareUnenhancedClasses((OpenJPAConfiguration)this.emf1.getConfiguration(), Collections.singleton(UnenhancedFieldAccess.class), null);
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf1, UnenhancedFieldAccess.class);
        TestDynamicClassRegistration.assertNotNull((Object)meta);
        OpenJPAEntityManagerSPI em = this.emf1.createEntityManager();
        Query q = em.createQuery("select o from UnenhancedFieldAccess o");
        em.close();
    }
}

