/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.FlightSchedule;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Schedule;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestAdvAnnot
extends AnnotationTestCase {
    public TestAdvAnnot(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(Schedule.class);
        this.deleteAll(FlightSchedule.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        for (int i = 0; i < 5; ++i) {
            Calendar cal = Calendar.getInstance();
            Date date = new Date(267270L);
            Date edate = new Date(10031980L);
            String name = "AmericaWest" + i;
            String schedname = "Schedule" + i;
            FlightSchedule sched = new FlightSchedule(schedname, cal, date, edate, name);
            em.persist((Object)sched);
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testTimeTemporalAnnot() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT d.startDate FROM FlightSchedule d WHERE d.name = :name";
        Date obj = (Date)em.createQuery(query).setParameter("name", (Object)"Schedule3").getSingleResult();
        TestAdvAnnot.assertNotNull((Object)obj);
        TestAdvAnnot.assertTrue((boolean)(obj instanceof Date));
        this.endEm((EntityManager)em);
    }

    public void testCalendarTemporalAnnot() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT d FROM FlightSchedule d";
        List list = em.createQuery(query).getResultList();
        TestAdvAnnot.assertNotNull((Object)list);
        TestAdvAnnot.assertEquals((int)5, (int)list.size());
        this.endEm((EntityManager)em);
    }

    public void testUniqueConstraintAnnot() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "Update FlightSchedule f SET f.planeName = :plane WHERE f.name = :sname";
        int upd = 0;
        try {
            upd = em.createQuery(query).setParameter("plane", (Object)"AmericaWest3").setParameter("sname", (Object)"Schedule2").executeUpdate();
            TestAdvAnnot.fail((String)"Violated unique constraint rule...@Unique Constraint annotation needs to be supported");
        }
        catch (Exception e) {
            // empty catch block
        }
        TestAdvAnnot.assertNotNull((Object)upd);
        TestAdvAnnot.assertEquals((int)0, (int)upd);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

