/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbedOwner;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbedValue;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestEJBEmbedded
extends AnnotationTestCase {
    private static final String CLOB;

    public TestEJBEmbedded(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(EmbedOwner.class);
    }

    public void testEmbedded() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbedOwner owner = new EmbedOwner();
        owner.setBasic("foo");
        EmbedValue embed = new EmbedValue();
        embed.setClob(CLOB);
        embed.setBasic("bar");
        embed.setBlob("foobar".getBytes());
        embed.setOwner(owner);
        owner.setEmbed(embed);
        em.persist((Object)owner);
        int pk = owner.getPk();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        owner = (EmbedOwner)em.find(EmbedOwner.class, (Object)pk);
        TestEJBEmbedded.assertEquals((String)"foo", (String)owner.getBasic());
        embed = owner.getEmbed();
        TestEJBEmbedded.assertNotNull((Object)embed);
        TestEJBEmbedded.assertEquals((String)CLOB, (String)embed.getClob());
        TestEJBEmbedded.assertEquals((String)"bar", (String)embed.getBasic());
        TestEJBEmbedded.assertEquals((String)"foobar", (String)new String(embed.getBlob()));
        TestEJBEmbedded.assertEquals((Object)owner, (Object)embed.getOwner());
        this.endEm((EntityManager)em);
    }

    public void testNull() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbedOwner owner = new EmbedOwner();
        owner.setBasic("foo");
        em.persist((Object)owner);
        int pk = owner.getPk();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        owner = (EmbedOwner)em.find(EmbedOwner.class, (Object)pk);
        TestEJBEmbedded.assertEquals((String)"foo", (String)owner.getBasic());
        EmbedValue embed = owner.getEmbed();
        TestEJBEmbedded.assertNotNull((Object)embed);
        TestEJBEmbedded.assertNull((Object)embed.getClob());
        TestEJBEmbedded.assertNull((Object)embed.getBasic());
        TestEJBEmbedded.assertNull((Object)embed.getBlob());
        this.startTx((EntityManager)em);
    }

    static {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            buf.append('a');
        }
        CLOB = buf.toString();
    }
}

