/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest2;

public class TestOneToMany
extends AnnotationTestCase {
    public TestOneToMany(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(AnnoTest1.class);
        this.deleteAll(AnnoTest2.class);
    }

    public void testOneToMany() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        pc.getOneMany().add(new AnnoTest2(15L, "foo"));
        pc.getOneMany().add(new AnnoTest2(20L, "foobar"));
        em.persist((Object)pc);
        em.persistAll(pc.getOneMany());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        Set<AnnoTest2> many = pc.getOneMany();
        TestOneToMany.assertEquals((int)2, (int)many.size());
        block4: for (AnnoTest2 pc2 : many) {
            switch ((int)pc2.getPk1()) {
                case 15: {
                    TestOneToMany.assertEquals((String)"foo", (String)pc2.getPk2());
                    continue block4;
                }
                case 20: {
                    TestOneToMany.assertEquals((String)"foobar", (String)pc2.getPk2());
                    continue block4;
                }
            }
            TestOneToMany.fail((String)("unknown element:" + pc2.getPk1()));
        }
        this.endEm((EntityManager)em);
    }

    public void testInverseOwnerOneToMany() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc.getInverseOwnerOneMany().add(pc2);
        pc2.setOneManyOwner(pc);
        pc2 = new AnnoTest2(20L, "foobar");
        pc.getInverseOwnerOneMany().add(pc2);
        pc2.setOneManyOwner(pc);
        em.persist((Object)pc);
        em.persistAll(pc.getInverseOwnerOneMany());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        Set<AnnoTest2> many = pc.getInverseOwnerOneMany();
        TestOneToMany.assertEquals((int)2, (int)many.size());
        block4: for (AnnoTest2 pc3 : many) {
            TestOneToMany.assertEquals((Object)pc, (Object)pc3.getOneManyOwner());
            switch ((int)pc3.getPk1()) {
                case 15: {
                    TestOneToMany.assertEquals((String)"foo", (String)pc3.getPk2());
                    continue block4;
                }
                case 20: {
                    TestOneToMany.assertEquals((String)"foobar", (String)pc3.getPk2());
                    continue block4;
                }
            }
            TestOneToMany.fail((String)("unknown element:" + pc3.getPk1()));
        }
        this.endEm((EntityManager)em);
    }
}

