/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest2;

public class TestOneToOne
extends AnnotationTestCase {
    public TestOneToOne(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(AnnoTest1.class);
        this.deleteAll(AnnoTest2.class);
    }

    public void testOneToOne() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc.setOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        pc2 = pc.getOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((long)15L, (long)pc2.getPk1());
        TestOneToOne.assertEquals((String)"foo", (String)pc2.getPk2());
        this.endEm((EntityManager)em);
    }

    public void testSelfOneToOne() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest1 pc2 = new AnnoTest1(15L);
        pc.setSelfOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        pc2 = pc.getSelfOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((Object)new Long(15L), (Object)pc2.getPk());
        this.endEm((EntityManager)em);
    }

    public void testPKJoinSelfOneToOne() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest1 pc2 = new AnnoTest1(15L);
        pc.setSelfOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        pc2 = pc.getSelfOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((Object)new Long(15L), (Object)pc2.getPk());
        this.endEm((EntityManager)em);
    }

    public void testOtherTableOneToOne() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc.setOtherTableOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        pc2 = pc.getOtherTableOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((long)15L, (long)pc2.getPk1());
        TestOneToOne.assertEquals((String)"foo", (String)pc2.getPk2());
        this.endEm((EntityManager)em);
    }

    public void testInverseOneToOne() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc2.setInverseOneOne(pc);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        pc2 = pc.getInverseOwnerOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((long)15L, (long)pc2.getPk1());
        TestOneToOne.assertEquals((String)"foo", (String)pc2.getPk2());
        TestOneToOne.assertEquals((Object)pc, (Object)pc2.getInverseOneOne());
        this.endEm((EntityManager)em);
    }
}

