/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest1;

public class TestSerializedLobs
extends AnnotationTestCase {
    private static final Date DATE = new Date();

    public TestSerializedLobs(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(AnnoTest1.class);
    }

    public void testSerialized() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc1 = new AnnoTest1(1L);
        AnnoTest1 pc2 = new AnnoTest1(2L);
        pc1.setSerialized("ASDASD");
        pc2.setSerialized(DATE);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc1 = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc1));
        pc2 = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc2));
        TestSerializedLobs.assertEquals((Object)"ASDASD", (Object)pc1.getSerialized());
        TestSerializedLobs.assertEquals((Object)DATE, (Object)pc2.getSerialized());
        this.endEm((EntityManager)em);
    }

    public void testBlob() throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(1L);
        pc.setBlob("Not Null".getBytes());
        em.persist((Object)pc);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        TestSerializedLobs.assertEquals((String)"Not Null", (String)new String(pc.getBlob()));
        Connection conn = (Connection)em.getConnection();
        Statement stmnt = conn.createStatement();
        ResultSet rs = stmnt.executeQuery("SELECT BLOBVAL FROM ANNOTEST1 WHERE PK = 1");
        TestSerializedLobs.assertTrue((boolean)rs.next());
        this.endEm((EntityManager)em);
    }

    public void testClob() throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = new AnnoTest1(1L);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            buf.append((char)(97 + i % 24));
        }
        pc.setClob(buf.toString());
        em.persist((Object)pc);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        String str = pc.getClob();
        TestSerializedLobs.assertEquals((int)1000, (int)str.length());
        for (int i = 0; i < str.length(); ++i) {
            TestSerializedLobs.assertEquals((int)(97 + i % 24), (int)str.charAt(i));
        }
        this.endEm((EntityManager)em);
    }
}

