/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.NoneVersionStrategy;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest2;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest3;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbedOwner;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestVersion
extends AnnotationTestCase {
    private Object oid;
    private Object oid1;
    private Object oid2;

    public TestVersion(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        new AnnoTest1();
        new AnnoTest2();
        new AnnoTest3();
        this.deleteAll(AnnoTest1.class);
        this.deleteAll(AnnoTest2.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 test1 = new AnnoTest1();
        test1.setPk(new Long(5L));
        test1.setBasic(50);
        test1.setTransient(500);
        em.persist((Object)test1);
        AnnoTest2 test2 = new AnnoTest2();
        test2.setPk1(5L);
        test2.setPk2("bar");
        test2.setBasic("50");
        em.persist((Object)test2);
        AnnoTest3 test3 = new AnnoTest3();
        test3.setPk(new Long(3L));
        test3.setBasic2(50);
        em.persist((Object)test3);
        this.oid = em.getObjectId((Object)test1);
        this.oid1 = em.getObjectId((Object)test2);
        this.oid2 = em.getObjectId((Object)test3);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionNumeric() {
        OpenJPAEntityManager em1 = this.currentEntityManager();
        this.startTx((EntityManager)em1);
        OpenJPAEntityManager em2 = this.getEmf().createEntityManager();
        AnnoTest1 pc1 = (AnnoTest1)em1.find(AnnoTest1.class, this.oid);
        AnnoTest1 pc2 = (AnnoTest1)em2.find(AnnoTest1.class, this.oid);
        TestVersion.assertEquals((int)1, (int)pc1.getVersion());
        TestVersion.assertEquals((int)1, (int)pc2.getVersion());
        TestVersion.assertEquals((int)0, (int)pc1.getTransient());
        pc1.setBasic(75);
        this.endTx((EntityManager)em1);
        this.endEm((EntityManager)em1);
        em2.getTransaction().begin();
        pc2.setBasic(75);
        em1 = this.currentEntityManager();
        pc1 = (AnnoTest1)em1.find(AnnoTest1.class, this.oid);
        TestVersion.assertEquals((int)2, (int)pc1.getVersion());
        this.endEm((EntityManager)em1);
        try {
            em2.getTransaction().commit();
            TestVersion.fail((String)"Optimistic fail");
        }
        catch (RuntimeException re) {
        }
        catch (Exception e) {
        }
        finally {
            em2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionTimestamp() {
        OpenJPAEntityManager em1 = this.currentEntityManager();
        this.startTx((EntityManager)em1);
        OpenJPAEntityManager em2 = this.getEmf().createEntityManager();
        AnnoTest2 pc1 = (AnnoTest2)em1.find(AnnoTest2.class, this.oid1);
        AnnoTest2 pc2 = (AnnoTest2)em2.find(AnnoTest2.class, this.oid1);
        TestVersion.assertNotNull((Object)pc1.getVersion());
        TestVersion.assertEquals((Object)pc1.getVersion(), (Object)pc2.getVersion());
        pc1.setBasic("75");
        this.endTx((EntityManager)em1);
        this.endEm((EntityManager)em1);
        em2.getTransaction().begin();
        pc2.setBasic("75");
        em1 = this.currentEntityManager();
        pc1 = (AnnoTest2)em1.find(AnnoTest2.class, this.oid1);
        TestVersion.assertTrue((pc1.getVersion().compareTo(pc2.getVersion()) > 0 ? 1 : 0) != 0);
        this.endEm((EntityManager)em1);
        try {
            em2.getTransaction().commit();
            TestVersion.fail((String)"Optimistic fail");
        }
        catch (RuntimeException re) {
        }
        catch (Exception e) {
        }
        finally {
            em2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionSubclass() {
        OpenJPAEntityManager em1 = this.currentEntityManager();
        this.startTx((EntityManager)em1);
        OpenJPAEntityManager em2 = this.getEmf().createEntityManager();
        AnnoTest3 pc1 = (AnnoTest3)em1.find(AnnoTest3.class, this.oid2);
        AnnoTest3 pc2 = (AnnoTest3)em2.find(AnnoTest3.class, this.oid2);
        TestVersion.assertEquals((int)1, (int)pc1.getVersion());
        TestVersion.assertEquals((int)1, (int)pc2.getVersion());
        pc1.setBasic2(75);
        this.endTx((EntityManager)em1);
        this.endEm((EntityManager)em1);
        em2.getTransaction().begin();
        pc2.setBasic2(75);
        em1 = this.currentEntityManager();
        pc1 = (AnnoTest3)em1.find(AnnoTest3.class, this.oid2);
        TestVersion.assertEquals((int)2, (int)pc1.getVersion());
        this.endEm((EntityManager)em1);
        try {
            em2.getTransaction().commit();
            TestVersion.fail((String)"Optimistic fail");
        }
        catch (RuntimeException re) {
        }
        catch (Exception e) {
        }
        finally {
            em2.close();
        }
    }

    public void testVersionNoChange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        AnnoTest1 pc = (AnnoTest1)em.find(AnnoTest1.class, this.oid);
        TestVersion.assertEquals((int)1, (int)pc.getVersion());
        TestVersion.assertEquals((int)0, (int)pc.getTransient());
        pc.setTransient(750);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, this.oid);
        TestVersion.assertEquals((int)1, (int)pc.getVersion());
        TestVersion.assertEquals((int)0, (int)pc.getTransient());
        this.endEm((EntityManager)em);
    }

    public void testNoDefaultVersionWithoutFieldOrColumn() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ClassMapping cls = ((JDBCConfigurationImpl)((OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)pm)).getConfiguration()).getMappingRepositoryInstance().getMapping(EmbedOwner.class, null, true);
        TestVersion.assertEquals((Object)NoneVersionStrategy.getInstance(), (Object)cls.getVersion().getStrategy());
        TestVersion.assertEquals((int)0, (int)cls.getVersion().getColumns().length);
        this.endEm((EntityManager)pm);
    }

    public void testVersionWithField() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ClassMapping cls = ((JDBCConfigurationImpl)((OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)pm)).getConfiguration()).getMappingRepositoryInstance().getMapping(AnnoTest1.class, null, true);
        TestVersion.assertTrue((NoneVersionStrategy.getInstance() != cls.getVersion().getStrategy() ? 1 : 0) != 0);
        TestVersion.assertEquals((int)1, (int)cls.getVersion().getColumns().length);
        this.endEm((EntityManager)pm);
    }
}

