/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations.xml;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.FlatClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.FullClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.VerticalClassStrategy;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.annotations.xml.DerivedA;
import org.apache.openjpa.persistence.annotations.xml.DerivedB;
import org.apache.openjpa.persistence.annotations.xml.EntityA;
import org.apache.openjpa.persistence.annotations.xml.EntityB;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMetaDataComplete
extends SingleEMFTestCase {
    private static OpenJPAEntityManagerFactorySPI oemf;
    private static ClassMetaData entityA;
    private static ClassMetaData entityB;
    private static ClassMetaData derivedA;
    private static ClassMetaData derivedB;
    private static int currentTest;

    @Override
    public void setUp() throws Exception {
        ++currentTest;
        if (oemf == null) {
            super.setUp(EntityA.class, EntityB.class, DerivedA.class, DerivedB.class);
            oemf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.emf);
            MetaDataRepository repos = oemf.getConfiguration().getMetaDataRepositoryInstance();
            entityA = repos.getMetaData(EntityA.class, null, true);
            entityB = repos.getMetaData(EntityB.class, null, true);
            derivedA = repos.getMetaData(DerivedA.class, null, true);
            derivedB = repos.getMetaData(DerivedB.class, null, true);
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (currentTest >= 6) {
            this.closeEMF((EntityManagerFactory)oemf);
            oemf = null;
            super.tearDown();
            entityA = null;
            entityB = null;
            derivedA = null;
            derivedB = null;
        }
    }

    @Override
    protected String getPersistenceUnitName() {
        return "test-metadata-complete";
    }

    public void testIgnoresClassAnnotationIfMetaDataComplete() {
        TestMetaDataComplete.assertEquals(FullClassStrategy.class, ((ClassMapping)entityA).getStrategy().getClass());
        TestMetaDataComplete.assertEquals(VerticalClassStrategy.class, ((ClassMapping)derivedA).getStrategy().getClass());
    }

    public void testProcessesClassAnnotationIfMetaDataIsNotComplete() {
        TestMetaDataComplete.assertEquals(FullClassStrategy.class, ((ClassMapping)entityB).getStrategy().getClass());
        TestMetaDataComplete.assertEquals(FlatClassStrategy.class, ((ClassMapping)derivedB).getStrategy().getClass());
    }

    public void testIgnoresFieldAnnotationIfMetaDataComplete() {
        int valueStrategyA = entityA.getField("id").getValueStrategy();
        TestMetaDataComplete.assertEquals((int)2, (int)valueStrategyA);
    }

    public void testProcessesFieldAnnotationIfMetaDataIsNotComplete() {
        int valueStrategyB = entityB.getField("id").getValueStrategy();
        TestMetaDataComplete.assertEquals((int)3, (int)valueStrategyB);
    }

    public void testIgnoresNamedQueryIfMetaDataComplete() {
        String namedQuery = "DerivedA.SelectAll";
        try {
            oemf.createEntityManager().createNamedQuery(namedQuery);
            TestMetaDataComplete.fail((String)("Expected not to find NamedQuery [" + namedQuery + "]"));
        }
        catch (ArgumentException e) {
            TestMetaDataComplete.assertTrue((boolean)e.getMessage().contains(namedQuery));
        }
    }

    public void testProcessesNamedQueryIfMetaDataIsNotComplete() {
        oemf.createEntityManager().createNamedQuery("EntityB.SelectOne");
        oemf.createEntityManager().createNamedQuery("EntityB.SelectAll");
    }

    static {
        currentTest = 0;
    }
}

