/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.blob;

import java.util.List;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.blob.BlobEntity;
import org.apache.openjpa.persistence.query.QueryBuilder;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBlobs
extends SingleEMFTestCase {
    private int _populatedId = 1;
    private int _nullLobId = 2;
    private int _nullBlobId = 3;
    private int _nullBothId = 4;
    QueryBuilder qb = null;

    @Override
    public void setUp() {
        super.setUp(BlobEntity.class, "Retain data after test run");
        this.cleanup();
        this.populate();
        this.qb = this.emf.getDynamicQueryBuilder();
    }

    protected void cleanup() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE from BlobEntity").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    protected void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        BlobEntity be = new BlobEntity();
        be.setId(this._populatedId);
        be.setLobField("abcdef");
        be.setBlobField("abcdef".getBytes());
        em.persist((Object)be);
        be = new BlobEntity();
        be.setId(this._nullLobId);
        be.setLobField(null);
        be.setBlobField("abcdef".getBytes());
        em.persist((Object)be);
        be = new BlobEntity();
        be.setId(this._nullBlobId);
        be.setLobField("abcdef");
        be.setBlobField(null);
        em.persist((Object)be);
        be = new BlobEntity();
        be.setId(this._nullBothId);
        be.setLobField(null);
        be.setBlobField(null);
        em.persist((Object)be);
        tran.commit();
        em.close();
    }

    public void testNotNullBlobQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery q = em.createQuery("SELECT e.id FROM BlobEntity e where e.blobField IS NOT NULL", Integer.class);
        List ids = q.getResultList();
        TestBlobs.assertTrue((boolean)ids.contains(this._populatedId));
        TestBlobs.assertTrue((boolean)ids.contains(this._nullLobId));
        TestBlobs.assertFalse((boolean)ids.contains(this._nullBlobId));
        TestBlobs.assertFalse((boolean)ids.contains(this._nullBothId));
        em.close();
    }

    public void testNullBlobQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery q = em.createQuery("SELECT e.id FROM BlobEntity e where e.blobField IS NULL", Integer.class);
        List ids = q.getResultList();
        TestBlobs.assertFalse((boolean)ids.contains(this._populatedId));
        TestBlobs.assertFalse((boolean)ids.contains(this._nullLobId));
        TestBlobs.assertTrue((boolean)ids.contains(this._nullBlobId));
        TestBlobs.assertTrue((boolean)ids.contains(this._nullBothId));
        em.close();
    }

    public void testNotNullLobQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery q = em.createQuery("SELECT e.id FROM BlobEntity e where e.lobField IS NOT NULL", Integer.class);
        List ids = q.getResultList();
        TestBlobs.assertTrue((boolean)ids.contains(this._populatedId));
        TestBlobs.assertFalse((boolean)ids.contains(this._nullLobId));
        TestBlobs.assertTrue((boolean)ids.contains(this._nullBlobId));
        TestBlobs.assertFalse((boolean)ids.contains(this._nullBothId));
        em.close();
    }

    public void testNullLobQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery q = em.createQuery("SELECT e.id FROM BlobEntity e where e.lobField IS NULL", Integer.class);
        List ids = q.getResultList();
        TestBlobs.assertFalse((boolean)ids.contains(this._populatedId));
        TestBlobs.assertTrue((boolean)ids.contains(this._nullLobId));
        TestBlobs.assertFalse((boolean)ids.contains(this._nullBlobId));
        TestBlobs.assertTrue((boolean)ids.contains(this._nullBothId));
        em.close();
    }
}

