/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cache;
import org.apache.openjpa.datacache.ConcurrentDataCache;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.cache.jpa.AbstractCacheModeTestCase;
import org.apache.openjpa.persistence.test.FilteringJDBCListener;

public class TestCacheModeAll
extends AbstractCacheModeTestCase {
    protected static Cache cache = null;
    private static List<String> sql = new ArrayList<String>();
    private static JDBCListener listener;
    private static Class<?>[] expectedInCache;
    private static Class<?>[] expectedNotInCache;

    @Override
    public OpenJPAEntityManagerFactorySPI getEntityManagerFactory() {
        if (emf == null) {
            emf = this.createEntityManagerFactory("cache-mode-all", null);
            TestCacheModeAll.assertNotNull((Object)emf);
            ConcurrentDataCache dataCache = (ConcurrentDataCache)emf.getConfiguration().getDataCacheManagerInstance().getDataCache("default");
            TestCacheModeAll.assertNotNull((Object)dataCache);
            TestCacheModeAll.assertEquals((int)1000, (int)dataCache.getCacheSize());
            TestCacheModeAll.assertEquals((String)"true", (String)emf.getConfiguration().getDataCache());
            cache = emf.getCache();
            TestCacheModeAll.assertNotNull((Object)cache);
        }
        return emf;
    }

    @Override
    public JDBCListener getListener() {
        if (listener == null) {
            listener = new FilteringJDBCListener(this.getSql());
        }
        return listener;
    }

    @Override
    public List<String> getSql() {
        return sql;
    }

    public void testCacheables() {
        this.assertCacheables(cache, true);
    }

    public void testUncacheables() {
        this.assertUncacheables(cache, true);
    }

    public void testUnspecified() {
        this.assertUnspecified(cache, true);
    }

    @Override
    protected Class<?>[] getExpectedInCache() {
        return expectedInCache;
    }

    @Override
    protected Class<?>[] getExpectedNotInCache() {
        return expectedNotInCache;
    }

    static {
        expectedInCache = persistentTypes;
        expectedNotInCache = new Class[0];
    }
}

