/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cache;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.cache.jpa.AbstractCacheModeTestCase;
import org.apache.openjpa.persistence.cache.jpa.model.CacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.NegatedUncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UnspecifiedEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlCacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlUncacheableEntity;
import org.apache.openjpa.persistence.test.FilteringJDBCListener;

public class TestCacheModeDisableSelective
extends AbstractCacheModeTestCase {
    protected static Cache cache = null;
    private static List<String> sql = new ArrayList<String>();
    private static JDBCListener listener;
    private static Class<?>[] expectedInCache;
    private static Class<?>[] expectedNotInCache;

    @Override
    public OpenJPAEntityManagerFactorySPI getEntityManagerFactory() {
        if (emf == null) {
            emf = this.createEntityManagerFactory("cache-mode-disable", null);
            TestCacheModeDisableSelective.assertNotNull((Object)emf);
            TestCacheModeDisableSelective.assertEquals((String)"true", (String)emf.getConfiguration().getDataCache());
            cache = emf.getCache();
            TestCacheModeDisableSelective.assertNotNull((Object)cache);
        }
        return emf;
    }

    @Override
    public JDBCListener getListener() {
        if (listener == null) {
            listener = new FilteringJDBCListener(this.getSql());
        }
        return listener;
    }

    @Override
    public List<String> getSql() {
        return sql;
    }

    public void testCacheables() {
        this.assertCacheables(cache, true);
    }

    public void testUncacheables() {
        this.assertUncacheables(cache, false);
    }

    public void testUnspecified() {
        this.assertUnspecified(cache, true);
    }

    @Override
    protected Class<?>[] getExpectedInCache() {
        return expectedInCache;
    }

    @Override
    protected Class<?>[] getExpectedNotInCache() {
        return expectedNotInCache;
    }

    static {
        expectedInCache = new Class[]{CacheableEntity.class, XmlCacheableEntity.class, NegatedUncacheableEntity.class, UnspecifiedEntity.class};
        expectedNotInCache = new Class[]{UncacheableEntity.class, XmlUncacheableEntity.class};
    }
}

