/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.callbacks.Message;
import org.apache.openjpa.persistence.callbacks.MessageListenerImpl;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMessageListeners
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(DROP_TABLES);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "listener-pu";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateInPrePersist() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            MessageListenerImpl.resetCounters();
            Message message = new Message("Hello Persistence!");
            TestMessageListeners.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListeners.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(1, 0, 0, 0, 0, 0, 0);
            TestMessageListeners.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListeners.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            em.flush();
            this.assertStatus(1, 1, 0, 0, 0, 0, 0);
            em.clear();
            OpenJPAQuery q = em.createQuery("select m from Message m where m.id=" + message.getId());
            Message m = (Message)q.getSingleResult();
            TestMessageListeners.assertEquals((String)"Test first expected message.", (String)"Hello Persistence!", (String)m.getMessage());
            TestMessageListeners.assertNotNull((String)"Test message's created field being set.", (Object)m.getCreated());
            TestMessageListeners.assertNotNull((String)"Test message's updated field being set.", (Object)m.getUpdated());
            this.assertStatus(1, 1, 0, 0, 0, 0, 1);
            em.getTransaction().commit();
            this.assertStatus(1, 1, 0, 0, 0, 0, 1);
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateInPreUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            MessageListenerImpl.resetCounters();
            Message message = new Message("Hello Persistence!");
            TestMessageListeners.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListeners.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(1, 0, 0, 0, 0, 0, 0);
            TestMessageListeners.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListeners.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            OpenJPAQuery q = em.createQuery("select m from Message m where m.id=" + message.getId());
            Message m = (Message)q.getSingleResult();
            TestMessageListeners.assertEquals((String)"Test first expected message.", (String)"Hello Persistence!", (String)m.getMessage());
            TestMessageListeners.assertNotNull((String)"Test message's created field being set.", (Object)m.getCreated());
            TestMessageListeners.assertNotNull((String)"Test message's updated field being set.", (Object)m.getUpdated());
            this.assertStatus(1, 1, 0, 0, 0, 0, 0);
            message = new Message("Hello Persistence 2!");
            TestMessageListeners.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListeners.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(2, 1, 0, 0, 0, 0, 0);
            TestMessageListeners.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListeners.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            em.getTransaction().commit();
            this.assertStatus(2, 2, 0, 0, 0, 0, 0);
            em.getTransaction().begin();
            message = (Message)em.find(Message.class, (Object)message.getId());
            message.setMessage("Update field and trigger pre/postUpdate");
            em.getTransaction().commit();
            this.assertStatus(2, 2, 1, 1, 0, 0, 0);
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private void assertStatus(int prePersist, int postPersist, int preUpdate, int postUpdate, int preRemove, int postRemove, int postLoad) {
        TestMessageListeners.assertEquals((int)prePersist, (int)MessageListenerImpl.prePersistCount);
        TestMessageListeners.assertEquals((int)postPersist, (int)MessageListenerImpl.postPersistCount);
        TestMessageListeners.assertEquals((int)preUpdate, (int)MessageListenerImpl.preUpdateCount);
        TestMessageListeners.assertEquals((int)postUpdate, (int)MessageListenerImpl.postUpdateCount);
        TestMessageListeners.assertEquals((int)preRemove, (int)MessageListenerImpl.preRemoveCount);
        TestMessageListeners.assertEquals((int)postRemove, (int)MessageListenerImpl.postRemoveCount);
        TestMessageListeners.assertEquals((int)postLoad, (int)MessageListenerImpl.postLoadCount);
    }
}

