/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.callbacks.AddListenerEntity;
import org.apache.openjpa.persistence.callbacks.ListenerInEntity;
import org.apache.openjpa.persistence.callbacks.PerInstanceListener;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultiEmEntityListeners
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, ListenerInEntity.class, AddListenerEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListenerInEntity1() {
        OpenJPAEntityManagerSPI em1 = null;
        OpenJPAEntityManagerSPI em2 = null;
        try {
            em1 = this.emf.createEntityManager();
            em2 = this.emf.createEntityManager();
            ListenerInEntity o1 = new ListenerInEntity();
            ListenerInEntity o2 = new ListenerInEntity();
            em1.getTransaction().begin();
            em1.persist((Object)o1);
            this.assertListenerInEntityStatus(o1, 1, 0, 0, 0, 0, 0, 0);
            this.assertListenerInEntityStatus(o2, 0, 0, 0, 0, 0, 0, 0);
            em2.getTransaction().begin();
            em2.persist((Object)o2);
            this.assertListenerInEntityStatus(o1, 1, 0, 0, 0, 0, 0, 0);
            this.assertListenerInEntityStatus(o2, 1, 0, 0, 0, 0, 0, 0);
            em2.getTransaction().commit();
            long id2 = o2.getId();
            this.assertListenerInEntityStatus(o1, 1, 0, 0, 0, 0, 0, 0);
            this.assertListenerInEntityStatus(o2, 1, 1, 0, 0, 0, 0, 0);
            em1.getTransaction().commit();
            long id1 = o1.getId();
            this.assertListenerInEntityStatus(o1, 1, 1, 0, 0, 0, 0, 0);
            this.assertListenerInEntityStatus(o2, 1, 1, 0, 0, 0, 0, 0);
            em1.clear();
            ListenerInEntity fo1 = (ListenerInEntity)em1.find(ListenerInEntity.class, (Object)id1);
            TestMultiEmEntityListeners.assertNotNull((Object)fo1);
            this.assertListenerInEntityStatus(fo1, 0, 0, 0, 0, 0, 0, 1);
            em2.clear();
            ListenerInEntity fo2 = (ListenerInEntity)em2.find(ListenerInEntity.class, (Object)id2);
            TestMultiEmEntityListeners.assertNotNull((Object)fo2);
            this.assertListenerInEntityStatus(fo1, 0, 0, 0, 0, 0, 0, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 0, 0, 0, 0, 1);
            em1.getTransaction().begin();
            fo1.setValue(fo1.getValue() + 1);
            em1.flush();
            this.assertListenerInEntityStatus(fo1, 0, 0, 1, 1, 0, 0, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 0, 0, 0, 0, 1);
            em2.getTransaction().begin();
            fo2.setValue(fo2.getValue() + 1);
            em2.flush();
            this.assertListenerInEntityStatus(fo1, 0, 0, 1, 1, 0, 0, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 1, 1, 0, 0, 1);
            em1.remove((Object)fo1);
            this.assertListenerInEntityStatus(fo1, 0, 0, 1, 1, 1, 0, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 1, 1, 0, 0, 1);
            em2.remove((Object)fo2);
            this.assertListenerInEntityStatus(fo1, 0, 0, 1, 1, 1, 0, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 1, 1, 1, 0, 1);
            em1.getTransaction().commit();
            this.assertListenerInEntityStatus(fo1, 0, 0, 1, 1, 1, 1, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 1, 1, 1, 0, 1);
            em2.getTransaction().commit();
            this.assertListenerInEntityStatus(fo1, 0, 0, 1, 1, 1, 1, 1);
            this.assertListenerInEntityStatus(fo2, 0, 0, 1, 1, 1, 1, 1);
            em1.close();
            em2.close();
        }
        finally {
            if (em1 != null && em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em1 != null && em1.isOpen()) {
                em1.close();
            }
            if (em2 != null && em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            if (em2 != null && em2.isOpen()) {
                em2.close();
            }
        }
    }

    private void assertListenerInEntityStatus(ListenerInEntity l, int prePersist, int postPersist, int preUpdate, int postUpdate, int preRemove, int postRemove, int postLoad) {
        TestMultiEmEntityListeners.assertEquals((int)prePersist, (int)l.prePersistCount);
        TestMultiEmEntityListeners.assertEquals((int)postPersist, (int)l.postPersistCount);
        TestMultiEmEntityListeners.assertEquals((int)preUpdate, (int)l.preUpdateCount);
        TestMultiEmEntityListeners.assertEquals((int)postUpdate, (int)l.postUpdateCount);
        TestMultiEmEntityListeners.assertEquals((int)preRemove, (int)l.preRemoveCount);
        TestMultiEmEntityListeners.assertEquals((int)postRemove, (int)l.postRemoveCount);
        TestMultiEmEntityListeners.assertEquals((int)postLoad, (int)l.postLoadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddListenerEntity1() {
        OpenJPAEntityManagerSPI em1 = null;
        OpenJPAEntityManagerSPI em2 = null;
        try {
            em1 = this.emf.createEntityManager();
            PerInstanceListener l1 = new PerInstanceListener();
            em1.addLifecycleListener((Object)l1, (Class[])null);
            em2 = this.emf.createEntityManager();
            PerInstanceListener l2 = new PerInstanceListener();
            em2.addLifecycleListener((Object)l2, (Class[])null);
            AddListenerEntity o1 = new AddListenerEntity();
            AddListenerEntity o2 = new AddListenerEntity();
            em1.getTransaction().begin();
            em1.persist((Object)o1);
            this.assertAddListenerEntityStatus(l1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0);
            this.assertAddListenerEntityStatus(l2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            em2.getTransaction().begin();
            em2.persist((Object)o2);
            this.assertAddListenerEntityStatus(l1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0);
            em2.getTransaction().commit();
            this.assertAddListenerEntityStatus(l1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0);
            long id2 = o2.getId();
            em1.getTransaction().commit();
            this.assertAddListenerEntityStatus(l1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0);
            long id1 = o1.getId();
            em1.clear();
            AddListenerEntity fo1 = (AddListenerEntity)em1.find(AddListenerEntity.class, (Object)id1);
            this.assertAddListenerEntityStatus(l1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0);
            TestMultiEmEntityListeners.assertNotNull((Object)fo1);
            em2.clear();
            AddListenerEntity fo2 = (AddListenerEntity)em2.find(AddListenerEntity.class, (Object)id2);
            this.assertAddListenerEntityStatus(l1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0);
            TestMultiEmEntityListeners.assertNotNull((Object)fo2);
            em1.getTransaction().begin();
            fo1.setValue(fo1.getValue() + 1);
            this.assertAddListenerEntityStatus(l1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0);
            em1.flush();
            this.assertAddListenerEntityStatus(l1, 1, 1, 2, 2, 1, 0, 1, 1, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0);
            em2.getTransaction().begin();
            fo2.setValue(fo2.getValue() + 1);
            this.assertAddListenerEntityStatus(l1, 1, 1, 2, 2, 1, 0, 1, 1, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0);
            em2.flush();
            this.assertAddListenerEntityStatus(l1, 1, 1, 2, 2, 1, 0, 1, 1, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 2, 2, 1, 0, 1, 1, 0, 0);
            em2.remove((Object)fo2);
            this.assertAddListenerEntityStatus(l1, 1, 1, 2, 2, 1, 0, 1, 1, 0, 0);
            this.assertAddListenerEntityStatus(l2, 1, 1, 2, 2, 1, 0, 1, 1, 1, 1);
            em1.remove((Object)fo1);
            this.assertAddListenerEntityStatus(l1, 1, 1, 2, 2, 1, 0, 1, 1, 1, 1);
            this.assertAddListenerEntityStatus(l2, 1, 1, 2, 2, 1, 0, 1, 1, 1, 1);
            em1.getTransaction().commit();
            em2.getTransaction().commit();
            em1.close();
            em2.close();
        }
        finally {
            if (em1 != null && em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em1 != null && em1.isOpen()) {
                em1.close();
            }
            if (em2 != null && em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            if (em2 != null && em2.isOpen()) {
                em2.close();
            }
        }
    }

    private void assertAddListenerEntityStatus(PerInstanceListener l, int beforePersist, int afterPersist, int beforeStore, int afterStore, int afterLoad, int afterRefresh, int beforeDirty, int afterDirty, int beforeDelete, int afterDelete) {
        TestMultiEmEntityListeners.assertEquals((int)beforePersist, (int)l.beforePersist);
        TestMultiEmEntityListeners.assertEquals((int)afterPersist, (int)l.afterPersist);
        TestMultiEmEntityListeners.assertEquals((int)beforeStore, (int)l.beforeStore);
        TestMultiEmEntityListeners.assertEquals((int)afterStore, (int)l.afterStore);
        TestMultiEmEntityListeners.assertEquals((int)afterLoad, (int)l.afterLoad);
        TestMultiEmEntityListeners.assertEquals((int)afterRefresh, (int)l.afterRefresh);
        TestMultiEmEntityListeners.assertEquals((int)beforeDirty, (int)l.beforeDirty);
        TestMultiEmEntityListeners.assertEquals((int)afterDirty, (int)l.afterDirty);
        TestMultiEmEntityListeners.assertEquals((int)beforeDelete, (int)l.beforeDelete);
        TestMultiEmEntityListeners.assertEquals((int)afterDelete, (int)l.afterDelete);
    }
}

