/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.callbacks.PostPersistEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPostPersistCallback
extends SingleEMFTestCase {
    public void testPostPersistCalledAfterFlush() {
        super.setUp(CLEAR_TABLES, PostPersistEntity.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PostPersistEntity pc = new PostPersistEntity();
        em.persist((Object)pc);
        TestPostPersistCallback.assertEquals((int)0, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)0L, (long)pc.idOnCallback);
        em.flush();
        TestPostPersistCallback.assertFalse((pc.getId() == 0L ? 1 : 0) != 0);
        TestPostPersistCallback.assertEquals((int)1, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)pc.getId(), (long)pc.idOnCallback);
        em.getTransaction().commit();
        TestPostPersistCallback.assertFalse((pc.getId() == 0L ? 1 : 0) != 0);
        TestPostPersistCallback.assertEquals((int)1, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)pc.getId(), (long)pc.idOnCallback);
        em.close();
    }

    public void testPostPersistCalledAfterCommit() {
        super.setUp(CLEAR_TABLES, PostPersistEntity.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PostPersistEntity pc = new PostPersistEntity();
        em.persist((Object)pc);
        TestPostPersistCallback.assertEquals((int)0, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)0L, (long)pc.idOnCallback);
        em.getTransaction().commit();
        TestPostPersistCallback.assertFalse((pc.getId() == 0L ? 1 : 0) != 0);
        TestPostPersistCallback.assertEquals((int)1, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)pc.getId(), (long)pc.idOnCallback);
        em.close();
    }

    public void testPostPersistCalledAfterPersist() {
        super.setUp(CLEAR_TABLES, PostPersistEntity.class, "openjpa.Callbacks", "PostPersistCallbackImmediate=true");
        TestPostPersistCallback.assertTrue((boolean)this.emf.getConfiguration().getCallbackOptionsInstance().getPostPersistCallbackImmediate());
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PostPersistEntity pc = new PostPersistEntity();
        em.persist((Object)pc);
        TestPostPersistCallback.assertEquals((int)1, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)pc.getId(), (long)pc.idOnCallback);
        em.getTransaction().commit();
        TestPostPersistCallback.assertEquals((int)1, (int)pc.postPersistCallbackCount);
        TestPostPersistCallback.assertEquals((long)pc.getId(), (long)pc.idOnCallback);
        em.close();
    }
}

