/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cascade;

import javax.persistence.RollbackException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.cascade.CascadePersistEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestCascadePersist
extends SQLListenerTestCase {
    @Override
    public void setUp() throws Exception {
        this.setUp(DROP_TABLES, CascadePersistEntity.class, "openjpa.Compatibility", "CheckDatabaseForCascadePersistToDetachedEntity=false");
    }

    public void testCascadePersistToDetachedFailure() {
        long startId = System.currentTimeMillis();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CascadePersistEntity cpe1 = new CascadePersistEntity(startId);
        em.persist((Object)cpe1);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        CascadePersistEntity cpe2 = new CascadePersistEntity(startId + 1L);
        CascadePersistEntity cpe3 = new CascadePersistEntity(startId);
        cpe2.setOther(cpe3);
        em.persist((Object)cpe2);
        try {
            em.getTransaction().commit();
        }
        catch (RollbackException re) {
            // empty catch block
        }
    }

    public void testCascadePersistToManagedEntity() {
        long startId = System.currentTimeMillis();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CascadePersistEntity cpe1 = new CascadePersistEntity(startId);
        em.persist((Object)cpe1);
        em.flush();
        CascadePersistEntity cpe2 = new CascadePersistEntity(startId + 1L);
        cpe2.setOther(cpe1);
        em.persist((Object)cpe2);
        em.getTransaction().commit();
    }

    public void testCascaseExtraneousSQL() {
        long id = System.currentTimeMillis();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CascadePersistEntity cpe = new CascadePersistEntity(id);
        CascadePersistEntity cpe2 = new CascadePersistEntity(id + 1L);
        cpe.setOther(cpe2);
        this.resetSQL();
        em.persist((Object)cpe);
        em.getTransaction().commit();
        em.close();
        this.assertNotSQL("SELECT .*");
    }
}

