/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cascade;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.cascade.Edge;
import org.apache.openjpa.persistence.cascade.Vertex;
import org.apache.openjpa.persistence.cascade.VertexType;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultiCascadePersist
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        this.setUp(DROP_TABLES, Vertex.class, VertexType.class, Edge.class);
    }

    public void testSingleTransaction() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityTransaction tx = em.getTransaction();
        tx.begin();
        em.flush();
        VertexType defaultType = new VertexType("default");
        VertexType specialType = new VertexType("special");
        em.persist((Object)defaultType);
        em.persist((Object)specialType);
        Vertex src = new Vertex(defaultType);
        Vertex target = new Vertex(specialType);
        Edge t = src.newEdge(target);
        TestMultiCascadePersist.assertNotNull((Object)t);
        em.persist((Object)src);
        tx.commit();
        TypedQuery q = em.createQuery("SELECT t FROM Edge t", Edge.class);
        List resultList = q.getResultList();
        TestMultiCascadePersist.assertEquals((int)1, (int)resultList.size());
        TestMultiCascadePersist.assertEquals((int)2, (int)this.findAllVertexType((EntityManager)em).size());
        if (this.emf.getConfiguration().getCompatibilityInstance().getResetFlushFlagForCascadePersist()) {
            TestMultiCascadePersist.assertEquals((int)2, (int)this.findAllVertex((EntityManager)em).size());
        } else {
            TestMultiCascadePersist.assertEquals((int)1, (int)this.findAllVertex((EntityManager)em).size());
        }
    }

    public VertexType findVertexTypeByName(EntityManager em, String name) {
        try {
            TypedQuery query = em.createNamedQuery("VertexType.findByName", VertexType.class);
            query.setParameter(1, (Object)name);
            return (VertexType)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<VertexType> findAllVertexType(EntityManager em) {
        try {
            TypedQuery query = em.createNamedQuery("VertexType.findAll", VertexType.class);
            return query.getResultList();
        }
        catch (NoResultException nre) {
            return Collections.emptyList();
        }
    }

    public List<Vertex> findAllVertex(EntityManager em) {
        try {
            TypedQuery query = em.createNamedQuery("Vertex.findAll", Vertex.class);
            return query.getResultList();
        }
        catch (NoResultException nre) {
            return Collections.emptyList();
        }
    }
}

