/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cascade.pudefault;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityA01;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityA02;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityAE01;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityB;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPUDefaultCascadePersist
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(PUDEntityA01.class, PUDEntityA02.class, PUDEntityAE01.class, PUDEntityB.class, CLEAR_TABLES);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "TestPUDefaultCascadePersist";
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2M() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColM2M().add(b);
            }
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        em = this.emf.createEntityManager();
        try {
            PUDEntityA01 f_entity = (PUDEntityA01)em.find(PUDEntityA01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertEquals((int)10, (int)f_entity.getColM2M().size());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2M() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColO2M().add(b);
            }
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA01 f_entity = (PUDEntityA01)em.find(PUDEntityA01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertEquals((int)10, (int)f_entity.getColO2M().size());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2O() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setO2o(b);
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA01 f_entity = (PUDEntityA01)em.find(PUDEntityA01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertNotNull((Object)entity.getO2o());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2O() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setM2o(b);
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA01 f_entity = (PUDEntityA01)em.find(PUDEntityA01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertNotNull((Object)entity.getM2o());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2MWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColM2M().add(b);
            }
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityAE01 f_entity = (PUDEntityAE01)em.find(PUDEntityAE01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertEquals((int)10, (int)f_entity.getColM2M().size());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2MWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColO2M().add(b);
            }
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityAE01 f_entity = (PUDEntityAE01)em.find(PUDEntityAE01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertEquals((int)10, (int)f_entity.getColO2M().size());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2OWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setO2o(b);
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityAE01 f_entity = (PUDEntityAE01)em.find(PUDEntityAE01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertNotNull((Object)entity.getO2o());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2OWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setM2o(b);
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityAE01 f_entity = (PUDEntityAE01)em.find(PUDEntityAE01.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertNotNull((Object)entity.getM2o());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2MEmbbedRel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA02 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA02();
            entity.setStrData("PUDEntityA02");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getEmb().getColM2M().add(b);
            }
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA02 f_entity = (PUDEntityA02)em.find(PUDEntityA02.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertEquals((int)10, (int)f_entity.getEmb().getColM2M().size());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2MEmbbedRel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA02 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA02();
            entity.setStrData("PUDEntityA02");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getEmb().getColO2M().add(b);
            }
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA02 f_entity = (PUDEntityA02)em.find(PUDEntityA02.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertEquals((int)10, (int)f_entity.getEmb().getColO2M().size());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2OEmbbedRel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA02 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA02();
            entity.setStrData("PUDEntityA02");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.getEmb().setO2o(b);
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA02 f_entity = (PUDEntityA02)em.find(PUDEntityA02.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertNotNull((Object)entity.getEmb().getO2o());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2OEmbbedRel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA02 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA02();
            entity.setStrData("PUDEntityA02");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.getEmb().setM2o(b);
            em.persist((Object)entity);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
        em = this.emf.createEntityManager();
        try {
            PUDEntityA02 f_entity = (PUDEntityA02)em.find(PUDEntityA02.class, (Object)entity.getId());
            TestPUDefaultCascadePersist.assertNotNull((Object)f_entity);
            TestPUDefaultCascadePersist.assertNotSame((Object)entity, (Object)f_entity);
            TestPUDefaultCascadePersist.assertNotNull((Object)entity.getEmb().getM2o());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }
}

