/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.REUtil;

public abstract class AbstractTestCase
extends AbstractCachedEMFTestCase {
    private String persistenceXmlResource;
    private Map<Map, OpenJPAEntityManagerFactory> emfs = new HashMap<Map, OpenJPAEntityManagerFactory>();
    private OpenJPAEntityManager currentEntityManager;
    private Object[] props;
    protected String multiThreadExecuting = null;
    protected boolean inTimeoutThread = false;

    public AbstractTestCase(String name, String s) {
        this.setName(name);
        this.persistenceXmlResource = this.computePersistenceXmlResource(s);
    }

    protected void setUp(Object ... props) throws Exception {
        super.setUp();
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            for (OpenJPAEntityManagerFactory emf : this.emfs.values()) {
                try {
                    this.closeEMF((EntityManagerFactory)emf);
                    emf = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public AbstractTestCase() {
    }

    public AbstractTestCase(String name) {
        this.setName(name);
    }

    protected String computePersistenceXmlResource(String s) {
        String resourceName = ((Object)((Object)this)).getClass().getPackage().getName().replaceAll("\\.", "/");
        resourceName = resourceName + "/common/apps/META-INF/persistence.xml";
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        if (resource != null) {
            return resourceName;
        }
        return this.defaultPersistenceXmlResource();
    }

    protected String defaultPersistenceXmlResource() {
        return "org/apache/openjpa/persistence/common/apps/META-INF/persistence.xml";
    }

    protected OpenJPAStateManager getStateManager(Object obj, EntityManager em) {
        return JPAFacadeHelper.toBroker((EntityManager)em).getStateManager(obj);
    }

    protected int deleteAll(Class type, EntityManager em) {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManager)em, (Class)type);
        if (meta != null) {
            return em.createQuery("delete from " + meta.getTypeAlias()).executeUpdate();
        }
        return -1;
    }

    protected int deleteAll(Class ... types) {
        OpenJPAEntityManager em = this.getEmf().createEntityManager();
        em.getTransaction().begin();
        int ret = 0;
        for (Class type : types) {
            ret += this.deleteAll(type, (EntityManager)em);
        }
        em.getTransaction().commit();
        em.close();
        return ret;
    }

    protected OpenJPAEntityManagerFactory getEmf(Map map) {
        if (map == null) {
            map = new HashMap();
        }
        ArrayList keys = new ArrayList();
        for (Object key : map.keySet()) {
            if (!key.toString().startsWith("kodo")) continue;
            keys.add(key);
        }
        if (keys.size() > 0) {
            throw new IllegalArgumentException("kodo-prefixed properties must be converted to openjpa. Properties: " + keys);
        }
        this.addProperties(map);
        OpenJPAEntityManagerFactory emf = this.emfs.get(map);
        if (emf != null) {
            return emf;
        }
        if (this.props != null) {
            Object[] propsAndMap = new Object[this.props.length + map.size() * 2];
            System.arraycopy(this.props, 0, propsAndMap, 0, this.props.length);
            int i = this.props.length;
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry mapEntry = o = i$.next();
                propsAndMap[i++] = mapEntry.getKey();
                propsAndMap[i++] = mapEntry.getValue();
            }
            emf = this.createEMF(propsAndMap);
        } else {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"TestConv", (String)this.persistenceXmlResource, map);
        }
        this.emfs.put(map, emf);
        return emf;
    }

    protected void addProperties(Map map) {
        if (!map.containsKey("openjpa.jdbc.SynchronizeMappings")) {
            map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='add,deleteTableContents')");
        }
    }

    protected OpenJPAEntityManagerFactory getEmf() {
        HashMap m = new HashMap();
        return this.getEmf(m);
    }

    protected BrokerFactory getBrokerFactory() {
        return JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.getEmf());
    }

    protected BrokerFactory getBrokerFactory(String[] args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("odd number of elements in arg array");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.getEmf(map));
    }

    protected OpenJPAEntityManager currentEntityManager() {
        if (this.currentEntityManager == null || !this.currentEntityManager.isOpen()) {
            this.currentEntityManager = this.getEmf().createEntityManager();
        }
        return this.currentEntityManager;
    }

    protected void startTx(EntityManager em) {
        em.getTransaction().begin();
    }

    protected boolean isActiveTx(EntityManager em) {
        return em.getTransaction().isActive();
    }

    protected void endTx(EntityManager em) {
        if (em.getTransaction().isActive()) {
            if (em.getTransaction().getRollbackOnly()) {
                em.getTransaction().rollback();
            } else {
                em.getTransaction().commit();
            }
        }
    }

    protected void rollbackTx(EntityManager em) {
        em.getTransaction().rollback();
    }

    protected void endEm(EntityManager em) {
        if (em != null && em.isOpen()) {
            em.close();
        }
        if (em == this.currentEntityManager) {
            this.currentEntityManager = null;
        }
    }

    protected Object getStackTrace(Throwable t) {
        throw new UnsupportedOperationException();
    }

    protected OpenJPAConfiguration getConfiguration() {
        return this.getEmf().getConfiguration();
    }

    protected Platform getCurrentPlatform() {
        throw new UnsupportedOperationException();
    }

    protected void bug(int id, String s) {
        this.bug(id, null, s);
    }

    protected void bug(Platform platform, int id, Throwable t, String s) {
        this.bug(EnumSet.of(platform), id, t, s);
    }

    protected void bug(EnumSet<Platform> platforms, int id, Throwable t, String s) {
        if (platforms.contains((Object)this.getCurrentPlatform())) {
            this.bug(id, t, s);
        } else {
            AbstractTestCase.fail((String)String.format("bug %s is unexpectedly occurring on platform %s", new Object[]{id, this.getCurrentPlatform()}));
        }
    }

    protected void bug(int id, Throwable t, String s) {
        if (t != null) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        AbstractTestCase.fail((String)s);
    }

    public static Integer randomInt() {
        return new Integer((int)(Math.random() * 2.147483647E9));
    }

    public static Character randomChar() {
        char[] TEST_CHAR_ARRAY = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return new Character(TEST_CHAR_ARRAY[(int)(Math.random() * (double)TEST_CHAR_ARRAY.length)]);
    }

    public static Long randomLong() {
        return new Long((long)(Math.random() * 9.223372036854776E18));
    }

    public static Short randomShort() {
        return new Short((short)(Math.random() * 32767.0));
    }

    public static Double randomDouble() {
        return new Double((double)Math.round(Math.random() * 5000.0) / 1000.0);
    }

    public static Float randomFloat() {
        return new Float((float)Math.round(Math.random() * 5000.0) / 1000.0f);
    }

    public static Byte randomByte() {
        return new Byte((byte)(Math.random() * 127.0));
    }

    public static Boolean randomBoolean() {
        return new Boolean(Math.random() > 0.5);
    }

    public static Date randomDate() {
        long millis = (long)(Math.random() * (double)System.currentTimeMillis());
        millis -= millis % 1000L;
        return new Date(millis);
    }

    public static String randomString() {
        return AbstractTestCase.randomString(50);
    }

    public static String randomString(int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < (int)(Math.random() * (double)len) + 1; ++i) {
            buf.append(AbstractTestCase.randomChar());
        }
        return buf.toString();
    }

    public static String randomClob() {
        StringBuffer sbuf = new StringBuffer();
        while (sbuf.length() < 5120) {
            sbuf.append(AbstractTestCase.randomString(1024));
        }
        return sbuf.toString();
    }

    public static BigInteger randomBigInteger() {
        BigInteger lng = new BigInteger((long)(Math.random() * 9.223372036854776E18) + "");
        BigInteger multiplier = new BigInteger("1");
        if (Math.random() < 0.5) {
            multiplier = multiplier.multiply(new BigInteger("-1"));
        }
        return lng.multiply(multiplier);
    }

    public static BigDecimal randomBigDecimal() {
        BigInteger start = AbstractTestCase.randomBigInteger();
        String str = start.toString();
        for (int i = 0; i < 8; ++i) {
            if (str.length() <= 2) continue;
            str = str.substring(0, str.length() - 1);
        }
        start = new BigInteger(str);
        String val = start + "." + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0);
        return new BigDecimal(val);
    }

    public static byte[] randomBlob() {
        byte[] blob = new byte[(int)(Math.random() * 1024.0 * 100.0)];
        for (int i = 0; i < blob.length; ++i) {
            blob[i] = AbstractTestCase.randomByte();
        }
        return blob;
    }

    public static Object randomizeBean(Object bean) throws javax.management.IntrospectionException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            Class<?>[] params;
            Method write = props[i].getWriteMethod();
            if (write == null || (params = write.getParameterTypes()) == null || params.length != 1) continue;
            Class<?> paramType = params[0];
            Object arg = null;
            if (paramType == Boolean.TYPE || paramType == Boolean.class) {
                arg = AbstractTestCase.randomBoolean();
            } else if (paramType == Byte.TYPE || paramType == Byte.class) {
                arg = AbstractTestCase.randomByte();
            } else if (paramType == Character.TYPE || paramType == Character.class) {
                arg = AbstractTestCase.randomChar();
            } else if (paramType == Short.TYPE || paramType == Short.class) {
                arg = AbstractTestCase.randomShort();
            } else if (paramType == Integer.TYPE || paramType == Integer.class) {
                arg = AbstractTestCase.randomInt();
            } else if (paramType == Long.TYPE || paramType == Long.class) {
                arg = AbstractTestCase.randomLong();
            } else if (paramType == Double.TYPE || paramType == Double.class) {
                arg = AbstractTestCase.randomDouble();
            } else if (paramType == Float.TYPE || paramType == Float.class) {
                arg = AbstractTestCase.randomFloat();
            } else if (paramType == String.class) {
                arg = AbstractTestCase.randomString();
            } else if (paramType == BigInteger.class) {
                arg = AbstractTestCase.randomBigInteger();
            } else if (paramType == BigDecimal.class) {
                arg = AbstractTestCase.randomBigDecimal();
            } else if (paramType == Date.class) {
                arg = AbstractTestCase.randomDate();
            }
            if (arg == null) continue;
            write.invoke(bean, arg);
        }
        return bean;
    }

    protected void assertSize(int size, Collection c) {
        AbstractTestCase.assertEquals((int)size, (int)c.size());
    }

    protected void assertSize(int size, Query q) {
        AbstractTestCase.assertEquals((int)size, (int)q.getResultList().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object roundtrip(Object orig, boolean validateEquality) throws IOException, ClassNotFoundException {
        AbstractTestCase.assertNotNull((Object)orig);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(orig);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bin);
        Object result = in.readObject();
        try {
            if (validateEquality) {
                AbstractTestCase.assertEquals((int)orig.hashCode(), (int)result.hashCode());
                AbstractTestCase.assertEquals((Object)orig, (Object)result);
            }
        }
        finally {
            out.close();
            in.close();
        }
        return result;
    }

    public static boolean matches(String regex, String input) throws RESyntaxException {
        RE re = REUtil.createRE((String)regex);
        return re.match(input);
    }

    public static void assertMatches(String regex, String input) {
        try {
            if (!AbstractTestCase.matches(regex, input)) {
                AbstractTestCase.fail((String)("Expected regular expression: <" + regex + ">" + " did not match: <" + input + ">"));
            }
        }
        catch (RESyntaxException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static void assertNotMatches(String regex, String input) {
        try {
            if (AbstractTestCase.matches(regex, input)) {
                AbstractTestCase.fail((String)("Regular expression: <" + regex + ">" + " should not match: <" + input + ">"));
            }
        }
        catch (RESyntaxException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static List matches(String regex, Collection input) throws RESyntaxException {
        ArrayList<String> matches = new ArrayList<String>();
        for (String check : input) {
            if (!AbstractTestCase.matches(regex, check)) continue;
            matches.add(check);
        }
        return matches;
    }

    public static void assertMatches(String regex, Collection input) {
        try {
            if (AbstractTestCase.matches(regex, input).size() == 0) {
                AbstractTestCase.fail((String)("The specified list of size " + input.size() + " did not contain any strings that match the" + " specified regular expression(\"" + regex + "\")"));
            }
        }
        catch (RESyntaxException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static void assertNotMatches(String regex, Collection input) {
        try {
            List matches = AbstractTestCase.matches(regex, input);
            if (matches.size() > 0) {
                AbstractTestCase.fail((String)("The specified list of size " + input.size() + " did contain one or more strings that matchs the" + " specified illegal regular expression" + " (\"" + regex + "\")." + " First example of a matching message is: " + matches.iterator().next()));
            }
        }
        catch (RESyntaxException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    protected Log getLog() {
        return this.getConfiguration().getLog("Tests");
    }

    public void mttest() throws ThreadingException {
        int iterations = 6;
        int threads = 8;
        this.mttest(threads, iterations);
    }

    public void mttest(int threads, int iterations) {
        this.mttest(0, threads, iterations);
    }

    public void mttest(int serialCount, int threads, int iterations) throws ThreadingException {
        String methodName = this.callingMethod("mttest");
        this.mttest(serialCount, threads, iterations, methodName, new Object[0]);
    }

    public void mttest(int threads, int iterations, String method, Object[] args) throws ThreadingException {
        this.mttest(0, threads, iterations, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mttest(int serialCount, int threads, int iterations, String method, Object[] args) throws ThreadingException {
        if (this.multiThreadExecuting != null && this.multiThreadExecuting.equals(method)) {
            return;
        }
        this.multiThreadExecuting = method;
        try {
            Method meth;
            Class[] paramClasses = new Class[args.length];
            for (int i = 0; i < paramClasses.length; ++i) {
                paramClasses[i] = args[i].getClass();
            }
            try {
                meth = ((Object)((Object)this)).getClass().getMethod(method, paramClasses);
            }
            catch (NoSuchMethodException nsme) {
                throw new ThreadingException(nsme.toString(), nsme);
            }
            AbstractTestCase thiz = this;
            this.mttest("reflection invocation: (" + method + ")", serialCount, threads, iterations, new VolatileRunnable((Object)thiz, args){
                final /* synthetic */ Object val$thiz;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$thiz = object;
                    this.val$args = objectArray;
                }

                @Override
                public void run() throws Exception {
                    meth.invoke(this.val$thiz, this.val$args);
                }
            });
        }
        finally {
            this.multiThreadExecuting = null;
        }
    }

    public void mttest(String title, int threads, int iterations, VolatileRunnable runner) throws ThreadingException {
        this.mttest(title, 0, threads, iterations, runner);
    }

    public void mttest(String title, int serialCount, final int threads, final int iterations, final VolatileRunnable runner) throws ThreadingException {
        int i;
        final List exceptions = Collections.synchronizedList(new LinkedList());
        Thread[] runners = new Thread[threads];
        final long startMillis = System.currentTimeMillis() + 1000L;
        for (i = 1; i <= threads; ++i) {
            final int thisThread = i;
            runners[i - 1] = new Thread(title + " [" + i + " of " + threads + "]"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int thisIteration;
                    while (System.currentTimeMillis() < startMillis) {
                        2.yield();
                    }
                    try {
                        for (thisIteration = 1; thisIteration <= iterations; ++thisIteration) {
                            runner.run();
                        }
                    }
                    catch (Throwable error) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(new ThreadingException("thread=" + this.toString() + ";threadNum=" + thisThread + ";maxThreads=" + threads + ";iteration=" + thisIteration + ";maxIterations=" + iterations, error));
                        }
                    }
                }
            };
        }
        for (i = 0; i < serialCount; ++i) {
            runners[0].run();
        }
        for (i = 0; i < threads; ++i) {
            runners[i].start();
        }
        for (i = 0; i < threads; ++i) {
            try {
                runners[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (exceptions.size() == 0) {
            return;
        }
        Throwable[] errors = exceptions.toArray(new Throwable[0]);
        throw new ThreadingException("The " + errors.length + " embedded errors " + "occured in the execution of " + iterations + " iterations " + "of " + threads + " threads: [" + title + "]", errors);
    }

    public boolean isRootThread() {
        return this.multiThreadExecuting == null;
    }

    public String callingMethod(String exclude) {
        StringWriter sw = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(sw));
        StringTokenizer stackTrace = new StringTokenizer(sw.toString(), System.getProperty("line.separator"));
        while (stackTrace.hasMoreTokens()) {
            String fullMethodName;
            String shortMethodName;
            String line = stackTrace.nextToken().trim();
            if (!line.startsWith("at ") || (shortMethodName = (fullMethodName = line.substring(0, line.indexOf("("))).substring(fullMethodName.lastIndexOf(".") + 1)).equals("callingMethod") || exclude != null && shortMethodName.equals(exclude)) continue;
            return shortMethodName;
        }
        throw new IllegalStateException("Could not identify calling method in stack trace");
    }

    public void sleepRandom() {
        this.sleepRandom(1000);
    }

    public void sleepRandom(int max) {
        try {
            Thread.currentThread();
            Thread.sleep((long)(Math.random() * (double)max));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean timeout(long millis) throws Throwable {
        String methodName = this.callingMethod("timeout");
        return this.timeout(millis, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timeout(long millis, String methodName) throws Throwable {
        if (this.inTimeoutThread) {
            return false;
        }
        this.inTimeoutThread = true;
        long endTime = System.currentTimeMillis() + millis;
        try {
            final Method method = ((Object)((Object)this)).getClass().getMethod(methodName, null);
            AbstractTestCase thz = this;
            TimeOutThread tot = new TimeOutThread("TimeOutThread [" + methodName + "] (" + millis + "ms)", (Object)thz){
                final /* synthetic */ Object val$thz;
                {
                    this.val$thz = object;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        method.invoke(this.val$thz, (Object[])null);
                    }
                    catch (Throwable t) {
                        this.throwable = t;
                    }
                    finally {
                        this.completed = true;
                    }
                }
            };
            tot.start();
            tot.join(millis);
            if (System.currentTimeMillis() >= endTime) {
                try {
                    tot.interrupt();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                Thread.currentThread();
                Thread.sleep(500L);
                try {
                    tot.stop();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                Thread.currentThread();
                Thread.sleep(500L);
                throw new OperationTimedOutException("Execution of \"" + methodName + "\" timed out after " + millis + " milliseconds", tot.throwable);
            }
            if (tot.throwable != null) {
                throw tot.throwable;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.inTimeoutThread = false;
        }
    }

    public static void validateCollection(Collection collection) {
        int size = collection.size();
        int iterated = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            ++iterated;
            i.next();
        }
        AbstractTestCase.assertEquals((int)size, (int)iterated);
        if (collection instanceof List) {
            ArrayList<Integer> ll = new ArrayList<Integer>();
            for (int i2 = 0; i2 < 100; ++i2) {
                ll.add(new Integer(i2));
            }
            AbstractTestCase.validateList(ll);
            AbstractTestCase.validateList((List)collection);
        }
    }

    public static void validateList(List list) {
        int i;
        Object[] coreValues = list.toArray();
        Object[] values1 = new Object[list.size()];
        Object[] values2 = new Object[list.size()];
        Object[] values3 = new Object[list.size()];
        Object[] values4 = new Object[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            values1[i2] = list.get(i2);
        }
        int index = 0;
        ListIterator iter = list.listIterator(0);
        while (iter.hasNext()) {
            AbstractTestCase.assertEquals((int)index, (int)iter.nextIndex());
            AbstractTestCase.assertEquals((int)index, (int)(iter.previousIndex() + 1));
            values2[index] = iter.next();
            AbstractTestCase.assertTrue((boolean)list.contains(values2[index]));
            ++index;
        }
        try {
            iter.next();
            AbstractTestCase.fail((String)"next() should have resulted in a NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        int back = 0;
        iter = list.listIterator(list.size());
        while (iter.hasPrevious()) {
            AbstractTestCase.assertEquals((int)index, (int)(iter.previousIndex() + 1));
            AbstractTestCase.assertEquals((int)index, (int)iter.nextIndex());
            values3[--index] = iter.previous();
            ++back;
        }
        AbstractTestCase.assertEquals((int)list.size(), (int)back);
        try {
            iter.previous();
            AbstractTestCase.fail((String)"previous() should have resulted in a NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        LinkedList<Integer> indices = new LinkedList<Integer>();
        for (i = 0; i < list.size(); ++i) {
            indices.add(new Integer(i));
        }
        for (i = 0; i < list.size(); ++i) {
            int rand = (int)(Math.random() * (double)indices.size());
            Integer randIndex = (Integer)indices.remove(rand);
            values4[randIndex.intValue()] = list.get(randIndex);
        }
        AbstractTestCase.assertEquals(Arrays.asList(coreValues), Arrays.asList(values1));
        AbstractTestCase.assertIdentical(Arrays.asList(coreValues), Arrays.asList(values1));
        AbstractTestCase.assertEquals(Arrays.asList(coreValues), Arrays.asList(values2));
        AbstractTestCase.assertIdentical(Arrays.asList(coreValues), Arrays.asList(values2));
        AbstractTestCase.assertEquals(Arrays.asList(coreValues), Arrays.asList(values4));
        AbstractTestCase.assertIdentical(Arrays.asList(coreValues), Arrays.asList(values4));
        AbstractTestCase.assertEquals(Arrays.asList(coreValues), Arrays.asList(values3));
        AbstractTestCase.assertIdentical(Arrays.asList(coreValues), Arrays.asList(values3));
    }

    public static void assertIdentical(List c1, List c2) {
        AbstractTestCase.assertEquals((int)c1.size(), (int)c2.size());
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            AbstractTestCase.assertTrue((i1.next() == i2.next() ? 1 : 0) != 0);
        }
    }

    public void assertOrdered(Collection c, Comparator comp) {
        LinkedList l1 = new LinkedList(c);
        LinkedList l2 = new LinkedList(c);
        AbstractTestCase.assertEquals(l1, l2);
        Collections.sort(l2, comp);
        AbstractTestCase.assertEquals(l1, l2);
        Collections.sort(l1, comp);
        AbstractTestCase.assertEquals(l1, l2);
    }

    public static class OperationTimedOutException
    extends RuntimeException {
        private final Throwable _err;

        public OperationTimedOutException(String msg, Throwable throwable) {
            super(msg);
            this._err = throwable;
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.out);
        }

        @Override
        public void printStackTrace(PrintStream out) {
            this.printStackTrace(new PrintWriter(out));
        }

        @Override
        public void printStackTrace(PrintWriter out) {
            super.printStackTrace(out);
            if (this._err != null) {
                out.print("Nested Throwable: ");
                this._err.printStackTrace(out);
            }
        }
    }

    private static class TimeOutThread
    extends Thread {
        public Throwable throwable = null;
        public boolean completed = false;

        public TimeOutThread(String name) {
            super(name);
            this.setDaemon(true);
        }
    }

    public class ThreadingException
    extends RuntimeException {
        private final Throwable[] _nested;

        public ThreadingException(String msg, Throwable nested) {
            super(msg);
            this._nested = nested == null ? new Throwable[0] : new Throwable[]{nested};
        }

        public ThreadingException(String msg, Throwable[] nested) {
            super(msg);
            this._nested = nested == null ? new Throwable[0] : nested;
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.out);
        }

        @Override
        public void printStackTrace(PrintStream out) {
            this.printStackTrace(new PrintWriter(out));
        }

        @Override
        public void printStackTrace(PrintWriter out) {
            super.printStackTrace(out);
            for (int i = 0; i < this._nested.length; ++i) {
                out.print("Nested Throwable #" + (i + 1) + ": ");
                this._nested[i].printStackTrace(out);
            }
        }
    }

    public static interface VolatileRunnable {
        public void run() throws Exception;
    }

    protected static enum Platform {
        EMPRESS,
        HYPERSONIC,
        POSTGRESQL,
        MARIADB,
        MYSQL,
        SQLSERVER,
        DB2,
        ORACLE,
        DERBY,
        INFORMIX,
        POINTBASE,
        SYBASE,
        INGRES;

    }
}

